System.register(["app/core/table_model"], function (exports_1, context_1) {
    "use strict";
    var table_model_1, CONNEXIVEDatasource;
    var __moduleName = context_1 && context_1.id;
    return {
        setters: [
            function (table_model_1_1) {
                table_model_1 = table_model_1_1;
            }
        ],
        execute: function () {
            CONNEXIVEDatasource = (function () {
                function CONNEXIVEDatasource(instanceSettings, backendSrv, $q, templateSrv) {
                    this.backendSrv = backendSrv;
                    this.$q = $q;
                    this.templateSrv = templateSrv;
                    this.LOGIN_URL = null;
                    this.HEALTH_CHECK_URL = null;
                    this.QUERY_URL = null;
                    this.BUCKETS_URL = null;
                    this.DEVICES_URL = null;
                    this.log("CONNEXIVE datasource: constructor");
                    this.tenantName = instanceSettings.jsonData.tenantName;
                    this.baseUri = instanceSettings.url;
                    this.headers = {
                        "Content-Type": "application/json",
                        "X-Application-Id": instanceSettings.jsonData.appId,
                        "X-Application-Key": instanceSettings.jsonData.appKey,
                        "X-User-Name": instanceSettings.jsonData.userName,
                        "X-User-Password": instanceSettings.jsonData.password
                    };
                    this.body = "{\"username\": \"" + instanceSettings.jsonData.userName + "\", \"password\": \"" + instanceSettings.jsonData.password + "\"}";
                    this.withCredentials = true;
                    this.cacheBuckets = null;
                    this.deferreds = null;
                    this.cacheDevices = null;
                    this.LOGIN_URL = this.baseUri + "/api/1/" + this.tenantName + "/api/broker/login";
                    this.HEALTH_CHECK_URL = this.baseUri + "/api/1/storedata/health";
                    this.QUERY_URL = this.baseUri + "/api/1/" + this.tenantName + "/api/storedata/query/";
                    this.BUCKETS_URL = this.baseUri + "/management/buckets";
                    this.DEVICES_URL = this.baseUri + "/management/devices";
                }
                CONNEXIVEDatasource.prototype.log = function (msg) {
                    console.log(msg);
                };
                CONNEXIVEDatasource.prototype.query = function (options) {
                    var _this = this;
                    this.log("query: " + JSON.stringify(options));
                    var targets = this.buildQueryParameters(options)
                        .filter(function (t) { return !t.hide && t.bucket; })
                        .filter(function (t) {
                        t.dataField = t.dataField.filter(function (f) { return f.fieldName; });
                        return t.dataField.length != 0;
                    });
                    if (targets.length <= 0) {
                        return Promise.resolve({ data: [] });
                    }
                    var reqTargets = this.filterSameRequest(targets);
                    var promises = this.doRequestTargets(reqTargets, options);
                    return Promise.all(promises)
                        .then(function (responses) {
                        var results = [];
                        for (var _i = 0, targets_1 = targets; _i < targets_1.length; _i++) {
                            var target = targets_1[_i];
                            var data = responses[target.reqIndex].data;
                            if (target.format === 'table') {
                                if (target.createDataWith === 'series_name_value_key') {
                                    results.push.apply(results, _this.convertResponseToTableWithSeries(target, data));
                                }
                                else {
                                    results.push.apply(results, _this.convertResponseToTableWithDataField(target, data));
                                }
                            }
                            else {
                                target.format = 'time_series';
                                if (target.createDataWith === 'series_name_value_key') {
                                    results.push.apply(results, _this.convertResponseWithSeries(target, data, options));
                                }
                                else {
                                    results.push.apply(results, _this.convertResponseWithDataField(target, data, options));
                                }
                            }
                        }
                        return { data: results };
                    });
                };
                CONNEXIVEDatasource.prototype.buildQueryParameters = function (options) {
                    var _this = this;
                    var targets = [];
                    if (!options.targets) {
                        return targets;
                    }
                    var _loop_1 = function (target) {
                        var dataField = target.dataField;
                        dataField = dataField.map(function (f) {
                            return { fieldName: _this.templateSrv.replace(f.fieldName), alias: f.alias };
                        });
                        var deviceNames = this_1.templateSrv.replace(target.deviceName).split(",");
                        deviceNames.forEach(function (deviceName) {
                            var buckets = _this.templateSrv.replace(target.bucket).split(",");
                            buckets.forEach(function (bucket) {
                                targets.push({
                                    bucket: bucket,
                                    deviceName: deviceName,
                                    format: target.format || "time_series",
                                    dataField: dataField,
                                    tsField: _this.templateSrv.replace(target.tsField) || "updatedAt",
                                    aggr: target.aggr,
                                    hide: target.hide,
                                    createDataWith: target.createDataWith || "data_field",
                                    seriesNameKey: _this.templateSrv.replace(target.seriesNameKey),
                                    seriesValueKey: _this.templateSrv.replace(target.seriesValueKey)
                                });
                            });
                        });
                    };
                    var this_1 = this;
                    for (var _i = 0, _a = options.targets; _i < _a.length; _i++) {
                        var target = _a[_i];
                        _loop_1(target);
                    }
                    return targets;
                };
                CONNEXIVEDatasource.prototype.filterSameRequest = function (targets) {
                    var reqTargets = [];
                    for (var _i = 0, targets_2 = targets; _i < targets_2.length; _i++) {
                        var target = targets_2[_i];
                        target.reqIndex = null;
                        var targetAggrObj = {};
                        if (target.aggr) {
                            targetAggrObj = JSON.parse(target.aggr);
                        }
                        for (var i = 0; i < reqTargets.length; i++) {
                            var reqTarget = reqTargets[i];
                            var reqTargetAggrObj = {};
                            if (reqTarget.aggr) {
                                reqTargetAggrObj = JSON.parse(reqTarget.aggr);
                            }
                            if (target.bucket == reqTarget.bucket
                                && target.tsField == reqTarget.tsField
                                && target.deviceName == reqTarget.deviceName
                                && JSON.stringify(targetAggrObj) === JSON.stringify(reqTargetAggrObj)) {
                                target.reqIndex = i;
                                break;
                            }
                        }
                        if (target.reqIndex == null) {
                            target.reqIndex = reqTargets.length;
                            reqTargets.push(target);
                        }
                    }
                    return reqTargets;
                };
                CONNEXIVEDatasource.prototype.doRequestTargets = function (targets, options) {
                    var _this = this;
                    var promises = [];
                    var _loop_2 = function (target) {
                        var bucketName = target.bucket;
                        var aggr = target.aggr;
                        var mainTsField = target.tsField;
                        var gte = {};
                        gte[mainTsField] = { "$gte": options.range.from };
                        var lte = {};
                        lte[mainTsField] = { "$lte": options.range.to };
                        ;
                        var whereAnd = [gte, lte];
                        var rangeFrom = new Date(options.range.from).toISOString();
                        var rangeTo = new Date(options.range.to).toISOString();
                        var encodedquery = encodeURI("filter={\"deviceId\":\"" + target.deviceName + "\",\"" + mainTsField + "\":{$gte:\"" + rangeFrom + "\",$lte:\"" + rangeTo + "\"}}&limit=-1");
                        var req = void 0;
                        var data = {};
                        if (!aggr) {
                            data = {
                                where: { "$and": whereAnd },
                                order: mainTsField,
                                limit: options.maxDataPoints
                            };
                        }
                        else {
                            var pipeline = JSON.parse(aggr);
                            pipeline.unshift({ "$match": { "$and": whereAnd } });
                            pipeline.push({ "$limit": options.maxDataPoints });
                        }
                        var self_1 = this_2;
                        console.log('login');
                        var promise = this_2.backendSrv.datasourceRequest({
                            method: 'POST',
                            url: this_2.LOGIN_URL,
                            headers: this_2.headers,
                            withCredentials: this_2.withCredentials,
                            data: this_2.body
                        }).then(function (result) {
                            var sessionToken = result.data.sessionToken;
                            var headers = self_1.headers;
                            headers["X-Session-Token"] = sessionToken;
                            console.log('query');
                            return self_1.backendSrv.datasourceRequest({
                                method: 'GET',
                                url: "" + _this.QUERY_URL + bucketName + "?" + encodedquery,
                                headers: headers,
                                withCredentials: true
                            });
                        });
                        promises.push(promise);
                    };
                    var this_2 = this;
                    for (var _i = 0, targets_3 = targets; _i < targets_3.length; _i++) {
                        var target = targets_3[_i];
                        _loop_2(target);
                    }
                    return promises;
                };
                CONNEXIVEDatasource.prototype.convertResponseWithDataField = function (target, data, options) {
                    var results = [];
                    for (var _i = 0, _a = target.dataField; _i < _a.length; _i++) {
                        var field = _a[_i];
                        var alias = field.alias || target.bucket + '.' + field.fieldName;
                        var datapoints = [];
                        for (var _b = 0, _c = data.results; _b < _c.length; _b++) {
                            var e = _c[_b];
                            var datapoint = this.convertToDataPoint(e, field.fieldName, target.tsField, options);
                            if (datapoint) {
                                datapoints.push(datapoint);
                            }
                        }
                        results.push({
                            target: alias,
                            datapoints: datapoints
                        });
                    }
                    return results;
                };
                CONNEXIVEDatasource.prototype.convertResponseWithSeries = function (target, data, options) {
                    var results = [];
                    var _loop_3 = function (e) {
                        var name_1 = this_3.extractValue(e, target.seriesNameKey);
                        if (name_1 == null) {
                            return "continue";
                        }
                        var datapoint = this_3.convertToDataPoint(e, target.seriesValueKey, target.tsField, options);
                        if (datapoint) {
                            var findIndex = results.findIndex(function (result) { return result.target === name_1; });
                            if (findIndex < 0) {
                                results.push({
                                    target: name_1,
                                    datapoints: [datapoint]
                                });
                            }
                            else {
                                results[findIndex].datapoints.push(datapoint);
                            }
                        }
                    };
                    var this_3 = this;
                    for (var _i = 0, _a = data.results; _i < _a.length; _i++) {
                        var e = _a[_i];
                        _loop_3(e);
                    }
                    return results;
                };
                CONNEXIVEDatasource.prototype.convertToDataPoint = function (element, valueKey, tsField, options) {
                    var value = this.extractValue(element, valueKey);
                    var ts = this.extractTimestamp(element, tsField);
                    if (value == null) {
                        return null;
                    }
                    var datapoint = [];
                    if (ts != null) {
                        datapoint = [value, ts.getTime()];
                    }
                    else {
                        datapoint = [value, Date.parse(options.range.to)];
                    }
                    return datapoint;
                };
                CONNEXIVEDatasource.prototype.convertResponseToTableWithDataField = function (target, data, table) {
                    var labels = [];
                    table = table || new table_model_1.default();
                    for (var _i = 0, _a = data.results; _i < _a.length; _i++) {
                        var e = _a[_i];
                        var ts = this.extractValue(e, target.tsField);
                        if (ts != null) {
                            table.addColumn({ text: 'Time' });
                            labels.push(target.tsField);
                            break;
                        }
                    }
                    var _loop_4 = function (field) {
                        var fieldName = field.fieldName;
                        if (fieldName != null) {
                            var alias_1 = field.alias || target.bucket + '.' + fieldName;
                            var findIndex = table.columns.findIndex(function (column) { return column.text === alias_1; });
                            if (findIndex < 0) {
                                table.addColumn({ text: alias_1 });
                                labels.push(fieldName);
                            }
                        }
                    };
                    for (var _b = 0, _c = target.dataField; _b < _c.length; _b++) {
                        var field = _c[_b];
                        _loop_4(field);
                    }
                    for (var _d = 0, _e = data.results; _d < _e.length; _d++) {
                        var e = _e[_d];
                        var row = [];
                        var hasData = false;
                        for (var i = 0; i < labels.length; i++) {
                            if (i === 0 && labels[i] === target.tsField && table.columns[i].text === 'Time') {
                                var ts = this.extractTimestamp(e, target.tsField);
                                if (ts != null) {
                                    row.push(ts.getTime());
                                }
                                else {
                                    row.push(null);
                                }
                            }
                            else {
                                var value = this.extractValue(e, labels[i]);
                                if (value != null) {
                                    row.push(value);
                                    hasData = true;
                                }
                                else {
                                    row.push(null);
                                }
                            }
                        }
                        if (hasData) {
                            table.addRow(row);
                        }
                    }
                    return [table];
                };
                CONNEXIVEDatasource.prototype.convertResponseToTableWithSeries = function (target, data, table) {
                    table = table || new table_model_1.default();
                    for (var _i = 0, _a = data.results; _i < _a.length; _i++) {
                        var e = _a[_i];
                        var ts = this.extractValue(e, target.tsField);
                        if (ts != null) {
                            table.addColumn({ text: 'Time' });
                            break;
                        }
                    }
                    table.addColumn({ text: target.seriesNameKey });
                    table.addColumn({ text: target.seriesValueKey });
                    var _loop_5 = function (e) {
                        var row = [];
                        var name_2 = this_4.extractValue(e, target.seriesNameKey);
                        var value = this_4.extractValue(e, target.seriesValueKey);
                        if (name_2 == null || value == null) {
                            return "continue";
                        }
                        if (table.columns[0].text === 'Time' && table.columns.length >= 3) {
                            var ts = this_4.extractTimestamp(e, target.tsField);
                            if (ts != null) {
                                row.push(ts.getTime());
                            }
                            else {
                                row.push(null);
                            }
                        }
                        row.push(name_2);
                        row.push(value);
                        var findIndex = table.rows.findIndex(function (findRow) { return findRow[table.columns.length - 2] === name_2; });
                        if (findIndex < 0) {
                            table.addRow(row);
                        }
                        else {
                            table.rows[findIndex] = row;
                        }
                    };
                    var this_4 = this;
                    for (var _b = 0, _c = data.results; _b < _c.length; _b++) {
                        var e = _c[_b];
                        _loop_5(e);
                    }
                    return [table];
                };
                CONNEXIVEDatasource.prototype.extractValue = function (obj, key) {
                    var keys = key.split('.');
                    for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
                        var key_1 = keys_1[_i];
                        if (obj != null && typeof obj === 'object' && key_1 in obj) {
                            obj = obj[key_1];
                        }
                        else {
                            return null;
                        }
                    }
                    return obj;
                };
                CONNEXIVEDatasource.prototype.extractTimestamp = function (obj, tsField) {
                    if (tsField != null) {
                        var ts = this.extractValue(obj, tsField);
                        if (ts != null) {
                            return new Date(ts);
                        }
                        else {
                            return null;
                        }
                    }
                    return null;
                };
                CONNEXIVEDatasource.prototype.testDatasource = function () {
                    var _this = this;
                    this.log("testDatasource");
                    return this.backendSrv.datasourceRequest({
                        method: 'POST',
                        url: this.LOGIN_URL,
                        headers: this.headers,
                        withCredentials: this.withCredentials,
                        data: this.body
                    })
                        .then(function (response) {
                        _this.log("status: " + response.status);
                        var result = { status: "success", message: "Server connected" };
                        return result;
                    }, function (error) {
                        var message;
                        if (error.data && error.data.error) {
                            message = error.data.error;
                        }
                        else if (error.statusText) {
                            message = "HTTP Error (" + error.status + ") " + error.statusText;
                        }
                        else {
                            message = "Connection failed";
                        }
                        var result = { status: "error", message: message };
                        return result;
                    });
                };
                CONNEXIVEDatasource.prototype.annotationQuery = function (options) {
                    return null;
                };
                CONNEXIVEDatasource.prototype.metricFindQuery = function (query, target) {
                    var _this = this;
                    this.log("metricFindQuery: " + query);
                    if (query == 'bucket') {
                        if (this.cacheBuckets != null) {
                            return Promise.resolve(this.cacheBuckets);
                        }
                    }
                    else if (query == 'device') {
                        if (this.cacheDevices != null) {
                            return Promise.resolve(this.cacheDevices);
                        }
                    }
                    else {
                        return Promise.resolve([]);
                    }
                    if (this.deferreds != null) {
                        this.log("metricFindQuery deferred");
                        var deferred = this.$q.defer();
                        this.deferreds.push(deferred);
                        return deferred.promise;
                    }
                    this.deferreds = [];
                    var url;
                    if (query == 'bucket') {
                        url = this.BUCKETS_URL;
                    }
                    else if (query == 'device') {
                        url = this.DEVICES_URL;
                    }
                    return this.backendSrv.datasourceRequest({
                        method: 'GET',
                        url: url,
                        headers: this.headers,
                        withCredentials: this.withCredentials
                    })
                        .then(function (response) {
                        var results = [];
                        if (query == 'bucket') {
                            for (var _i = 0, _a = response.data.results; _i < _a.length; _i++) {
                                var result = _a[_i];
                                var bucket = result.name;
                                results.push({ text: bucket, value: bucket });
                            }
                            _this.cacheBuckets = results;
                        }
                        else if (query == 'device') {
                            for (var _b = 0, _c = response.data.deviceIds; _b < _c.length; _b++) {
                                var result = _c[_b];
                                var bucket = result.name;
                                results.push({ text: bucket, value: bucket });
                            }
                            _this.cacheDevices = results;
                        }
                        for (var _d = 0, _e = _this.deferreds; _d < _e.length; _d++) {
                            var deferred = _e[_d];
                            deferred.resolve(results);
                        }
                        _this.deferreds = null;
                        return results;
                    }, function (error) {
                        _this.log("metricFindQuery error");
                        var results = [];
                        for (var _i = 0, _a = _this.deferreds; _i < _a.length; _i++) {
                            var deferred = _a[_i];
                            deferred.resolve(results);
                        }
                        _this.deferreds = null;
                        return results;
                    });
                };
                CONNEXIVEDatasource.prototype.getLatestObject = function (bucket) {
                    var _this = this;
                    this.log("getLatestObject: " + bucket);
                    var encodedquery = encodeURI("limit=1&order=-updatedAt");
                    return this.backendSrv.datasourceRequest({
                        method: 'GET',
                        url: "" + this.QUERY_URL + bucket + "?" + encodedquery,
                        headers: this.headers,
                        withCredentials: this.withCredentials
                    })
                        .then(function (response) {
                        if (response.data.results.length == 1) {
                            _this.log("latest object: " + JSON.stringify(response.data.results[0]));
                            return response.data.results[0];
                        }
                        else {
                            return {};
                        }
                    }).catch(function (e) {
                        return {};
                    });
                };
                return CONNEXIVEDatasource;
            }());
            exports_1("CONNEXIVEDatasource", CONNEXIVEDatasource);
        }
    };
});
//# sourceMappingURL=data:application/json;base64,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