System.register([], function (exports_1, context_1) {
    "use strict";
    var FieldCompleter;
    var __moduleName = context_1 && context_1.id;
    return {
        setters: [],
        execute: function () {
            FieldCompleter = (function () {
                function FieldCompleter(datasource, bucket) {
                    this.datasource = datasource;
                    this.bucket = bucket;
                    this.objCache = null;
                }
                FieldCompleter.prototype.getCompletions = function (editor, session, pos, prefix, callback) {
                    var _this = this;
                    if (!this.bucket || pos.row != 0) {
                        callback(null, []);
                        return;
                    }
                    if (this.objCache != null) {
                        var completions = this.buildCompletions(this.objCache, session.toString(), pos.column);
                        callback(null, completions);
                    }
                    else {
                        this.datasource.getLatestObject(this.bucket)
                            .then(function (obj) {
                            _this.objCache = obj;
                            var completions = _this.buildCompletions(obj, session.toString(), pos.column);
                            callback(null, completions);
                        });
                    }
                };
                FieldCompleter.prototype.setBucket = function (bucket) {
                    this.bucket = bucket;
                    this.clearCache();
                };
                FieldCompleter.prototype.clearCache = function () {
                    this.objCache = null;
                };
                FieldCompleter.prototype.buildCompletions = function (obj, inputStr, cursor) {
                    var inputFields = inputStr.split('.');
                    var pos = inputStr.substring(0, cursor).split('.').length - 1;
                    for (var i = 0; i < pos; i++) {
                        if (obj == null || typeof obj !== 'object') {
                            break;
                        }
                        obj = obj[inputFields[i]];
                    }
                    var completions = [];
                    if (obj != null && typeof obj === 'object') {
                        for (var _i = 0, _a = Object.keys(obj); _i < _a.length; _i++) {
                            var key = _a[_i];
                            completions.push({
                                caption: key,
                                value: key,
                                meta: 'field name'
                            });
                        }
                    }
                    return completions;
                };
                return FieldCompleter;
            }());
            exports_1("FieldCompleter", FieldCompleter);
        }
    };
});
//# sourceMappingURL=data:application/json;base64,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