System.register(["app/plugins/sdk", "./field_completer"], function (exports_1, context_1) {
    "use strict";
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var sdk_1, field_completer_1, CONNEXIVEDatasourceQueryCtrl;
    var __moduleName = context_1 && context_1.id;
    return {
        setters: [
            function (sdk_1_1) {
                sdk_1 = sdk_1_1;
            },
            function (field_completer_1_1) {
                field_completer_1 = field_completer_1_1;
            }
        ],
        execute: function () {
            CONNEXIVEDatasourceQueryCtrl = (function (_super) {
                __extends(CONNEXIVEDatasourceQueryCtrl, _super);
                function CONNEXIVEDatasourceQueryCtrl($scope, $injector) {
                    var _this = _super.call(this, $scope, $injector) || this;
                    _this.FORMATS = [
                        { text: 'Time series', value: 'time_series' },
                        { text: 'Table', value: 'table' },
                    ];
                    _this.CREATE_DATA_WITH = [
                        { text: 'Data field', value: 'data_field' },
                        { text: 'Series Name/Value key', value: 'series_name_value_key' },
                    ];
                    _this.target.refId = _this.target.refId || '';
                    _this.target.bucket = _this.target.bucket || '';
                    _this.target.deviceName = _this.target.deviceName || '';
                    _this.target.tsField = _this.target.tsField || '';
                    _this.target.aggr = _this.target.aggr || '';
                    _this.target.dataField = _this.target.dataField || [];
                    if (_this.target.fieldName) {
                        _this.target.dataField.push({
                            fieldName: _this.target.fieldName,
                            alias: _this.target.alias || ''
                        });
                    }
                    if (_this.target.dataField.length == 0) {
                        _this.target.dataField.push({ "fieldName": "", "alias": "" });
                    }
                    _this.target.fieldName = undefined;
                    _this.target.alias = undefined;
                    _this.target.format = _this.target.format || _this.getDefaultFormat();
                    _this.oldTarget = JSON.parse(JSON.stringify(_this.target));
                    _this.fieldCompleter = new field_completer_1.FieldCompleter(_this.datasource, _this.target.bucket);
                    _this.target.createDataWith = _this.target.createDataWith || 'data_field';
                    _this.target.seriesNameKey = _this.target.seriesNameKey || '';
                    _this.target.seriesValueKey = _this.target.seriesValueKey || '';
                    return _this;
                }
                CONNEXIVEDatasourceQueryCtrl.prototype.getBuckets = function () {
                    return this.datasource.metricFindQuery("buckets", this.target);
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.onChangeBucket = function () {
                    if (this.onChangeInternal("bucket")) {
                        this.fieldCompleter.setBucket(this.target.bucket);
                    }
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.getDevices = function () {
                    return this.datasource.metricFindQuery("device", this.target);
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.onChangeDevice = function () {
                    if (this.onChangeInternal("device")) {
                        this.fieldCompleter.setBucket(this.target.bucket);
                    }
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.addField = function () {
                    this.target.dataField.push({ "fieldName": "", "alias": "" });
                    this.oldTarget.dataField.push({ "fieldName": "", "alias": "" });
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.removeField = function (index) {
                    this.target.dataField.splice(index, 1);
                    this.oldTarget.dataField.splice(index, 1);
                    if (this.target.dataField.length == 0) {
                        this.addField();
                    }
                    this.panelCtrl.refresh();
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.onChangeFieldName = function (index) {
                    if (this.target.dataField[index].fieldName !== this.oldTarget.dataField[index].fieldName) {
                        this.oldTarget.dataField[index].fieldName = this.target.dataField[index].fieldName;
                        this.panelCtrl.refresh();
                    }
                    this.fieldCompleter.clearCache();
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.onChangeTsField = function () {
                    this.onChangeInternal("tsField");
                    this.fieldCompleter.clearCache();
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.onChangeAggregate = function () {
                    this.onChangeInternal("aggr");
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.onChangeInternal = function (key) {
                    if (this.target[key] === this.oldTarget[key]) {
                        return false;
                    }
                    this.oldTarget[key] = this.target[key];
                    this.panelCtrl.refresh();
                    return true;
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.getCompleter = function () {
                    return this.fieldCompleter;
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.getDefaultFormat = function () {
                    if (this.panelCtrl.panel.type === 'table') {
                        return 'table';
                    }
                    return 'time_series';
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.onChangeCreateDataWith = function () {
                    this.onChangeInternal("createDataWith");
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.onChangeSeriesNameKey = function () {
                    this.onChangeInternal("seriesNameKey");
                };
                CONNEXIVEDatasourceQueryCtrl.prototype.onChangeSeriesValueKey = function () {
                    this.onChangeInternal("seriesValueKey");
                };
                CONNEXIVEDatasourceQueryCtrl.templateUrl = 'public/plugins/connexive-app-datasource/partials/query.editor.html';
                return CONNEXIVEDatasourceQueryCtrl;
            }(sdk_1.QueryCtrl));
            exports_1("CONNEXIVEDatasourceQueryCtrl", CONNEXIVEDatasourceQueryCtrl);
        }
    };
});
//# sourceMappingURL=data:application/json;base64,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