System.register(["angular"], function (exports_1, context_1) {
    "use strict";
    var angular_1;
    var __moduleName = context_1 && context_1.id;
    return {
        setters: [
            function (angular_1_1) {
                angular_1 = angular_1_1;
            }
        ],
        execute: function () {
            angular_1.default.module('grafana.directives').filter('filterByTag', function () {
                return function (items, tag) {
                    var filtered = [];
                    if (!tag) {
                        return items;
                    }
                    items.forEach(function (item) {
                        if (item.tagsindexOf(tag) >= 0) {
                            filtered.push(item);
                        }
                    });
                    return filtered;
                };
            });
            angular_1.default.module('grafana.directives').filter('timeDuration', function () {
                return function (time) {
                    var duration = new Date().getTime() - new Date(time).getTime();
                    if (duration < 10000) {
                        return "a few seconds ago";
                    }
                    if (duration < 60000) {
                        var secs = Math.floor(duration / 1000);
                        return "for " + secs + " seconds";
                    }
                    if (duration < 3600000) {
                        var mins = Math.floor(duration / 1000 / 60);
                        return "for " + mins + " minutes";
                    }
                    if (duration < 86400000) {
                        var hours = Math.floor(duration / 1000 / 60 / 60);
                        return "for " + hours + " hours";
                    }
                    var days = Math.floor(duration / 1000 / 60 / 60 / 24);
                    return "for " + days + " days";
                };
            });
        }
    };
});
//# sourceMappingURL=data:application/json;base64,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