System.register(["./leaflet/leaflet", "app/plugins/sdk", "./leaflet/leaflet.css!", "./partials/module.css!"], function (exports_1, context_1) {
    "use strict";
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var leaflet_1, sdk_1, panelDefaults, TrackMapCtrl;
    var __moduleName = context_1 && context_1.id;
    function log(msg) {
    }
    return {
        setters: [
            function (leaflet_1_1) {
                leaflet_1 = leaflet_1_1;
            },
            function (sdk_1_1) {
                sdk_1 = sdk_1_1;
            },
            function (_1) {
            },
            function (_2) {
            }
        ],
        execute: function () {
            panelDefaults = {
                maxDataPoints: 500,
                autoZoom: true,
                scrollWheelZoom: false,
                defaultLayer: 'OpenStreetMap',
                lineColor: 'red',
                pointColor: 'royalblue',
            };
            TrackMapCtrl = (function (_super) {
                __extends(TrackMapCtrl, _super);
                function TrackMapCtrl($scope, $injector) {
                    var _this = _super.call(this, $scope, $injector) || this;
                    _this.layers = null;
                    _this.coords = null;
                    _this.leafMap = null;
                    _this.hoverTarget = null;
                    _this.markers = null;
                    _this.transitMarkers = null;
                    _this.polylines = null;
                    _this.setSizePromise = null;
                    log("constructor");
                    Object.assign(_this.panel, panelDefaults);
                    _this.layers = {
                        'OpenStreetMap': leaflet_1.default.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                            attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>',
                            maxZoom: 19
                        })
                    };
                    _this.timeSrv = $injector.get('timeSrv');
                    _this.coords = [];
                    _this.leafMap = null;
                    _this.hoverTarget = null;
                    _this.markers = leaflet_1.default.featureGroup();
                    _this.transitMarkers = leaflet_1.default.featureGroup();
                    _this.polylines = leaflet_1.default.featureGroup();
                    _this.setSizePromise = null;
                    _this.events.on('panel-initialized', _this.onInitialized.bind(_this));
                    _this.events.on('view-mode-changed', _this.onViewModeChanged.bind(_this));
                    _this.events.on('init-edit-mode', _this.onInitEditMode.bind(_this));
                    _this.events.on('panel-teardown', _this.onPanelTeardown.bind(_this));
                    _this.events.on('panel-size-changed', _this.onPanelSizeChanged.bind(_this));
                    _this.events.on('data-received', _this.onDataReceived.bind(_this));
                    _this.events.on('data-snapshot-load', _this.onDataSnapshotLoad.bind(_this));
                    return _this;
                }
                TrackMapCtrl.prototype.onInitialized = function () {
                    log("onInitialized");
                    this.render();
                };
                TrackMapCtrl.prototype.onInitEditMode = function () {
                    log("onInitEditMode");
                    this.addEditorTab('Options', 'public/plugins/connexive-app/panels/trackmap/partials/options.html', 2);
                };
                TrackMapCtrl.prototype.onPanelTeardown = function () {
                    log("onPanelTeardown");
                    this.$timeout.cancel(this.setSizePromise);
                };
                TrackMapCtrl.prototype.onPanelClear = function () {
                    log("onPanelClear");
                    if (this.markers && this.markers.getLayers()) {
                        this.markers.removeFrom(this.leafMap);
                        this.markers.clearLayers();
                        this.transitMarkers.removeFrom(this.leafMap);
                        this.transitMarkers.clearLayers();
                    }
                };
                TrackMapCtrl.prototype.onViewModeChanged = function () {
                    log("onViewModeChanged");
                    this.onPanelSizeChanged();
                };
                TrackMapCtrl.prototype.onPanelSizeChanged = function () {
                    log("onPanelSizeChanged");
                    this.$timeout.cancel(this.setSizePromise);
                    var map = this.leafMap;
                    this.setSizePromise = this.$timeout(function () {
                        if (map) {
                            log("Invalidating map size");
                            map.invalidateSize(true);
                        }
                    }, 500);
                };
                TrackMapCtrl.prototype.applyScrollZoom = function () {
                    var enabled = this.leafMap.scrollWheelZoom.enabled();
                    if (enabled != this.panel.scrollWheelZoom) {
                        if (enabled) {
                            this.leafMap.scrollWheelZoom.disable();
                        }
                        else {
                            this.leafMap.scrollWheelZoom.enable();
                        }
                    }
                };
                TrackMapCtrl.prototype.applyDefaultLayer = function () {
                    var _this = this;
                    var hadMap = Boolean(this.leafMap);
                    this.setupMap();
                    if (hadMap) {
                        this.leafMap.eachLayer(function (layer) {
                            layer.removeFrom(_this.leafMap);
                        });
                        this.layers[this.panel.defaultLayer].addTo(this.leafMap);
                    }
                    this.addDataToMap();
                };
                TrackMapCtrl.prototype.setupMap = function () {
                    log("setupMap");
                    if (this.leafMap) {
                        if (this.polylines && this.polylines.getLayers()) {
                            this.polylines.removeFrom(this.leafMap);
                            this.polylines.clearLayers();
                        }
                        this.onPanelClear();
                        return;
                    }
                    this.leafMap = leaflet_1.default.map('trackmap-' + this.panel.id, {
                        scrollWheelZoom: this.panel.scrollWheelZoom,
                        zoomSnap: 0.5,
                        zoomDelta: 1,
                    });
                    leaflet_1.default.control.layers(this.layers).addTo(this.leafMap);
                    this.layers['OpenStreetMap'].addTo(this.leafMap);
                    this.leafMap.setView([0, 0], 1);
                    this.leafMap.on('baselayerchange', this.mapBaseLayerChange.bind(this));
                };
                TrackMapCtrl.prototype.mapBaseLayerChange = function (e) {
                    if (this.leafMap.forcedOverlay) {
                        this.leafMap.forcedOverlay.removeFrom(this.leafMap);
                        this.leafMap.forcedOverlay = null;
                    }
                    var overlay = e.layer.options.forcedOverlay;
                    if (overlay) {
                        overlay.addTo(this.leafMap);
                        overlay.setZIndex(e.layer.options.zIndex + 1);
                        this.leafMap.forcedOverlay = overlay;
                    }
                };
                TrackMapCtrl.prototype.mapZoomToBox = function (e) {
                    var _this = this;
                    log("mapZoomToBox");
                    this.coords.forEach(function (series) {
                        var bounds = series.reduce(function (t, c) {
                            if (e.boxZoomBounds.contains(c.position)) {
                                t.from = Math.min(t.from, c.timestamp);
                                t.to = Math.max(t.to, c.timestamp);
                            }
                            return t;
                        }, { from: Infinity, to: -Infinity });
                        if (isFinite(bounds.from) && isFinite(bounds.to)) {
                            _this.timeSrv.setTime({
                                from: new Date(bounds.from).getTime(),
                                to: new Date(bounds.to).getTime()
                            });
                        }
                    });
                };
                TrackMapCtrl.prototype.addDataToMap = function () {
                    var _this = this;
                    log("addDataToMap");
                    this.markers.addTo(this.leafMap);
                    this.transitMarkers.addTo(this.leafMap);
                    this.coords.map(function (series) {
                        _this.polylines.addLayer(leaflet_1.default.polyline(series.map(function (x) { return x.position; }, _this), {
                            color: _this.panel.lineColor,
                            weight: 3,
                        }));
                    });
                    this.polylines.addTo(this.leafMap);
                    this.zoomToFit();
                };
                TrackMapCtrl.prototype.zoomToFit = function () {
                    log("zoomToFit");
                    var features = leaflet_1.default.featureGroup([this.markers, this.transitMarkers, this.polylines]);
                    this.leafMap.fitBounds(features.getBounds(), { padding: [100, 100] });
                    this.render();
                };
                TrackMapCtrl.prototype.refreshColors = function () {
                    log("refreshColors");
                    if (this.polylines) {
                        this.polylines.setStyle({
                            color: this.panel.lineColor
                        });
                    }
                    if (this.transitMarkers) {
                        this.transitMarkers.setStyle({
                            fillColor: this.panel.pointColor,
                        });
                    }
                    if (this.markers) {
                        this.markers.setStyle({
                            fillColor: this.panel.pointColor,
                        });
                    }
                    this.render();
                };
                TrackMapCtrl.prototype.onDataReceived = function (data) {
                    var _this = this;
                    log("onDataReceived");
                    this.setupMap();
                    if (data.length === 0 || data.length % 2 != 0 || !this.scope.ctrl.panel.targets) {
                        this.leafMap.setView([0, 0], 1);
                        return;
                    }
                    var devices = [];
                    this.scope.ctrl.panel.targets.forEach(function (e) {
                        Object.assign(devices, _this.templateSrv.replace(e.deviceName).split(","));
                    });
                    this.coords.length = 0;
                    devices.forEach(function (device, i) {
                        var lats = data[2 * i].datapoints;
                        var lons = data[2 * i + 1].datapoints;
                        _this.coords[i] = [];
                        for (var j = 0; j < lats.length; j++) {
                            if (lats[j][0] == null || lons[j][0] == null ||
                                lats[j][1] !== lons[j][1]) {
                                continue;
                            }
                            var latLng = leaflet_1.default.latLng(lats[j][0], lons[j][0]);
                            var timestamp = lats[j][1];
                            _this.coords[i].push({
                                position: latLng,
                                timestamp: timestamp
                            });
                            _this.transitMarkers.addLayer(leaflet_1.default.circleMarker(latLng, {
                                color: 'white',
                                fillColor: _this.panel.pointColor,
                                fillOpacity: 1,
                                weight: 2,
                                radius: 7
                            }).bindTooltip("Device ID: " + device + " <br> Latitude: " + latLng.lat + " <br> Longitude: " + latLng.lng + " <br> time: " + timestamp));
                            if (j == lats.length - 1) {
                                _this.markers.addLayer(leaflet_1.default.marker(latLng)
                                    .bindTooltip("Device ID: " + device + " <br> Latitude: " + latLng.lat + " <br> Longitude: " + latLng.lng + " <br> time: " + timestamp));
                            }
                        }
                    });
                    this.addDataToMap();
                };
                TrackMapCtrl.prototype.onDataSnapshotLoad = function (snapshotData) {
                    log("onSnapshotLoad");
                    this.onDataReceived(snapshotData);
                };
                TrackMapCtrl.templateUrl = 'public/plugins/connexive-app/panels/trackmap/partials/module.html';
                return TrackMapCtrl;
            }(sdk_1.MetricsPanelCtrl));
            exports_1("TrackMapCtrl", TrackMapCtrl);
        }
    };
});
//# sourceMappingURL=data:application/json;base64,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