package com.nec.webotx.jbatch;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.List;

import javax.batch.api.chunk.ItemWriter;
import javax.batch.runtime.context.JobContext;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;

@Dependent
@Named("FileItemWriter")
public class FileItemWriter implements ItemWriter {
    @Inject
    private JobContext jobCtx;
    private BufferedWriter bw;

    @Override
    public void open(Serializable checkpoint) throws Exception {
    	System.out.println("FileItemWriter#open");

    	String outputFile = (String)jobCtx.getProperties().get("output_file");
        bw = new BufferedWriter(new FileWriter(outputFile));
    }

    @Override
    public void writeItems(List<Object> items) throws Exception {
    	System.out.println("FileItemWriter#writeItems");
        for (Object i : items) {
        	Product product = (Product)i;
        	bw.write(product.getId() + "," + product.getName() + "," + product.getPrice());
        	bw.newLine();
        }
        bw.flush();
    }

    @Override
    public Serializable checkpointInfo() throws Exception {
    	System.out.println("FileItemWriter#checkpointInfo");
    	return null;
    }

	@Override
	public void close() throws Exception {
		System.out.println("FileItemWriter#close");
		if(bw != null) {
			bw.close();
		}
	}
}
