package sample;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.ejb.*;
import javax.naming.NamingException;
/**
 * Bean class of the EJB specification
 */
public class FindEmployeeBean implements SessionBean {
	private SessionContext sessionContext;
	
	private static final String DBNAME = "jdbc/employee";
	private static final String SCHEMA_TABLE = "COMPANY_EMP";
	
	private AccessDb accessDb;
	
	/**
	 * The query from which I get the staff who includes name in the name is sent to AccessDb to accessDb.
	 * @param name The condition of the name. It's possible to do partial agreement.
	 * @return The staff's set with the name including the argument
	 */
	public Employees selectByName(String name){
		try {
			if (name == null || name.equals("")){
				return selectAll();
			}
			ResultSet rs = accessDb.
				execute("SELECT * FROM " + SCHEMA_TABLE + " WHERE NAME LIKE '%" + name + "%'");
			return new Employees(rs);
		} catch (SQLException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	/**
	 * The query from which I get the staff who includes dept in a section name is sent to AccessDb to accessDb.
	 * @param dept The condition of the section name. It's possible to do partial agreement.
	 * @return The staff's set with the section name including an argument
	 */
	public Employees selectByDept(String dept){
		try {
			if (dept == null || dept.equals("")){
				return selectAll();
			}
			ResultSet rs = accessDb.
				execute("SELECT * FROM " + SCHEMA_TABLE + " WHERE DEPT='" + dept + "'");
			return new Employees(rs);
		} catch (SQLException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	/**
	 * The query from which I get a staff with an employee number of number is sent to AccessDb to accessDb.
	 * @param number Employee number. Perfect matching
	 * @return The staff's set with the employee number of an argument
	 */	
	public Employees selectByNumber(int number){
		try {
			ResultSet rs = accessDb.
				execute("SELECT * FROM " + SCHEMA_TABLE + " WHERE NUM=" + number);
			return new Employees(rs);
		} catch (SQLException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	/**
	 * The query from which I get all the employees is sent to accessDb.
	 * @return All the employees
	 */
	private Employees selectAll() {
		try {
			ResultSet rs = accessDb.execute("SELECT * FROM " + SCHEMA_TABLE);
			return new Employees(rs);
		} catch (SQLException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	public FindEmployeeBean() {
	}
	
	// The method to which below is necessary by the J2EE specification
	
	/* 
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext context) {
		this.sessionContext = context;
	}
	/* 
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() {
		if (accessDb != null) {
			accessDb.close();
		}
	}

	/*
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() {
	}

	/*
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() {
	}

	/**
	 * Substantial constructor in EJB
	 * It's called at the time of Bean making.
	 */
	public void ejbCreate() {
		try {
			accessDb = new AccessDb(DBNAME);
		} catch (NamingException e) {
			e.printStackTrace();
		}
	}
}
