package sample;

import java.rmi.RemoteException;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

/**
 * EJB Client
 */
public class Client {
	
	private final InitialContext context;
	private final FindEmployeeHome home;
	private final FindEmployee remote;

	public static void main(String[] args) throws RemoteException, NamingException, CreateException {
		Client cl = new Client("FindEmployee");
		printlnEmployees(cl.selectByName("田中"));
		System.out.println();
		printlnEmployees(cl.selectByName(""));
	}
	
	public Client(String remoteName) throws NamingException, RemoteException, CreateException {
		this.context = new InitialContext();
		Object obj = context.lookup(remoteName);
		this.home = (FindEmployeeHome)PortableRemoteObject.narrow(obj,
				FindEmployeeHome.class);
		this.remote = home.create();		
	}
	
	public Employees selectByName(String name){
		try{
			return remote.selectByName(name);
		} catch (Exception e){
			e.printStackTrace();
			return null;
		}
	}
	public Employees selectByNumber(int number){
		try{
			return remote.selectByNumber(number);
		} catch (Exception e){
			e.printStackTrace();
			return null;
		}
	}
	public Employees selectByDept(String dept){
		try{
			return remote.selectByDept(dept);
		} catch (Exception e){
			e.printStackTrace();
			return null;
		}
	}
	
	/**
	 * The method for tests
	 * @param employees
	 */
	private static void printlnEmployees(Employees employees){
		for (Iterator i = employees.iterator(); i.hasNext(); ) {
			Employee employee = (Employee) i.next();
			System.out.println(
					"#" + employee.getNumber() + " : " 
					+ employee.getName() + " : " 
					+ employee.getDept());			
		}
	}

}
