package sample;

import java.io.*;

import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * The servlet for a controller of MVC
 *
 */
public final class ControlServlet extends HttpServlet {
	
	/**
	 * Posted From index.jsp
	 */
	protected void doPost(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {
		try {
			req.setCharacterEncoding("Shift_JIS");
		} catch (java.io.UnsupportedEncodingException e) {
		}
		res.setContentType("text/html; charset=Shift_JIS");
		String type = req.getParameter("searchType");
		String value = req.getParameter("value");
		
		boolean valid;
		
		if (value.indexOf('\'')==-1) valid = true;
		else valid = false;

		Employees employees = null;
		try {
			if (valid){
				Client client = new Client("FindEmployee");
				if (type.equals("number")) {
					try {
						employees = client.selectByNumber(Integer.parseInt(value));
					} catch (NumberFormatException e) {
						// ignore
					}
				} else if (type.equals("name")) {
					employees = client.selectByName(value);				
				} else if (type.equals("dept")) {
					employees = client.selectByDept(value);								
				}
			}
		} catch (NamingException e) {
			e.printStackTrace();
		} catch (CreateException e) {
			e.printStackTrace();
		}
		
		if (employees != null){
			HttpSession session = req.getSession();
			session.setAttribute("employees", employees);
			RequestDispatcher dispatcher = getServletContext().getRequestDispatcher("/result.jsp");
			dispatcher.forward(req, res);
		} else {
			RequestDispatcher dispatcher = getServletContext().getRequestDispatcher("/fault.jsp");
			dispatcher.forward(req, res);
		}
	}
	
}
