package com.nec.webotx.jbatch;

import java.io.Serializable;
import java.util.List;

import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Dependent
@Named("DBItemReader")
public class DBItemReader implements ItemReader {
    @PersistenceContext(unitName = "SampleUnit")
    private EntityManager em;
    
    private List<Product> products;
    private int readCount = 0;
    
	@Override
	public void open(Serializable checkpoint) throws Exception {
		System.out.println("DBItemReader#open");
		TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
		products = query.getResultList();
	}

	@Override
	public void close() throws Exception {
		System.out.println("DBItemReader#close");
	}

	@Override
	public Object readItem() throws Exception {
		 System.out.println("DBItemReader#readItem");
		 if(readCount >= products.size()) {
			return null;
		 }
        return products.get(readCount++);
	}

	@Override
	public Serializable checkpointInfo() throws Exception {
        System.out.println("DBItemReader#checkpointInfo");
        return readCount;
	}

}
