package com.nec.webotx.jbatch;

import java.io.Serializable;
import java.util.List;

import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Dependent
@Named("DBItemWriter")
public class DBItemWriter implements ItemWriter {
    @PersistenceContext(unitName = "SampleUnit")
    private EntityManager em;
    
    @Override
    public void open(Serializable checkpoint) throws Exception {
    	System.out.println("DBItemWriter#open");
    }

    @Override
    public void writeItems(List<Object> items) throws Exception {
    	System.out.println("DBItemWriter#writeItems");
    	for (Object i : items) {
    		em.persist(i);
    	}
    }

    @Override
    public Serializable checkpointInfo() throws Exception {
    	System.out.println("DBItemWriter#checkpointInfo");
    	return null;
    }

	@Override
	public void close() throws Exception {
		System.out.println("DBItemWriter#close");
	}
}
