package com.nec.webotx.jbatch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;

import javax.batch.api.chunk.ItemReader;
import javax.batch.runtime.context.JobContext;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;

@Dependent
@Named("FileItemReader")
public class FileItemReader implements ItemReader {
    @Inject
    private JobContext jobCtx;

    private BufferedReader br;
    private int readCount = 0;

	@Override
	public void open(Serializable checkpoint) throws Exception {
		System.out.println("FileItemReader#open");
    	String inputFile = (String)jobCtx.getProperties().get("input_file");
    	br = new BufferedReader(new FileReader(inputFile));

        int startLine = (checkpoint == null)? 0 : (int)checkpoint;
        int currentLine = 0;
        while(startLine > currentLine) {
        	br.readLine();
        	currentLine++;
        }
	}

	@Override
	public void close() throws Exception {
		System.out.println("FileItemReader#close");
		if(br != null) {
			br.close();
		}
	}

	@Override
	public Object readItem() throws Exception {
		 System.out.println("FileItemReader#readItem");
		 String line = br.readLine();
		 if(line != null) {
			 String[] split = line.split(",");
			 readCount++;
			 return new Product(Integer.valueOf(split[0]), split[1], Integer.valueOf(split[2]));
		 }
		 return null;
	}

	@Override
	public Serializable checkpointInfo() throws Exception {
        System.out.println("FileItemReader#checkpointInfo");
        return readCount;
	}

}
