<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:java="http://xml.apache.org/xalan/java" exclude-result-prefixes="java" version="1.0">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" encoding="UTF-8" indent="yes"/>
  <xsl:template match="/">
    <xsl:for-each select="movies">
      <xsl:call-template name="node1"/>
    </xsl:for-each>
  </xsl:template>
  <!--template for node /movies-->
  <xsl:template name="node1">
    <movies>
      <xsl:call-template name="node2"/>
      <xsl:call-template name="node3"/>
    </movies>
  </xsl:template>
  <!--template for node /movies/*-->
  <xsl:template name="node2">
    <xsl:for-each select="./movie">
      <xsl:call-template name="node4"/>
    </xsl:for-each>
  </xsl:template>
  <!--template for node /movies/count-->
  <xsl:template name="node3">
    <count>
      <xsl:call-template name="node5"/>
    </count>
  </xsl:template>
  <!--template for node /movies/*/|-->
  <xsl:template name="node4">
    <xsl:variable name="var1">
      <xsl:value-of select="./movieType/text()"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$var1='Action'">
        <xsl:call-template name="node6"/>
      </xsl:when>
      <xsl:when test="$var1='2'">
        <xsl:call-template name="node7"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <!--template for node /movies/count/text()-->
  <xsl:template name="node5">
    <xsl:value-of select="count(./movie/movieType[text()='Action'])"/>
  </xsl:template>
  <!--template for node /movies/*/|/movieType-->
  <xsl:template name="node6">
    <movieType>
      <xsl:call-template name="node8"/>
      <xsl:call-template name="node9"/>
      <xsl:call-template name="node10"/>
    </movieType>
  </xsl:template>
  <!--template for node /movies/*/|/moviePrice-->
  <xsl:template name="node7">
    <moviePrice>
      <xsl:call-template name="node11"/>
      <xsl:call-template name="node12"/>
      <xsl:call-template name="node13"/>
    </moviePrice>
  </xsl:template>
  <!--template for node /movies/*/|/movieType/@name-->
  <xsl:template name="node8">
    <xsl:attribute name="name">
      <xsl:value-of select="./movieType/text()"/>
    </xsl:attribute>
  </xsl:template>
  <!--template for node /movies/*/|/movieType/movieName-->
  <xsl:template name="node9">
    <movieName>
      <xsl:call-template name="node14"/>
    </movieName>
  </xsl:template>
  <!--template for node /movies/*/|/movieType/movieTime-->
  <xsl:template name="node10">
    <movieTime>
      <xsl:call-template name="node15"/>
    </movieTime>
  </xsl:template>
  <!--template for node /movies/*/|/moviePrice/@price-->
  <xsl:template name="node11">
    <xsl:attribute name="price">
    </xsl:attribute>
  </xsl:template>
  <!--template for node /movies/*/|/moviePrice/movieName-->
  <xsl:template name="node12">
    <movieName>
      <xsl:call-template name="node16"/>
    </movieName>
  </xsl:template>
  <!--template for node /movies/*/|/moviePrice/movieTime-->
  <xsl:template name="node13">
    <movieTime>
      <xsl:call-template name="node17"/>
    </movieTime>
  </xsl:template>
  <!--template for node /movies/*/|/movieType/movieName/text()-->
  <xsl:template name="node14">
    <xsl:value-of select="./movieName/text()"/>
  </xsl:template>
  <!--template for node /movies/*/|/movieType/movieTime/text()-->
  <xsl:template name="node15">
    <xsl:value-of select="./movieTime/text()"/>
  </xsl:template>
  <!--template for node /movies/*/|/moviePrice/movieName/text()-->
  <xsl:template name="node16">
  </xsl:template>
  <!--template for node /movies/*/|/moviePrice/movieTime/text()-->
  <xsl:template name="node17">
  </xsl:template>
</xsl:stylesheet>
