package sample;

import java.sql.*;
import javax.naming.*;
import javax.sql.DataSource;

/**
 * The class connected to a data base
 */
public class AccessDb {
	private final Context context;
	private final DataSource ds;
	private Connection con = null;

	/**
	 * The data source you do JNDI registration of in argument dbName is acquired.
	 * @param dbName
	 * @throws NamingException
	 */
	public AccessDb(String dbName) throws NamingException{
		context = new InitialContext();
		ds = (DataSource) context.lookup(dbName);
	}
	
	/**
	 * I inquire to a data base about it and return ResultSet
	 * @param query SQL sentence
	 * @return ResultSet of a result
	 * @throws SQLException
	 */
	public ResultSet execute(String query) throws SQLException{
		ResultSet rs = null;
		con = connect();
		Statement stmt = con.createStatement();
		rs = stmt.executeQuery(query);
		return rs;
	}

	/**
	 * When being not called yet, it's connected to a data base.
	 * @return Connection
	 * @throws SQLException
	 */
	private Connection connect() throws SQLException{
		if (con == null || con.isClosed()) {
			con = ds.getConnection();
		}
		return con;
	}
	
	/**
	 * A connection is closed.
	 *
	 */
	public void close() {
		try {
			if (con != null) {
				con.close();
				con = null;
			}
		} catch (SQLException e) {
		}
	}	
}
