/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding;

import com.nec.webotx.webservice.xml.rpc.encoding.ArraySerializerHelper;
import com.nec.webotx.webservice.xml.rpc.encoding.soap.SOAPConstants;
import com.nec.webotx.webservice.xml.rpc.streaming.Attributes;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriterUtil;
import javax.xml.namespace.QName;

class SOAP11ArraySerializerHelper
implements ArraySerializerHelper {
    SOAP11ArraySerializerHelper() {
    }

    public void serializeArray(QName elemType, String encodedDims, XMLWriter writer) {
        String attrVal = XMLWriterUtil.encodeQName(writer, elemType) + encodedDims;
        writer.writeAttributeUnquoted(SOAPConstants.QNAME_ENCODING_ARRAYTYPE, attrVal);
    }

    public String encodeArrayDimensions(int[] dims) {
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < dims.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(dims[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public String getArrayType(Attributes attrs) {
        return attrs.getValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    }

    public String getElemTypeStr(String arrayType) {
        int idx = arrayType.indexOf(91);
        if (idx >= 0) {
            return arrayType.substring(0, idx).trim();
        }
        return null;
    }

    public QName getArrayQnameEncoding() {
        return SOAPConstants.QNAME_ENCODING_ARRAY;
    }

    public void whatAmI() {
        System.out.println("I am SOAP11");
    }
}

