/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.config.parser;

import com.nec.webotx.webservice.xml.rpc.processor.config.ConfigurationException;
import com.nec.webotx.webservice.xml.rpc.processor.config.ImportedDocumentInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.ModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.RmiInterfaceInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.RmiModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.TypeMappingRegistryInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.Constants;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.HandlerChainInfoData;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.ModelInfoParser;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.ParserUtil;
import com.nec.webotx.webservice.xml.rpc.processor.util.ProcessorEnvironment;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;

public class RmiModelInfoParser
extends ModelInfoParser {
    public RmiModelInfoParser(ProcessorEnvironment env) {
        super(env);
    }

    public ModelInfo parse(XMLReader reader) {
        RmiModelInfo modelInfo = new RmiModelInfo();
        String name = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        modelInfo.setName(name);
        String targetNamespaceURI = ParserUtil.getMandatoryNonEmptyAttribute(reader, "targetNamespace");
        modelInfo.setTargetNamespaceURI(targetNamespaceURI);
        String typeNamespaceURI = ParserUtil.getMandatoryNonEmptyAttribute(reader, "typeNamespace");
        modelInfo.setTypeNamespaceURI(typeNamespaceURI);
        String packageName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "packageName");
        modelInfo.setJavaPackageName(packageName);
        boolean gotTypeMappingRegistry = false;
        boolean gotHandlerChains = false;
        boolean gotNamespaceMappingRegistry = false;
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_INTERFACE)) {
                if (gotTypeMappingRegistry) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                modelInfo.add(this.parseInterfaceInfo(reader));
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_TYPE_MAPPING_REGISTRY)) {
                if (gotTypeMappingRegistry) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                modelInfo.setTypeMappingRegistry(this.parseTypeMappingRegistryInfo(reader));
                gotTypeMappingRegistry = true;
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_HANDLER_CHAINS)) {
                if (gotHandlerChains) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                HandlerChainInfoData data = this.parseHandlerChainInfoData(reader);
                modelInfo.setClientHandlerChainInfo(data.getClientHandlerChainInfo());
                modelInfo.setServerHandlerChainInfo(data.getServerHandlerChainInfo());
                gotHandlerChains = true;
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_NAMESPACE_MAPPING_REGISTRY)) {
                if (gotNamespaceMappingRegistry) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                modelInfo.setNamespaceMappingRegistry(this.parseNamespaceMappingRegistryInfo(reader));
                gotNamespaceMappingRegistry = true;
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
        TypeMappingRegistryInfo registryInfo = modelInfo.getTypeMappingRegistry();
        if (registryInfo != null) {
            ImportedDocumentInfo docInfo;
            ImportedDocumentInfo docInfo2;
            String tns = modelInfo.getTargetNamespaceURI();
            if (tns != null && (docInfo2 = registryInfo.getImportedDocument(tns)) != null) {
                throw new ConfigurationException("configuration.invalidImport.targetNamespace", tns);
            }
            String ttns = modelInfo.getTypeNamespaceURI();
            if (ttns != null && (docInfo = registryInfo.getImportedDocument(ttns)) != null) {
                throw new ConfigurationException("configuration.invalidImport.targetTypeNamespace", ttns);
            }
        }
        return modelInfo;
    }

    private RmiInterfaceInfo parseInterfaceInfo(XMLReader reader) {
        RmiInterfaceInfo interfaceInfo = new RmiInterfaceInfo();
        String name = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
        interfaceInfo.setName(name);
        String servantName = ParserUtil.getAttribute(reader, "servantName");
        interfaceInfo.setServantName(servantName);
        String soapAction = ParserUtil.getAttribute(reader, "soapAction");
        interfaceInfo.setSOAPAction(soapAction);
        String soapActionBase = ParserUtil.getAttribute(reader, "soapActionBase");
        interfaceInfo.setSOAPActionBase(soapActionBase);
        interfaceInfo.setSOAPVersion(SOAPVersion.SOAP_11);
        boolean gotHandlerChains = false;
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_HANDLER_CHAINS)) {
                if (gotHandlerChains) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                HandlerChainInfoData data = this.parseHandlerChainInfoData(reader);
                interfaceInfo.setClientHandlerChainInfo(data.getClientHandlerChainInfo());
                interfaceInfo.setServerHandlerChainInfo(data.getServerHandlerChainInfo());
                gotHandlerChains = true;
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
        return interfaceInfo;
    }
}

