/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.model;

import com.nec.webotx.webservice.xml.rpc.processor.model.ModelException;
import com.nec.webotx.webservice.xml.rpc.processor.model.ModelObject;
import com.nec.webotx.webservice.xml.rpc.processor.model.ModelVisitor;
import com.nec.webotx.webservice.xml.rpc.processor.model.Operation;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaInterface;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;
import com.nec.webotx.webservice.xml.rpc.spi.tools.HandlerChainInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class Port
extends ModelObject
implements com.nec.webotx.webservice.xml.rpc.spi.model.Port {
    private QName _name;
    private List _operations = new ArrayList();
    private JavaInterface _javaInterface;
    private String _address;
    private Map operationsByName = new HashMap();
    private com.nec.webotx.webservice.xml.rpc.processor.config.HandlerChainInfo _clientHandlerChainInfo;
    private com.nec.webotx.webservice.xml.rpc.processor.config.HandlerChainInfo _serverHandlerChainInfo;
    private SOAPVersion _soapVersion = SOAPVersion.SOAP_11;

    public Port() {
    }

    public Port(QName name) {
        this._name = name;
    }

    public QName getName() {
        return this._name;
    }

    public void setName(QName n) {
        this._name = n;
    }

    public void addOperation(Operation operation) {
        this._operations.add(operation);
        this.operationsByName.put(operation.getUniqueName(), operation);
    }

    public Iterator getOperations() {
        return this._operations.iterator();
    }

    public Operation getOperationByUniqueName(String name) {
        if (this.operationsByName.size() != this._operations.size()) {
            this.initializeOperationsByName();
        }
        return (Operation)this.operationsByName.get(name);
    }

    private void initializeOperationsByName() {
        this.operationsByName = new HashMap();
        if (this._operations != null) {
            Iterator iter = this._operations.iterator();
            while (iter.hasNext()) {
                Operation operation = (Operation)iter.next();
                if (operation.getUniqueName() != null && this.operationsByName.containsKey(operation.getUniqueName())) {
                    throw new ModelException("model.uniqueness");
                }
                this.operationsByName.put(operation.getUniqueName(), operation);
            }
        }
    }

    public List getOperationsList() {
        return this._operations;
    }

    public void setOperationsList(List l) {
        this._operations = l;
    }

    public JavaInterface getJavaInterface() {
        return this._javaInterface;
    }

    public void setJavaInterface(JavaInterface i) {
        this._javaInterface = i;
    }

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String s) {
        this._address = s;
    }

    public com.nec.webotx.webservice.xml.rpc.processor.config.HandlerChainInfo getClientHandlerChainInfo() {
        if (this._clientHandlerChainInfo == null) {
            this._clientHandlerChainInfo = new com.nec.webotx.webservice.xml.rpc.processor.config.HandlerChainInfo();
        }
        return this._clientHandlerChainInfo;
    }

    public void setClientHandlerChainInfo(com.nec.webotx.webservice.xml.rpc.processor.config.HandlerChainInfo i) {
        this._clientHandlerChainInfo = i;
    }

    public HandlerChainInfo getServerHCI() {
        return this.getServerHandlerChainInfo();
    }

    public com.nec.webotx.webservice.xml.rpc.processor.config.HandlerChainInfo getServerHandlerChainInfo() {
        if (this._serverHandlerChainInfo == null) {
            this._serverHandlerChainInfo = new com.nec.webotx.webservice.xml.rpc.processor.config.HandlerChainInfo();
        }
        return this._serverHandlerChainInfo;
    }

    public void setServerHandlerChainInfo(com.nec.webotx.webservice.xml.rpc.processor.config.HandlerChainInfo i) {
        this._serverHandlerChainInfo = i;
    }

    public SOAPVersion getSOAPVersion() {
        return this._soapVersion;
    }

    public void setSOAPVersion(SOAPVersion soapVersion) {
        this._soapVersion = soapVersion;
    }

    public void accept(ModelVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

