/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.modeler.rmi;

import com.nec.webotx.webservice.xml.rpc.processor.modeler.ModelerException;
import com.nec.webotx.webservice.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.nec.webotx.webservice.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.nec.webotx.webservice.xml.rpc.processor.modeler.rmi.RmiType;
import com.nec.webotx.webservice.xml.rpc.processor.util.ProcessorEnvironment;
import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class JavaBean
implements RmiConstants {
    private HashMap members;
    private Class remoteBean;
    ProcessorEnvironment env;

    private static JavaBean forType(ProcessorEnvironment env, RmiType type) {
        JavaBean bean = null;
        try {
            String implClassName = type.getClassName();
            URLClassLoader classLoader = env.getClassLoader();
            Class<?> beanClass = classLoader.loadClass(implClassName);
            bean = new JavaBean(env, beanClass);
            bean.initialize();
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
        return bean;
    }

    public static Map modelTypeSOAP(ProcessorEnvironment env, RmiType type) {
        JavaBean bean = JavaBean.forType(env, type);
        if (bean == null) {
            return null;
        }
        return bean.getMembers();
    }

    private HashMap getMembers() {
        return (HashMap)this.members.clone();
    }

    private JavaBean(ProcessorEnvironment env, Class remoteBean) {
        this.env = env;
        this.remoteBean = remoteBean;
    }

    private void initialize() {
        this.members = new HashMap();
        JavaBean.collectMembers(this.remoteBean, this.members, this.remoteBean);
    }

    private static void collectMembers(Class remoteBean, Map members, Class baseBean) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(remoteBean);
        }
        catch (IntrospectionException e) {
            throw new ModelerException("rmimodeler.invalid.rmi.type:", remoteBean.getName().toString());
        }
        PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < properties.length; ++i) {
            Class<?> propertyType = properties[i].getPropertyType();
            Method readMethod = properties[i].getReadMethod();
            Method writeMethod = properties[i].getWriteMethod();
            if (propertyType == null || readMethod == null || writeMethod == null || readMethod.getParameterTypes().length != 0 || writeMethod.getParameterTypes().length != 1) continue;
            String propertyName = properties[i].getName();
            RmiType type = RmiType.getRmiType(readMethod.getReturnType());
            if (type == null) {
                throw new ModelerException("rmimodeler.could.not.resolve.property.type", remoteBean.getName() + ":" + propertyName);
            }
            MemberInfo memInfo = new MemberInfo(propertyName, type, false);
            memInfo.setReadMethod(readMethod.getName());
            memInfo.setWriteMethod(writeMethod.getName());
            if (!writeMethod.getDeclaringClass().equals(baseBean)) {
                memInfo.setDeclaringClass(writeMethod.getDeclaringClass());
            }
            members.put(propertyName, memInfo);
        }
        if (remoteBean.getSuperclass() != null) {
            JavaBean.collectMembers(remoteBean.getSuperclass(), members, baseBean);
        }
        Class<?>[] interfaces = remoteBean.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            JavaBean.collectMembers(interfaces[i], members, baseBean);
        }
    }

    private static void log(ProcessorEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[JavaBean: " + msg + "]");
        }
    }
}

