/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.util.localization;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Resources {
    private ResourceBundle _bundle;

    public Resources(String bundleName) throws MissingResourceException {
        this._bundle = ResourceBundle.getBundle(bundleName);
    }

    public String getString(String key) {
        return this.getText(key, null);
    }

    public String getString(String key, String arg) {
        return this.getText(key, new String[]{arg});
    }

    public String getString(String key, String[] args) {
        return this.getText(key, args);
    }

    private String getText(String key, String[] args) {
        if (this._bundle == null) {
            return "";
        }
        try {
            return MessageFormat.format(this._bundle.getString(key), args);
        }
        catch (MissingResourceException e) {
            String msg = "Missing resource: key={0}";
            return MessageFormat.format(msg, key);
        }
    }
}

