/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.client.dii.webservice.parser;

import com.nec.webotx.webservice.xml.rpc.client.dii.webservice.WebService;
import com.nec.webotx.webservice.xml.rpc.client.dii.webservice.WebServicesClient;
import com.nec.webotx.webservice.xml.rpc.client.dii.webservice.WebServicesClientException;
import com.nec.webotx.webservice.xml.rpc.client.dii.webservice.parser.Constants;
import com.nec.webotx.webservice.xml.rpc.client.dii.webservice.parser.ParserUtil;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReaderException;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReaderFactory;
import com.nec.webotx.webservice.xml.rpc.util.localization.LocalizableMessageFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class WebServicesClientParser {
    private LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.nec.webotx.webservice.xml.rpc.resources.client");

    public WebServicesClient parse(InputStream is) throws WebServicesClientException {
        try {
            XMLReader reader = XMLReaderFactory.newInstance().createXMLReader(is);
            reader.next();
            return this.parseWebServicesClient(reader);
        }
        catch (XMLReaderException e) {
            throw new WebServicesClientException("client.xmlReader", e);
        }
    }

    protected WebServicesClient parseWebServicesClient(XMLReader reader) {
        if (!reader.getName().equals(Constants.QNAME_CLIENT)) {
            ParserUtil.failWithFullName("client.invalidElement", reader);
        }
        WebServicesClient client = new WebServicesClient();
        if (reader.getState() == 1) {
            client.setWebServices(this.parseWebServices(reader));
        } else {
            ParserUtil.fail("client.missing.service", reader);
        }
        if (reader.nextElementContent() != 5) {
            ParserUtil.fail("client.unexpectedContent", reader);
        }
        reader.close();
        return client;
    }

    protected List parseWebServices(XMLReader reader) {
        ArrayList<WebService> webServices = new ArrayList<WebService>();
        while (reader.nextElementContent() == 1) {
            String model;
            String wsdlLocation;
            if (!reader.getName().equals(Constants.QNAME_SERVICE)) {
                ParserUtil.failWithFullName("service.invalidElement", reader);
            }
            if ((wsdlLocation = ParserUtil.getAttribute(reader, "wsdlLocation")) == null) {
                ParserUtil.failWithLocalName("client.invalidwsdlLocation", reader);
            }
            if ((model = ParserUtil.getAttribute(reader, "model")) == null) {
                ParserUtil.failWithLocalName("client.invalidModel", reader);
            }
            WebService service = new WebService(wsdlLocation, model);
            webServices.add(service);
            if (reader.nextElementContent() == 2) continue;
            ParserUtil.fail("client.unexpectedContent", reader);
        }
        return webServices;
    }
}

