/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.generator;

import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.XSDBase64BinaryEncoder;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.XSDDateTimeCalendarEncoder;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.XSDHexBinaryEncoder;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.XSDListTypeEncoder;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.XSDStringEncoder;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.XSDTimeEncoder;
import com.nec.webotx.webservice.xml.rpc.processor.config.Configuration;
import com.nec.webotx.webservice.xml.rpc.processor.generator.GeneratorBase;
import com.nec.webotx.webservice.xml.rpc.processor.generator.GeneratorUtil;
import com.nec.webotx.webservice.xml.rpc.processor.generator.Names;
import com.nec.webotx.webservice.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.nec.webotx.webservice.xml.rpc.processor.model.AbstractType;
import com.nec.webotx.webservice.xml.rpc.processor.model.Fault;
import com.nec.webotx.webservice.xml.rpc.processor.model.Model;
import com.nec.webotx.webservice.xml.rpc.processor.model.Parameter;
import com.nec.webotx.webservice.xml.rpc.processor.model.Request;
import com.nec.webotx.webservice.xml.rpc.processor.model.Response;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaException;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaStructureMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralElementMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralListType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPAnyType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPArrayType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPCustomType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPListType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPType;
import com.nec.webotx.webservice.xml.rpc.processor.util.GeneratedFileInfo;
import com.nec.webotx.webservice.xml.rpc.processor.util.IndentingWriter;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;
import com.nec.webotx.webservice.xml.rpc.util.VersionUtil;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class EnumerationGenerator
extends GeneratorBase {
    private Set types;
    private AbstractType type;
    static /* synthetic */ Class class$java$lang$String;

    public EnumerationGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new EnumerationGenerator(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new EnumerationGenerator(model, config, properties);
    }

    private EnumerationGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    protected void visitParameter(Parameter param) throws Exception {
        AbstractType type = param.getType();
        if (type.isSOAPType()) {
            ((SOAPType)type).accept(this);
        } else {
            ((LiteralType)type).accept(this);
        }
    }

    protected void preVisitResponse(Response response) throws Exception {
        Iterator iter = response.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
    }

    protected void preVisitRequest(Request request) throws Exception {
        Iterator iter = request.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
    }

    protected void visitFault(Fault fault) throws Exception {
        if (fault.getBlock().getType().isSOAPType()) {
            ((SOAPType)fault.getBlock().getType()).accept(this);
        }
        JavaException exception = fault.getJavaException();
        Iterator members = exception.getMembers();
        AbstractType aType = (AbstractType)exception.getOwner();
        if (aType.isSOAPType()) {
            while (members.hasNext()) {
                SOAPType type = ((SOAPStructureMember)((JavaStructureMember)members.next()).getOwner()).getType();
                type.accept(this);
            }
        } else {
            LiteralType type = null;
            while (members.hasNext()) {
                JavaStructureMember javaMember = (JavaStructureMember)members.next();
                if (javaMember.getOwner() instanceof LiteralElementMember) {
                    type = ((LiteralElementMember)javaMember.getOwner()).getType();
                } else if (javaMember.getOwner() instanceof LiteralAttributeMember) {
                    type = ((LiteralAttributeMember)javaMember.getOwner()).getType();
                }
                type.accept(this);
            }
        }
    }

    public void visit(SOAPCustomType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPSimpleType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPAnyType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        this.generateEnumeration(type);
    }

    protected void visitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        super.visitSOAPArrayType(type);
    }

    protected void visitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        super.visitSOAPStructureType(type);
    }

    public void visit(LiteralEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (!type.getJavaType().isPresent()) {
            String className = type.getJavaType().getName();
            if (!this.donotOverride || !GeneratorUtil.classExists(this.env, className)) {
                this.generateEnumeration(type);
            } else {
                this.log("Class " + className + " exists. Not overriding.");
            }
        }
    }

    public void visit(LiteralListType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        type.getItemType().accept(this);
        this.registerType(type);
    }

    public void visit(SOAPListType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        type.getItemType().accept(this);
        this.registerType(type);
    }

    private boolean isRegistered(AbstractType type) {
        return this.types.contains(type);
    }

    private void registerType(AbstractType type) {
        this.types.add(type);
    }

    private void generateEnumeration(AbstractType type) {
        this.log("generating Enumeration for: " + type.getJavaType().getName());
        this.type = type;
        try {
            String className = type.getJavaType().getName();
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("Enumeration");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writePackage(out, className);
            out.pln();
            this.writeImports(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeClassDecl(out, className);
            this.writeMembers(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeClassConstructor(out, className, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeGetValue(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeFromValue(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeFromString(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeToString(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeResolveMethod(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeEquals(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeHashCode(out, (JavaEnumerationType)type.getJavaType());
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            EnumerationGenerator.fail(e);
        }
    }

    private boolean isBaseTypeHexBinary() {
        return false;
    }

    private boolean isBaseTypeBase64Binary() {
        return false;
    }

    private void writeImports(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getName();
        p.pln("import java.util.Map;");
        p.pln("import java.util.HashMap;");
        if (this.isBaseArrayType(baseTypeStr)) {
            p.pln("import java.util.StringTokenizer;");
            p.pln("import java.util.Arrays;");
        }
    }

    private boolean isBaseArrayType(String type) {
        return type.endsWith("[]");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        if (VersionUtil.isVersion101(this.targetVersion) || VersionUtil.isVersion103(this.targetVersion) || this.generateSerializableIf) {
            p.plnI("public class " + Names.stripQualifier(className) + " implements java.io.Serializable {");
        } else {
            this.writeClassDeclWithoutSerializable(p, className);
        }
    }

    private void writeClassDeclWithoutSerializable(IndentingWriter p, String className) throws IOException {
        p.plnI("public class " + Names.stripQualifier(className) + " {");
    }

    private void writeMembers(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        JavaEnumerationEntry entry;
        String baseTypeStr = javaEnum.getBaseType().getName();
        String className = Names.stripQualifier(javaEnum.getName());
        p.pln("private " + baseTypeStr + " value;");
        p.pln("private static Map valueMap = new HashMap();");
        Iterator enums = javaEnum.getEntries();
        if (!SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            enums = javaEnum.getEntries();
            while (enums.hasNext()) {
                entry = (JavaEnumerationEntry)enums.next();
                p.pln("public static final String _" + entry.getName() + "String = \"" + entry.getLiteralValue() + "\";");
            }
            p.pln();
        }
        enums = javaEnum.getEntries();
        while (enums.hasNext()) {
            Object val;
            entry = (JavaEnumerationEntry)enums.next();
            if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
                if (baseTypeStr.equals("long")) {
                    p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = " + entry.getLiteralValue() + "L;");
                    continue;
                }
                p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = (" + baseTypeStr + ")" + entry.getLiteralValue() + ";");
                continue;
            }
            if (baseTypeStr.equals("java.net.URI")) {
                p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = getURI(_" + entry.getName() + "String);");
                continue;
            }
            if (baseTypeStr.equals("java.util.Calendar")) {
                val = null;
                if (this.type instanceof LiteralEnumerationType) {
                    if (((LiteralEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_DATE_TIME) || ((LiteralEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_DATE)) {
                        try {
                            val = (Calendar)XSDDateTimeCalendarEncoder.getInstance().stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (((LiteralEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_TIME)) {
                        try {
                            val = (Calendar)XSDTimeEncoder.getInstance().stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (this.type instanceof SOAPEnumerationType) {
                    if (((SOAPEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_DATE_TIME) || ((SOAPEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_DATE)) {
                        try {
                            val = (Calendar)XSDDateTimeCalendarEncoder.getInstance().stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (((SOAPEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_TIME)) {
                        try {
                            val = (Calendar)XSDTimeEncoder.getInstance().stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = getCalendar(" + ((Calendar)val).getTimeInMillis() + "L);");
                continue;
            }
            if (this.isBaseArrayType(baseTypeStr)) {
                val = null;
                String[] strVal = null;
                String str = null;
                if (this.type instanceof LiteralEnumerationType) {
                    if (((LiteralEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_BASE64_BINARY)) {
                        try {
                            val = (byte[])XSDBase64BinaryEncoder.getInstance().stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        str = "{" + this.getArrayInitializer(val) + "};";
                    } else if (((LiteralEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_HEX_BINARY)) {
                        try {
                            val = (byte[])XSDHexBinaryEncoder.getInstance().stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        str = "{" + this.getArrayInitializer(val) + "};";
                    } else if (((LiteralEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_NMTOKENS)) {
                        try {
                            strVal = (String[])XSDListTypeEncoder.getInstance(XSDStringEncoder.getInstance(), class$java$lang$String == null ? EnumerationGenerator.class$("java.lang.String") : class$java$lang$String).stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        str = "{" + this.getArrayInitializer(strVal) + "};";
                    }
                } else if (this.type instanceof SOAPEnumerationType) {
                    if (((SOAPEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_BASE64_BINARY)) {
                        try {
                            val = (byte[])XSDBase64BinaryEncoder.getInstance().stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        str = "{" + this.getArrayInitializer(val) + "};";
                    } else if (((SOAPEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_HEX_BINARY)) {
                        try {
                            val = (byte[])XSDHexBinaryEncoder.getInstance().stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        str = "{" + this.getArrayInitializer(val) + "};";
                    } else if (((SOAPEnumerationType)this.type).getBaseType().getName().equals(SchemaConstants.QNAME_TYPE_NMTOKENS)) {
                        try {
                            strVal = (String[])XSDListTypeEncoder.getInstance(XSDStringEncoder.getInstance(), class$java$lang$String == null ? EnumerationGenerator.class$("java.lang.String") : class$java$lang$String).stringToObject(entry.getLiteralValue(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        str = "{" + this.getArrayInitializer(strVal) + "};";
                    }
                }
                p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = new " + baseTypeStr + str);
                continue;
            }
            if (baseTypeStr.equals("javax.xml.namespace.QName")) {
                p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = javax.xml.namespace.QName.valueOf(\"" + entry.getValue().toString() + "\");");
                continue;
            }
            p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = new " + baseTypeStr + "(_" + entry.getName() + "String);");
        }
        p.pln();
        enums = javaEnum.getEntries();
        while (enums.hasNext()) {
            entry = (JavaEnumerationEntry)enums.next();
            p.pln("public static final " + className + " " + entry.getName() + " = new " + className + "(_" + entry.getName() + ");");
        }
        if (baseTypeStr.equals("java.net.URI")) {
            p.pln();
            p.plnI("private static java.net.URI getURI(String val) {");
            p.plnI("try {");
            p.pln("return new java.net.URI(val);");
            p.pOln("}catch(java.net.URISyntaxException e){e.printStackTrace();}");
            p.pln("return null;");
            p.pOln("}");
        }
        if (baseTypeStr.equals("java.util.Calendar")) {
            p.pln();
            p.plnI("private static java.util.Calendar getCalendar(long val) {");
            p.pln("java.util.Calendar cal = new java.util.GregorianCalendar();");
            p.pln("cal.setTimeInMillis(val);");
            p.pln("return cal;");
            p.pOln("}");
        }
    }

    private String getArrayInitializer(Object obj) {
        if (null == obj) {
            return null;
        }
        if (!obj.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        StringBuffer ret = new StringBuffer();
        int len = Array.getLength(obj);
        if (len == 0) {
            return "";
        }
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                ret.append(", ");
            }
            if (obj instanceof String[]) {
                ret.append("\"" + Array.get(obj, i) + "\"");
                continue;
            }
            ret.append(Array.get(obj, i));
        }
        return ret.toString();
    }

    private void writeClassConstructor(IndentingWriter p, String className, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getName();
        p.plnI("protected " + Names.stripQualifier(className) + "(" + baseTypeStr + " value) {");
        p.pln("this.value = value;");
        p.pln("valueMap.put(this.toString(), this);");
        p.pOln("}");
    }

    private void writeGetValue(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getName();
        p.plnI("public " + baseTypeStr + " getValue() {");
        p.pln("return value;");
        p.pOln("}");
    }

    private void writeFromValue(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getName();
        String className = Names.stripQualifier(javaEnum.getName());
        p.plnI("public static " + className + " fromValue(" + baseTypeStr + " value)");
        p.pln("throws java.lang.IllegalStateException {");
        Iterator enums = javaEnum.getEntries();
        int i = 0;
        while (enums.hasNext()) {
            JavaEnumerationEntry entry = (JavaEnumerationEntry)enums.next();
            if (i > 0) {
                p.p(" else ");
            }
            if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
                p.plnI("if (" + entry.getName() + ".value == value) {");
            } else if (this.isBaseArrayType(baseTypeStr)) {
                p.plnI("if (Arrays.equals(" + entry.getName() + ".value, value)) {");
            } else if (baseTypeStr.equals("java.util.Calendar")) {
                p.plnI("if (" + entry.getName() + ".value.getTimeInMillis() == value.getTimeInMillis()) {");
            } else {
                p.plnI("if (" + entry.getName() + ".value.equals(value)) {");
            }
            p.pln("return " + entry.getName() + ";");
            p.pO("}");
            ++i;
        }
        p.pln();
        p.pln("throw new IllegalArgumentException();");
        p.pOln("}");
    }

    private void writeFromString(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getName();
        String className = Names.stripQualifier(javaEnum.getName());
        p.plnI("public static " + className + " fromString(String value)");
        p.pln("throws java.lang.IllegalStateException {");
        p.pln(className + " ret = (" + className + ")valueMap.get(value);");
        p.plnI("if (ret != null) {");
        p.pln("return ret;");
        p.pOln("}");
        Iterator enums = javaEnum.getEntries();
        int i = 0;
        while (enums.hasNext()) {
            JavaEnumerationEntry entry = (JavaEnumerationEntry)enums.next();
            if (i > 0) {
                p.p(" else ");
            }
            if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
                p.plnI("if (value.equals(\"" + entry.getLiteralValue() + "\")) {");
            } else if (this.isBaseArrayType(baseTypeStr) || baseTypeStr.equals("java.util.Calendar")) {
                p.plnI("if (value.equals(_" + entry.getName() + ".toString())) {");
            } else {
                p.plnI("if (value.equals(_" + entry.getName() + "String)) {");
            }
            p.pln("return " + entry.getName() + ";");
            p.pO("}");
            ++i;
        }
        p.pln();
        p.pln("throw new IllegalArgumentException();");
        p.pOln("}");
    }

    private void writeToString(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getName();
        String className = Names.stripQualifier(javaEnum.getName());
        p.plnI("public String toString() {");
        String exp = "value";
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            exp = SimpleToBoxedUtil.getBoxedExpressionOfType(exp, baseTypeStr);
        }
        p.pln("return " + exp + ".toString();");
        p.pOln("}");
    }

    private void writeResolveMethod(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getName();
        String className = Names.stripQualifier(javaEnum.getName());
        p.plnI("private Object readResolve()");
        p.pln("throws java.io.ObjectStreamException {");
        p.pln("return fromValue(getValue());");
        p.pOln("}");
    }

    private void writeEquals(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getName();
        String className = Names.stripQualifier(javaEnum.getName());
        p.plnI("public boolean equals(Object obj) {");
        p.plnI("if (!(obj instanceof " + className + ")) {");
        p.pln("return false;");
        p.pOln("}");
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            p.pln("return ((" + className + ")obj).value == value;");
        } else {
            p.pln("return ((" + className + ")obj).value.equals(value);");
        }
        p.pOln("}");
    }

    private void writeHashCode(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getName();
        p.plnI("public int hashCode() {");
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            String boxedExp = SimpleToBoxedUtil.getBoxedExpressionOfType("value", baseTypeStr);
            p.pln("return " + boxedExp + ".toString().hashCode();");
        } else {
            p.pln("return value.hashCode();");
        }
        p.pOln("}");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

