/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.generator.nodes;

import com.nec.webotx.webservice.xml.rpc.processor.config.Configuration;
import com.nec.webotx.webservice.xml.rpc.processor.config.ModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.NamespaceMappingInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.NamespaceMappingRegistryInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.RmiModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.WSDLModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.generator.nodes.ExceptionMappingNode;
import com.nec.webotx.webservice.xml.rpc.processor.generator.nodes.JavaXmlTypeMappingNode;
import com.nec.webotx.webservice.xml.rpc.processor.generator.nodes.JaxRpcMappingNode;
import com.nec.webotx.webservice.xml.rpc.processor.generator.nodes.PackageMappingNode;
import com.nec.webotx.webservice.xml.rpc.processor.generator.nodes.ServiceEndpointInterfaceMappingNode;
import com.nec.webotx.webservice.xml.rpc.processor.generator.nodes.ServiceInterfaceMappingNode;
import com.nec.webotx.webservice.xml.rpc.processor.generator.nodes.TypeVisitor;
import com.nec.webotx.webservice.xml.rpc.processor.model.AbstractType;
import com.nec.webotx.webservice.xml.rpc.processor.model.Block;
import com.nec.webotx.webservice.xml.rpc.processor.model.Fault;
import com.nec.webotx.webservice.xml.rpc.processor.model.Model;
import com.nec.webotx.webservice.xml.rpc.processor.model.Port;
import com.nec.webotx.webservice.xml.rpc.processor.model.Service;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralStructuredType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaWsdlMappingNode
extends JaxRpcMappingNode {
    private static final String JAXRPC_MAPPING_SCHEMA_VERSION = "1.1";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String W3C_XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_LOCATION_TAG = "xsi:schemaLocation";
    private static final String JAXRPC_MAPPING_SCHEMA_LOCATION = "http://java.sun.com/xml/ns/j2ee    http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd";
    private static final String MYNAME = "JavaWsdlMappingNode";
    private Set _faultSet = new HashSet();
    private Set _bindingSet = new HashSet();
    private Set _namespaceSet = new HashSet();

    public Node write(Node parent, String nodeName, Model model, Configuration config) throws Exception {
        Element node = JavaWsdlMappingNode.appendChild(parent, nodeName);
        this.addNodeAttributes(node);
        TypeVisitor visitor = new TypeVisitor(config);
        visitor.visit(model);
        this.writePackageMapping(node, model, config, visitor);
        this.writeJavaXmlTypeMapping(node, model, config, visitor);
        this.writeExceptionMapping(node, model, visitor);
        Iterator iter = model.getServices();
        while (iter.hasNext()) {
            Service service = (Service)iter.next();
            ServiceInterfaceMappingNode siNode = new ServiceInterfaceMappingNode();
            siNode.write(node, "service-interface-mapping", config, service);
            Iterator portIter = service.getPorts();
            while (portIter.hasNext()) {
                Port port = (Port)portIter.next();
                QName bindingQName = (QName)port.getProperty("com.nec.webotx.webservice.xml.rpc.processor.model.WSDLBindingName");
                if (this._bindingSet.contains(bindingQName)) continue;
                this._bindingSet.add(bindingQName);
                ServiceEndpointInterfaceMappingNode seiNode = new ServiceEndpointInterfaceMappingNode();
                seiNode.write(node, "service-endpoint-interface-mapping", config, port);
            }
        }
        return node;
    }

    private void addNodeAttributes(Element node) {
        node.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://java.sun.com/xml/ns/j2ee");
        node.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", W3C_XML_SCHEMA_INSTANCE);
        node.setAttributeNS(W3C_XML_SCHEMA_INSTANCE, SCHEMA_LOCATION_TAG, JAXRPC_MAPPING_SCHEMA_LOCATION);
        node.setAttributeNS("http://java.sun.com/xml/ns/j2ee", "version", JAXRPC_MAPPING_SCHEMA_VERSION);
    }

    private void writePackageMapping(Node parent, Model model, Configuration config, TypeVisitor visitor) throws Exception {
        String packageName;
        String namespace;
        ModelInfo modelInfo = (ModelInfo)config.getModelInfo();
        String targetNamespace = null;
        String javaPackage = null;
        if (modelInfo instanceof WSDLModelInfo) {
            WSDLModelInfo wsdlModelInfo = (WSDLModelInfo)modelInfo;
            targetNamespace = model.getTargetNamespaceURI();
            javaPackage = wsdlModelInfo.getJavaPackageName();
        } else if (modelInfo instanceof RmiModelInfo) {
            String typeNamespace = null;
            RmiModelInfo rmiModelInfo = (RmiModelInfo)modelInfo;
            targetNamespace = rmiModelInfo.getTargetNamespaceURI();
            typeNamespace = rmiModelInfo.getTypeNamespaceURI();
            javaPackage = rmiModelInfo.getJavaPackageName();
            PackageMappingNode pmNode = new PackageMappingNode();
            pmNode.write(parent, "package-mapping", javaPackage, typeNamespace);
            this._namespaceSet.add(typeNamespace);
        }
        PackageMappingNode pmNode = new PackageMappingNode();
        pmNode.write(parent, "package-mapping", javaPackage, targetNamespace);
        this._namespaceSet.add(targetNamespace);
        NamespaceMappingRegistryInfo nsInfo = modelInfo.getNamespaceMappingRegistry();
        if (nsInfo != null) {
            Iterator i = nsInfo.getNamespaceMappings();
            while (i.hasNext()) {
                NamespaceMappingInfo ns = (NamespaceMappingInfo)i.next();
                namespace = ns.getNamespaceURI();
                packageName = ns.getJavaPackageName();
                if (this._namespaceSet.contains(namespace)) continue;
                pmNode = new PackageMappingNode();
                pmNode.write(parent, "package-mapping", packageName, namespace);
            }
        }
        Set namespaces = visitor.getNamespacePackages().keySet();
        Iterator i = namespaces.iterator();
        while (i.hasNext()) {
            namespace = (String)i.next();
            if (this._namespaceSet.contains(namespace)) continue;
            packageName = (String)visitor.getNamespacePackages().get(namespace);
            pmNode = new PackageMappingNode();
            pmNode.write(parent, "package-mapping", packageName, namespace);
        }
    }

    private void writeJavaXmlTypeMapping(Node parent, Model model, Configuration config, TypeVisitor visitor) throws Exception {
        JavaXmlTypeMappingNode javaxmlNode;
        AbstractType type;
        Set complexTypeSet = visitor.getComplexTypes();
        Iterator it = complexTypeSet.iterator();
        while (it.hasNext()) {
            type = (AbstractType)it.next();
            JavaXmlTypeMappingNode javaxmlNode2 = new JavaXmlTypeMappingNode();
            javaxmlNode2.write(parent, "java-xml-type-mapping", type, config, false);
        }
        it = complexTypeSet.iterator();
        while (it.hasNext()) {
            type = (AbstractType)it.next();
            if (!(type instanceof LiteralStructuredType) || type.getProperty("com.nec.webotx.webservice.xml.rpc.processor.model.AnonymousArrayTypeName") == null) continue;
            LiteralStructuredType litStructType = (LiteralStructuredType)type;
            javaxmlNode = new JavaXmlTypeMappingNode();
            javaxmlNode.writeAnonymousArrayType(parent, "java-xml-type-mapping", litStructType, config, false);
        }
        Set simpleTypeSet = visitor.getSimpleTypes();
        Iterator it2 = simpleTypeSet.iterator();
        while (it2.hasNext()) {
            AbstractType type2 = (AbstractType)it2.next();
            javaxmlNode = new JavaXmlTypeMappingNode();
            javaxmlNode.write(parent, "java-xml-type-mapping", type2, config, true);
        }
    }

    private void writeExceptionMapping(Node parent, Model model, TypeVisitor visitor) throws Exception {
        Set faultSet = visitor.getFaults();
        Iterator it = faultSet.iterator();
        while (it.hasNext()) {
            Fault fault = (Fault)it.next();
            Block block = fault.getBlock();
            QName wsdlMsg = block.getName();
            if (this._faultSet.contains(wsdlMsg)) continue;
            this._faultSet.add(wsdlMsg);
            ExceptionMappingNode exceptionNode = new ExceptionMappingNode();
            exceptionNode.write(parent, "exception-mapping", fault);
        }
    }
}

