/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.soap;

import com.nec.webotx.webservice.xml.rpc.soap.SOAPNamespaceConstants;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;

class SOAPNamespaceConstantsImpl
implements SOAPNamespaceConstants {
    private String ENVELOPE;
    private String ENCODING;
    private String SOAP_RPC;
    private String XSD;
    private String XSI;
    private String TRANSPORT_HTTP;
    private String ACTOR_NEXT;
    private String TAG_ENVELOPE;
    private String TAG_HEADER;
    private String TAG_BODY;
    private String ATTR_ACTOR;
    private String TAG_RESULT;
    private String ATTR_MISUNDERSTOOD;
    private String ATTR_MUST_UNDERSTAND;
    private String ATTR_ENCODING_STYLE;
    private String SOAP_UPGRADE;
    private SOAPVersion ver;

    SOAPNamespaceConstantsImpl(SOAPVersion ver) {
        this.ver = ver;
        if (ver == SOAPVersion.SOAP_11) {
            this.initSOAP11();
        } else if (ver == SOAPVersion.SOAP_12) {
            this.initSOAP12();
        }
    }

    public SOAPVersion getSOAPVersion() {
        return this.ver;
    }

    public String getEnvelope() {
        return this.ENVELOPE;
    }

    public String getEncoding() {
        return this.ENCODING;
    }

    public String getSOAPRpc() {
        return this.SOAP_RPC;
    }

    public String getXSD() {
        return this.XSD;
    }

    public String getXSI() {
        return this.XSI;
    }

    public String getTransportHTTP() {
        return this.TRANSPORT_HTTP;
    }

    public String getActorNext() {
        return this.ACTOR_NEXT;
    }

    public String getTagEnvelope() {
        return this.TAG_ENVELOPE;
    }

    public String getTagHeader() {
        return this.TAG_HEADER;
    }

    public String getTagBody() {
        return this.TAG_BODY;
    }

    public String getAttrActor() {
        return this.ATTR_ACTOR;
    }

    public String getTagResult() {
        return this.TAG_RESULT;
    }

    public String getAttrMustUnderstand() {
        return this.ATTR_MUST_UNDERSTAND;
    }

    public String getAttrMisunderstood() {
        return this.ATTR_MISUNDERSTOOD;
    }

    public String getSOAPUpgrade() {
        return this.SOAP_UPGRADE;
    }

    public String getAttrEncodingStyle() {
        return this.ATTR_ENCODING_STYLE;
    }

    private void initSOAP11() {
        this.ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
        this.ENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
        this.XSD = "http://www.w3.org/2001/XMLSchema";
        this.XSI = "http://www.w3.org/2001/XMLSchema-instance";
        this.TRANSPORT_HTTP = "http://schemas.xmlsoap.org/soap/http/";
        this.ACTOR_NEXT = "http://schemas.xmlsoap.org/soap/actor/next";
        this.TAG_ENVELOPE = "Envelope";
        this.TAG_HEADER = "Header";
        this.TAG_BODY = "Body";
        this.ATTR_ACTOR = "actor";
        this.ATTR_MUST_UNDERSTAND = "mustUnderstand";
        this.ATTR_ENCODING_STYLE = "encodingStyle";
        this.SOAP_RPC = null;
        this.TAG_RESULT = null;
        this.ATTR_MISUNDERSTOOD = null;
        this.SOAP_UPGRADE = null;
    }

    private void initSOAP12() {
        this.ENVELOPE = "http://www.w3.org/2002/06/soap-envelope";
        this.ENCODING = "http://www.w3.org/2002/06/soap-encoding";
        this.XSD = "http://www.w3.org/2001/XMLSchema";
        this.XSI = "http://www.w3.org/2001/XMLSchema-instance";
        this.TRANSPORT_HTTP = "http://www.w3.org/2002/06/soap/bindings/HTTP/";
        this.ACTOR_NEXT = "http://www.w3.org/2002/06/soap-envelope/role/next";
        this.TAG_ENVELOPE = "Envelope";
        this.TAG_HEADER = "Header";
        this.TAG_BODY = "Body";
        this.ATTR_ACTOR = "role";
        this.ATTR_MUST_UNDERSTAND = "mustUnderstand";
        this.ATTR_ENCODING_STYLE = "encodingStyle";
        this.SOAP_RPC = "http://www.w3.org/2002/06/soap-rpc";
        this.TAG_RESULT = "result";
        this.ATTR_MISUNDERSTOOD = "missUnderstood";
        this.SOAP_UPGRADE = "http://www.w3.org/2002/06/soap-upgrade";
    }
}

