/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.messaging.saaj.soap.impl;

import com.nec.webotx.webservice.xml.messaging.saaj.SOAPExceptionImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.Envelope;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.impl.BodyImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.impl.ElementImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.impl.HeaderImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.name.NameImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.util.transform.EfficientStreamingTransformer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public abstract class EnvelopeImpl
extends ElementImpl
implements Envelope {
    HeaderImpl header;
    BodyImpl body;
    String omitXmlDecl = "yes";
    String charset = "utf-8";

    protected EnvelopeImpl(SOAPDocumentImpl ownerDoc, Name name) {
        super(ownerDoc, name);
    }

    protected EnvelopeImpl(SOAPDocumentImpl ownerDoc, NameImpl name, boolean createHeader, boolean createBody) throws SOAPException {
        this(ownerDoc, name);
        this.ensureNamespaceIsDeclared(this.getElementName());
        if (createHeader) {
            this.addHeader();
        }
        if (createBody) {
            this.addBody();
        }
    }

    protected abstract NameImpl getHeaderName(String var1);

    protected abstract NameImpl getBodyName(String var1);

    public SOAPHeader addHeader() throws SOAPException {
        return this.addHeader(null);
    }

    public SOAPHeader addHeader(String prefix) throws SOAPException {
        if (prefix == null || prefix.equals("")) {
            prefix = this.getPrefix();
        }
        NameImpl headerName = this.getHeaderName(prefix);
        NameImpl bodyName = this.getBodyName(prefix);
        HeaderImpl header = null;
        SOAPElement firstChild = null;
        Iterator eachChild = this.getChildElementNodes();
        if (eachChild.hasNext()) {
            firstChild = (SOAPElement)eachChild.next();
            if (firstChild.getElementName().equals(headerName)) {
                log.severe("SAAJ0120.impl.header.already.exists");
                throw new SOAPExceptionImpl("Can't add a header when one is already present.");
            }
            if (!firstChild.getElementName().equals(bodyName)) {
                log.severe("SAAJ0121.impl.invalid.first.child.of.envelope");
                throw new SOAPExceptionImpl("First child of Envelope must be either a Header or Body");
            }
        }
        header = (HeaderImpl)this.createElement(headerName);
        this.insertBefore((Node)((Object)header), (Node)firstChild);
        header.ensureNamespaceIsDeclared(headerName);
        return header;
    }

    protected void lookForHeader() throws SOAPException {
        HeaderImpl hdr;
        NameImpl headerName = this.getHeaderName(null);
        this.header = hdr = (HeaderImpl)this.findChild(headerName);
    }

    public SOAPHeader getHeader() throws SOAPException {
        this.lookForHeader();
        return this.header;
    }

    protected void lookForBody() throws SOAPException {
        BodyImpl bodyChildElement;
        NameImpl bodyName = this.getBodyName(null);
        this.body = bodyChildElement = (BodyImpl)this.findChild(bodyName);
    }

    public SOAPBody addBody() throws SOAPException {
        return this.addBody(null);
    }

    public SOAPBody addBody(String prefix) throws SOAPException {
        this.lookForBody();
        if (prefix == null || prefix.equals("")) {
            prefix = this.getPrefix();
        }
        if (this.body != null) {
            log.severe("SAAJ0122.impl.body.already.exists");
            throw new SOAPExceptionImpl("Can't add a body when one is already present.");
        }
        NameImpl bodyName = this.getBodyName(prefix);
        this.body = (BodyImpl)this.createElement(bodyName);
        this.insertBefore((Node)((Object)this.body), null);
        this.body.ensureNamespaceIsDeclared(bodyName);
        return this.body;
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        if (this.getBodyName(null).equals(name)) {
            return this.addBody(name.getPrefix());
        }
        if (this.getHeaderName(null).equals(name)) {
            return this.addHeader(name.getPrefix());
        }
        return super.addElement(name);
    }

    public SOAPBody getBody() throws SOAPException {
        this.lookForBody();
        return this.body;
    }

    public Source getContent() {
        return new DOMSource(this.getOwnerDocument());
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        if ("xmlns".equals(prefix)) {
            log.severe("SAAJ0123.impl.no.reserved.xmlns");
            throw new SOAPExceptionImpl("Cannot declare reserved xmlns prefix");
        }
        if (prefix == null && "xmlns".equals(localName)) {
            log.severe("SAAJ0124.impl.qualified.name.cannot.be.xmlns");
            throw new SOAPExceptionImpl("Qualified name cannot be xmlns");
        }
        return NameImpl.create(localName, prefix, uri);
    }

    public Name createName(String localName, String prefix) throws SOAPException {
        String namespace = this.getNamespaceURI(prefix);
        if (namespace == null) {
            log.log(Level.SEVERE, "SAAJ0126.impl.cannot.locate.ns", new String[]{prefix});
            throw new SOAPExceptionImpl("Unable to locate namespace for prefix " + prefix);
        }
        return NameImpl.create(localName, prefix, namespace);
    }

    public Name createName(String localName) throws SOAPException {
        return NameImpl.createFromUnqualifiedName(localName);
    }

    public void setOmitXmlDecl(String value) {
        this.omitXmlDecl = value;
    }

    private String getOmitXmlDecl() {
        return this.omitXmlDecl;
    }

    public void setCharsetEncoding(String value) {
        this.charset = value;
    }

    public void output(OutputStream out) throws IOException {
        try {
            Transformer transformer = EfficientStreamingTransformer.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", this.omitXmlDecl);
            transformer.setOutputProperty("encoding", this.charset);
            log.log(Level.FINE, "SAAJ0190.impl.set.xml.declaration", new String[]{this.omitXmlDecl});
            log.log(Level.FINE, "SAAJ0191.impl.set.encoding", new String[]{this.charset});
            StreamResult result = new StreamResult(out);
            transformer.transform(this.getContent(), result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }
}

