/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding;

import com.nec.webotx.webservice.xml.rpc.encoding.DynamicSerializer;
import com.nec.webotx.webservice.xml.rpc.encoding.EncodingException;
import com.nec.webotx.webservice.xml.rpc.encoding.ExtendedTypeMapping;
import com.nec.webotx.webservice.xml.rpc.encoding.Initializable;
import com.nec.webotx.webservice.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.nec.webotx.webservice.xml.rpc.encoding.PolymorphicArraySerializer;
import com.nec.webotx.webservice.xml.rpc.encoding.ReferenceableSerializerImpl;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerBase;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerConstants;
import com.nec.webotx.webservice.xml.rpc.encoding.SingletonDeserializerFactory;
import com.nec.webotx.webservice.xml.rpc.encoding.SingletonSerializerFactory;
import com.nec.webotx.webservice.xml.rpc.encoding.TypeMappingUtil;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPConstantsFactory;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPEncodingConstants;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;
import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaConstants;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class InternalTypeMappingRegistryImpl
implements InternalTypeMappingRegistry,
SerializerConstants {
    protected static final Row NULL_ROW = Row.createNull();
    protected static final Entry NULL_ENTRY = Entry.createNull(NULL_ROW);
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    protected TypeMappingRegistry registry = null;
    private SOAPEncodingConstants soapEncodingConstants = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;

    private int hashToIndex(int hash) {
        return (hash & Integer.MAX_VALUE) % this.table.length;
    }

    private Entry get(int hash) {
        return this.table[this.hashToIndex(hash)];
    }

    private Entry put(int hash, Row row) {
        if (this.count >= this.threshold) {
            this.rehash();
        }
        int index = this.hashToIndex(hash);
        this.table[index] = new Entry(this.table[index], hash, row);
        ++this.count;
        return this.table[index];
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Object[] newMap = new Entry[newCapacity];
        Arrays.fill(newMap, NULL_ENTRY);
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != NULL_ENTRY) {
                Entry e = old;
                old = old.next;
                int index = this.hashToIndex(e.hash);
                e.next = this.table[index];
                this.table[index] = e;
            }
        }
    }

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public InternalTypeMappingRegistryImpl(TypeMappingRegistry registry) {
        this.init();
        this.registry = registry;
        this.setupDynamicSerializers(SOAPVersion.SOAP_11);
        this.setupDynamicSerializers(SOAPVersion.SOAP_12);
    }

    protected void init() {
        int initialCapacity = 57;
        this.table = new Entry[initialCapacity];
        Arrays.fill(this.table, NULL_ENTRY);
        this.count = 0;
        this.loadFactor = 0.75f;
        this.threshold = (int)((float)initialCapacity * this.loadFactor);
    }

    protected void setupDynamicSerializers(SOAPVersion ver) {
        this.init(ver);
        try {
            ExtendedTypeMapping soapMappings = (ExtendedTypeMapping)this.registry.getTypeMapping(this.soapEncodingConstants.getURIEncoding());
            if (soapMappings != null) {
                SerializerBase anyTypeSerializer = new DynamicSerializer(SchemaConstants.QNAME_TYPE_URTYPE, true, true, this.soapEncodingConstants.getSOAPEncodingNamespace(), ver);
                anyTypeSerializer = new ReferenceableSerializerImpl(false, anyTypeSerializer, ver);
                ((Initializable)((Object)anyTypeSerializer)).initialize(this);
                soapMappings.register(class$java$lang$Object == null ? (class$java$lang$Object = InternalTypeMappingRegistryImpl.class$("java.lang.Object")) : class$java$lang$Object, SchemaConstants.QNAME_TYPE_URTYPE, new SingletonSerializerFactory(anyTypeSerializer), new SingletonDeserializerFactory(anyTypeSerializer));
                QName ELEMENT_NAME = null;
                SerializerBase polymorphicArraySerializer = new PolymorphicArraySerializer(this.soapEncodingConstants.getQNameEncodingArray(), false, true, this.soapEncodingConstants.getURIEncoding(), ELEMENT_NAME, ver);
                polymorphicArraySerializer = new ReferenceableSerializerImpl(false, polymorphicArraySerializer, ver);
                ((Initializable)((Object)polymorphicArraySerializer)).initialize(this);
                soapMappings.register(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = InternalTypeMappingRegistryImpl.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, this.soapEncodingConstants.getQNameEncodingArray(), new SingletonSerializerFactory(polymorphicArraySerializer), new SingletonDeserializerFactory(polymorphicArraySerializer));
            }
        }
        catch (Exception e) {
            throw new EncodingException("nestedEncodingError", new LocalizableExceptionAdapter(e));
        }
    }

    protected Row getRowMatching(String encoding, Class javaType, QName xmlType) {
        int hash = encoding.hashCode() ^ javaType.hashCode() ^ xmlType.hashCode();
        Entry matchingRowEntry = this.get(hash).getEntryMatching(encoding, javaType, xmlType);
        if (matchingRowEntry == NULL_ENTRY) {
            Row row = new Row(encoding, javaType, xmlType);
            this.put(encoding.hashCode() ^ javaType.hashCode(), row);
            this.put(encoding.hashCode() ^ xmlType.hashCode(), row);
            matchingRowEntry = this.put(hash, row);
        }
        return matchingRowEntry.row;
    }

    protected Row getRowMatching(String encoding, QName xmlType) {
        int hash = encoding.hashCode() ^ xmlType.hashCode();
        Entry matchingRowEntry = this.get(hash).getEntryMatching(encoding, xmlType);
        if (matchingRowEntry == NULL_ENTRY) {
            Row row = new Row(encoding, null, xmlType);
            matchingRowEntry = this.put(hash, row);
        }
        return matchingRowEntry.row;
    }

    protected Row getRowMatching(String encoding, Class javaType) {
        int hash = encoding.hashCode() ^ javaType.hashCode();
        Entry matchingRowEntry = this.get(hash).getEntryMatching(encoding, javaType);
        if (matchingRowEntry == NULL_ENTRY) {
            Row row = new Row(encoding, javaType, null);
            matchingRowEntry = this.put(hash, row);
        }
        return matchingRowEntry.row;
    }

    public Serializer getSerializer(String encoding, Class javaType, QName xmlType) throws Exception {
        Row row;
        if (javaType == null) {
            if (xmlType == null) {
                throw new IllegalArgumentException("getSerializer requires a Java type and/or an XML type");
            }
            row = this.getRowMatching(encoding, xmlType);
        } else {
            row = xmlType == null ? this.getRowMatching(encoding, javaType) : this.getRowMatching(encoding, javaType, xmlType);
        }
        if (row.serializer == null) {
            Serializer serializer;
            TypeMapping mapping = TypeMappingUtil.getTypeMapping(this.registry, encoding);
            row.serializer = serializer = TypeMappingUtil.getSerializer(mapping, javaType, xmlType);
            if (serializer instanceof Initializable) {
                ((Initializable)serializer).initialize(this);
            }
        }
        return row.serializer;
    }

    public Serializer getSerializer(String encoding, Class javaType) throws Exception {
        return this.getSerializer(encoding, javaType, null);
    }

    public Serializer getSerializer(String encoding, QName xmlType) throws Exception {
        return this.getSerializer(encoding, null, xmlType);
    }

    public Deserializer getDeserializer(String encoding, Class javaType, QName xmlType) throws Exception {
        Row row;
        if (javaType == null) {
            if (xmlType == null) {
                throw new IllegalArgumentException("getSerializer requires a Java type and/or an XML type");
            }
            row = this.getRowMatching(encoding, xmlType);
        } else {
            row = xmlType == null ? this.getRowMatching(encoding, javaType) : this.getRowMatching(encoding, javaType, xmlType);
        }
        if (row.deserializer == null) {
            Deserializer deserializer;
            TypeMapping mapping = TypeMappingUtil.getTypeMapping(this.registry, encoding);
            row.deserializer = deserializer = TypeMappingUtil.getDeserializer(mapping, javaType, xmlType);
            if (deserializer instanceof Initializable) {
                ((Initializable)deserializer).initialize(this);
            }
        }
        return row.deserializer;
    }

    public Deserializer getDeserializer(String encoding, Class javaType) throws Exception {
        return this.getDeserializer(encoding, javaType, null);
    }

    public Deserializer getDeserializer(String encoding, QName xmlType) throws Exception {
        return this.getDeserializer(encoding, null, xmlType);
    }

    public Class getJavaType(String encoding, QName xmlType) throws Exception {
        if (xmlType == null) {
            throw new IllegalArgumentException("getJavaType requires an XML type");
        }
        Row row = this.getRowMatching(encoding, xmlType);
        if (row.javaType == null) {
            ExtendedTypeMapping mapping = (ExtendedTypeMapping)TypeMappingUtil.getTypeMapping(this.registry, encoding);
            if (mapping != null) {
                return mapping.getJavaType(xmlType);
            }
            return null;
        }
        return row.javaType;
    }

    public QName getXmlType(String encoding, Class javaType) throws Exception {
        if (javaType == null) {
            throw new IllegalArgumentException("getXmlType requires a Java type");
        }
        Row row = this.getRowMatching(encoding, javaType);
        if (row.xmlType == null) {
            ExtendedTypeMapping mapping = (ExtendedTypeMapping)TypeMappingUtil.getTypeMapping(this.registry, encoding);
            if (mapping != null) {
                return mapping.getXmlType(javaType);
            }
            return null;
        }
        return row.xmlType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class Entry {
        Entry next;
        int hash;
        Row row;

        static Entry createNull(Row nullRow) {
            Entry nullEntry;
            nullEntry.next = nullEntry = new Entry(0, nullRow);
            return nullEntry;
        }

        private Entry(int hash, Row row) {
            if (row == null) {
                throw new IllegalArgumentException("row may not be null");
            }
            this.next = null;
            this.hash = hash;
            this.row = row;
        }

        Entry(Entry next, int hash, Row row) {
            this(hash, row);
            if (next == null) {
                throw new IllegalArgumentException("next may not be null");
            }
            this.next = next;
        }

        boolean matches(String encoding, Class javaType) {
            return this.row.encoding.equals(encoding) && this.row.javaType != null ? this.row.javaType.equals(javaType) : false;
        }

        boolean matches(String encoding, QName xmlType) {
            return this.row.encoding.equals(encoding) && this.row.xmlType != null ? this.row.xmlType.equals(xmlType) : false;
        }

        boolean matches(String encoding, Class javaType, QName xmlType) {
            return (this.row.xmlType != null ? this.row.xmlType.equals(xmlType) : xmlType == null) && (this.row.javaType != null ? this.row.javaType.equals(javaType) : javaType == null) && this.row.encoding.equals(encoding);
        }

        Entry getEntryMatching(String encoding, Class javaType) {
            Entry candidate = this;
            while (candidate != NULL_ENTRY && !candidate.matches(encoding, javaType)) {
                candidate = candidate.next;
            }
            return candidate;
        }

        Entry getEntryMatching(String encoding, QName xmlType) {
            Entry candidate = this;
            while (candidate != NULL_ENTRY && !candidate.matches(encoding, xmlType)) {
                candidate = candidate.next;
            }
            return candidate;
        }

        Entry getEntryMatching(String encoding, Class javaType, QName xmlType) {
            Entry candidate = this;
            while (candidate != NULL_ENTRY && !candidate.matches(encoding, javaType, xmlType)) {
                candidate = candidate.next;
            }
            return candidate;
        }
    }

    protected static class Row {
        String encoding;
        Class javaType;
        QName xmlType;
        Serializer serializer;
        Deserializer deserializer;

        Row(String encoding, Class javaType, QName xmlType) {
            this(encoding, javaType, xmlType, null, null);
        }

        Row(String encoding, Class javaType, QName xmlType, Serializer serializer, Deserializer deserializer) {
            if (encoding == null) {
                throw new IllegalArgumentException("encoding may not be null");
            }
            if (javaType == null && xmlType == null) {
                throw new IllegalArgumentException("javaType and xmlType may not both be null");
            }
            this.encoding = encoding;
            this.javaType = javaType;
            this.xmlType = xmlType;
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        static Row createNull() {
            return new Row();
        }

        private Row() {
            this.encoding = null;
            this.javaType = null;
            this.xmlType = null;
            this.serializer = null;
            this.deserializer = null;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public QName getXMLType() {
            return this.xmlType;
        }

        public Serializer getSerializer() {
            return this.serializer;
        }

        public Deserializer getDeserializer() {
            return this.deserializer;
        }
    }
}

