/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding;

import com.nec.webotx.webservice.xml.rpc.encoding.CombinedSerializer;
import com.nec.webotx.webservice.xml.rpc.encoding.DeserializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.Initializable;
import com.nec.webotx.webservice.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.nec.webotx.webservice.xml.rpc.encoding.ReferenceableSerializer;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationState;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPSerializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPSerializationState;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerBase;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerCallback;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPConstantsFactory;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPEncodingConstants;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;
import com.nec.webotx.webservice.xml.rpc.streaming.Attributes;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import com.nec.webotx.webservice.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;

public class ReferenceableSerializerImpl
extends SerializerBase
implements Initializable,
ReferenceableSerializer,
SerializerCallback {
    private CombinedSerializer serializer;
    private boolean serializeAsRef;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public ReferenceableSerializerImpl(boolean serializeAsRef, CombinedSerializer serializer) {
        this(serializeAsRef, serializer, SOAPVersion.SOAP_11);
    }

    public ReferenceableSerializerImpl(boolean serializeAsRef, CombinedSerializer serializer, SOAPVersion ver) {
        super(serializer.getXmlType(), serializer.getEncodeType(), serializer.isNullable(), serializer.getEncodingStyle());
        this.init(ver);
        this.serializer = serializer;
        this.serializeAsRef = serializeAsRef;
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        if (this.serializer instanceof Initializable) {
            ((Initializable)((Object)this.serializer)).initialize(registry);
        }
    }

    public CombinedSerializer getInnermostSerializer() {
        return this.serializer.getInnermostSerializer();
    }

    public void serialize(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        boolean pushedEncodingStyle = false;
        try {
            if (!this.serializeAsRef || obj == null) {
                this.serializer.serialize(obj, name, null, writer, context);
            } else if (!context.isRegistered(obj) && context.getSOAPVersion() == SOAPVersion.SOAP_12) {
                context.registerObject(obj, this);
                this.serializer.serialize(obj, name, this, writer, context);
            } else {
                SOAPSerializationState state = context.registerObject(obj, this);
                writer.startElement(name != null ? name : this.type);
                if (this.typeIsEmpty()) {
                    throw new SerializationException("soap.unspecifiedType");
                }
                if (this.encodingStyle != null) {
                    pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
                }
                if (context.getSOAPVersion() == SOAPVersion.SOAP_11) {
                    writer.writeAttribute(this.soapEncodingConstants.getQNameAttrHREF(), "#" + state.getID());
                } else if (context.getSOAPVersion() == SOAPVersion.SOAP_12) {
                    writer.writeAttribute(this.soapEncodingConstants.getQNameAttrHREF(), state.getID());
                }
                writer.endElement();
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException(e);
        }
        catch (Exception e) {
            throw new SerializationException(new LocalizableExceptionAdapter(e));
        }
        finally {
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
    }

    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        try {
            String href = null;
            if (context.getSOAPVersion() == SOAPVersion.SOAP_11) {
                href = this.getHRef(reader);
            } else if (context.getSOAPVersion() == SOAPVersion.SOAP_12) {
                href = this.getIDRef(reader);
            }
            if (href != null) {
                if (href.startsWith("cid:")) {
                    return this.serializer.deserialize(name, reader, context);
                }
                this.skipEmptyContent(reader);
                SOAPDeserializationState state = context.getStateFor(href);
                state.setDeserializer(this);
                if (state.isComplete()) {
                    return state.getInstance();
                }
                return state;
            }
            String id = this.getID(reader);
            boolean isNull = ReferenceableSerializerImpl.getNullStatus(reader);
            if (!isNull) {
                SOAPDeserializationState state = null;
                Object instance = this.serializer.deserialize(name, reader, context);
                if (id != null) {
                    state = context.getStateFor(id);
                }
                if (instance instanceof SOAPDeserializationState) {
                    state = (SOAPDeserializationState)instance;
                    state.setDeserializer(this);
                } else if (state != null) {
                    state.setInstance(instance);
                    state.setDeserializer(this);
                }
                if (state != null) {
                    state.doneReading();
                    return state;
                }
                return instance;
            }
            this.serializer.deserialize(name, reader, context);
            if (id != null) {
                SOAPDeserializationState state = context.getStateFor(id);
                state.setDeserializer(this);
                state.setInstance(null);
                state.doneReading();
            }
            return null;
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public Object deserialize(DataHandler dataHandler, SOAPDeserializationContext context) {
        return this.serializer.deserialize(dataHandler, context);
    }

    public void serializeInstance(Object obj, QName name, boolean isMultiRef, XMLWriter writer, SOAPSerializationContext context) {
        ReferenceableSerializerImpl callback = isMultiRef ? this : null;
        this.serializer.serialize(obj, name, callback, writer, context);
    }

    public void onStartTag(Object obj, QName name, XMLWriter writer, SOAPSerializationContext context) {
        if (!this.serializeAsRef) {
            return;
        }
        try {
            SOAPSerializationState state = context.registerObject(obj, this);
            writer.writeAttribute(this.soapEncodingConstants.getQNameAttrID(), state.getID());
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException(e);
        }
        catch (Exception e) {
            throw new SerializationException(new LocalizableExceptionAdapter(e));
        }
    }

    protected String getHRef(XMLReader reader) throws Exception {
        String href = null;
        Attributes attrs = reader.getAttributes();
        href = attrs.getValue("", "href");
        if (href != null) {
            if (href.charAt(0) == '#') {
                href = href.substring(1);
            } else if (!href.startsWith("cid:")) {
                throw new DeserializationException("soap.nonLocalReference", href);
            }
        }
        return href;
    }

    private String getIDRef(XMLReader reader) throws Exception {
        String href = null;
        Attributes attrs = reader.getAttributes();
        href = attrs.getValue("", this.soapEncodingConstants.getQNameAttrHREF().getLocalPart());
        return href;
    }
}

