/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.util;

import com.nec.webotx.webservice.xml.rpc.processor.ProcessorNotificationListener;
import com.nec.webotx.webservice.xml.rpc.processor.generator.Names;
import com.nec.webotx.webservice.xml.rpc.processor.util.GeneratedFileInfo;
import com.nec.webotx.webservice.xml.rpc.processor.util.ProcessorEnvironment;
import com.nec.webotx.webservice.xml.rpc.processor.util.ProcessorEnvironmentBase;
import com.nec.webotx.webservice.xml.rpc.util.JAXRPCClassFactory;
import com.nec.webotx.webservice.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClientProcessorEnvironment
extends ProcessorEnvironmentBase
implements ProcessorEnvironment {
    private OutputStream out;
    private PrintStream outprintstream;
    private ProcessorNotificationListener listener;
    private String classPath;
    private List generatedFiles = new ArrayList();
    private int nwarnings;
    private int nerrors;
    private int flags;
    private Names names;

    public ClientProcessorEnvironment(OutputStream out, String classPath, ProcessorNotificationListener listener) {
        this.out = out;
        this.classPath = classPath;
        this.listener = listener;
        this.flags = 0;
        this.names = JAXRPCClassFactory.newInstance().createNames();
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public boolean verbose() {
        return (this.flags & 1) != 0;
    }

    public void addGeneratedFile(GeneratedFileInfo file) {
        this.generatedFiles.add(file);
    }

    public Iterator getGeneratedFiles() {
        return this.generatedFiles.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGeneratedFiles() {
        List list = this.generatedFiles;
        synchronized (list) {
            Iterator iter = this.generatedFiles.iterator();
            while (iter.hasNext()) {
                File file = ((GeneratedFileInfo)iter.next()).getFile();
                if (!file.getName().endsWith(".java")) continue;
                file.delete();
            }
            this.generatedFiles.clear();
        }
    }

    public void shutdown() {
        this.listener = null;
        this.generatedFiles = null;
    }

    public void error(Localizable msg) {
        if (this.listener != null) {
            this.listener.onError(msg);
        }
        ++this.nerrors;
    }

    public void warn(Localizable msg) {
        if (this.warnings()) {
            ++this.nwarnings;
            if (this.listener != null) {
                this.listener.onWarning(msg);
            }
        }
    }

    public void info(Localizable msg) {
        if (this.listener != null) {
            this.listener.onInfo(msg);
        }
    }

    public void printStackTrace(Throwable t) {
        if (this.outprintstream == null) {
            this.outprintstream = new PrintStream(this.out);
        }
        t.printStackTrace(this.outprintstream);
    }

    public Names getNames() {
        return this.names;
    }

    public int getErrorCount() {
        return this.nerrors;
    }

    public int getWarningCount() {
        return this.nwarnings;
    }

    private boolean warnings() {
        return (this.flags & 2) != 0;
    }

    public void setNames(Names names) {
        this.names = names;
    }
}

