/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.util.localization;

import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.nec.webotx.webservice.xml.rpc.util.localization.Localizable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    protected Locale _locale;
    protected HashMap _resourceBundles;

    public Localizer() {
        this(Locale.getDefault());
    }

    public Localizer(Locale l) {
        this._locale = l;
        this._resourceBundles = new HashMap();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String localize(Localizable l) {
        String bundlename = l.getResourceBundleName();
        try {
            ResourceBundle bundle = (ResourceBundle)this._resourceBundles.get(bundlename);
            if (bundle == null) {
                block13: {
                    try {
                        bundle = ResourceBundle.getBundle(bundlename, this._locale);
                    }
                    catch (MissingResourceException e) {
                        int i = bundlename.lastIndexOf(46);
                        if (i == -1) break block13;
                        String alternateBundleName = bundlename.substring(i + 1);
                        try {
                            bundle = ResourceBundle.getBundle(alternateBundleName, this._locale);
                        }
                        catch (MissingResourceException e2) {
                            return this.getDefaultMessage(l);
                        }
                    }
                }
                this._resourceBundles.put(bundlename, bundle);
            }
            if (bundle == null) {
                return this.getDefaultMessage(l);
            }
            String key = l.getKey();
            if (key == null) {
                key = "undefined";
            }
            String msg = null;
            try {
                msg = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                msg = bundle.getString("undefined");
            }
            Object[] args = l.getArguments();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof Localizable)) continue;
                    args[i] = this.localize((Localizable)args[i]);
                }
            }
            String message = MessageFormat.format(msg, args);
            return message;
        }
        catch (MissingResourceException e) {
            return this.getDefaultMessage(l);
        }
    }

    protected String getDefaultMessage(Localizable l) {
        String key = l.getKey();
        Object[] args = l.getArguments();
        StringBuffer sb = new StringBuffer();
        if (!(l instanceof LocalizableExceptionAdapter)) {
            sb.append("[failed to localize] ");
        }
        sb.append(String.valueOf(key));
        if (args != null) {
            sb.append('(');
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(args[i]));
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

