/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.client.dii;

import com.nec.webotx.webservice.xml.rpc.client.dii.OperationInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;

public class PortInfo {
    Map operationMap;
    String targetEndpoint;
    String defaultNamespace;
    QName name;
    QName portTypeName;

    public PortInfo(QName name) {
        this.init();
        this.name = name;
    }

    protected void init() {
        this.operationMap = new HashMap();
        this.targetEndpoint = "";
        this.defaultNamespace = "";
    }

    public QName getName() {
        return this.name;
    }

    public OperationInfo createOperationForName(String operationName) {
        OperationInfo operation = (OperationInfo)this.operationMap.get(operationName);
        if (operation == null) {
            operation = new OperationInfo(operationName);
            operation.setNamespace(this.defaultNamespace);
            this.operationMap.put(operationName, operation);
        }
        return operation;
    }

    public void setPortTypeName(QName typeName) {
        this.portTypeName = typeName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setDefaultNamespace(String namespace) {
        this.defaultNamespace = namespace;
    }

    public boolean isOperationKnown(String operationName) {
        return this.operationMap.get(operationName) != null;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setTargetEndpoint(String target) {
        this.targetEndpoint = target;
    }

    public Iterator getOperations() {
        return this.operationMap.values().iterator();
    }

    public int getOperationCount() {
        return this.operationMap.values().size();
    }
}

