/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.client.dii.webservice.parser;

import com.nec.webotx.webservice.xml.rpc.client.dii.webservice.WebServicesClientException;
import com.nec.webotx.webservice.xml.rpc.streaming.Attributes;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.util.xml.XmlUtil;
import javax.xml.namespace.QName;

public class ParserUtil {
    public static String getAttribute(XMLReader reader, String name) {
        Attributes attributes = reader.getAttributes();
        return attributes.getValue(name);
    }

    public static String getNonEmptyAttribute(XMLReader reader, String name) {
        String value = ParserUtil.getAttribute(reader, name);
        if (value != null && value.equals("")) {
            ParserUtil.failWithLocalName("client.invalidAttributeValue", reader, name);
        }
        return value;
    }

    public static String getMandatoryAttribute(XMLReader reader, String name) {
        String value = ParserUtil.getAttribute(reader, name);
        if (value == null) {
            ParserUtil.failWithLocalName("client.missing.attribute", reader, name);
        }
        return value;
    }

    public static String getMandatoryNonEmptyAttribute(XMLReader reader, String name) {
        String value = ParserUtil.getAttribute(reader, name);
        if (value == null) {
            ParserUtil.failWithLocalName("client.missing.attribute", reader, name);
        } else if (value.equals("")) {
            ParserUtil.failWithLocalName("client.invalidAttributeValue", reader, name);
        }
        return value;
    }

    public static QName getQNameAttribute(XMLReader reader, String name) {
        String value = ParserUtil.getAttribute(reader, name);
        if (value == null) {
            return null;
        }
        String prefix = XmlUtil.getPrefix(value);
        String uri = "";
        if (prefix != null && (uri = reader.getURI(prefix)) == null) {
            ParserUtil.failWithLocalName("client.invalidAttributeValue", reader, name);
        }
        String localPart = XmlUtil.getLocalPart(value);
        return new QName(uri, localPart);
    }

    public static void ensureNoContent(XMLReader reader) {
        if (reader.nextElementContent() != 2) {
            ParserUtil.fail("client.unexpectedContent", reader);
        }
    }

    public static void fail(String key, XMLReader reader) {
        throw new WebServicesClientException(key, Integer.toString(reader.getLineNumber()));
    }

    public static void failWithFullName(String key, XMLReader reader) {
        throw new WebServicesClientException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getName().toString()});
    }

    public static void failWithLocalName(String key, XMLReader reader) {
        throw new WebServicesClientException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getLocalName()});
    }

    public static void failWithLocalName(String key, XMLReader reader, String arg) {
        throw new WebServicesClientException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getLocalName(), arg});
    }
}

