/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.client.http;

import com.nec.webotx.webservice.xml.rpc.client.http.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CookieJar {
    private transient Hashtable cookieJar = new Hashtable();

    public synchronized void recordAnyCookies(URLConnection connection) {
        String headerKey;
        HttpURLConnection httpConn = (HttpURLConnection)connection;
        int hi = 1;
        while ((headerKey = httpConn.getHeaderFieldKey(hi)) != null) {
            if (headerKey.equalsIgnoreCase("set-cookie")) {
                String cookieValue = httpConn.getHeaderField(hi);
                this.recordCookie(httpConn, cookieValue);
            }
            ++hi;
        }
    }

    private void recordCookie(HttpURLConnection httpConn, String cookieValue) {
        HttpCookie cookie = new HttpCookie(httpConn.getURL(), cookieValue);
        String[] twodot = new String[]{"com", "edu", "net", "org", "gov", "mil", "int"};
        String domain = cookie.getDomain();
        if (domain == null) {
            return;
        }
        domain = domain.toLowerCase();
        String host = httpConn.getURL().getHost();
        boolean domainOK = (host = host.toLowerCase()).equals(domain);
        if (!domainOK && host.endsWith(domain)) {
            int dotsNeeded = 2;
            for (int i = 0; i < twodot.length; ++i) {
                if (!domain.endsWith(twodot[i])) continue;
                dotsNeeded = 1;
            }
            int lastChar = domain.length();
            while (lastChar > 0 && dotsNeeded > 0) {
                lastChar = domain.lastIndexOf(46, lastChar - 1);
                --dotsNeeded;
            }
            if (lastChar > 0) {
                domainOK = true;
            }
        }
        if (domainOK) {
            this.recordCookie(cookie);
        }
    }

    private void recordCookie(HttpCookie cookie) {
        this.recordCookieToJar(cookie, this.cookieJar, true);
    }

    private void setCookie(URL url, String cookieHeader) {
        HttpCookie cookie = new HttpCookie(url, cookieHeader);
        this.recordCookie(cookie);
    }

    private void recordCookieToJar(HttpCookie cookie, Hashtable jar, boolean doNotify) {
        if (this.shouldRejectCookie(cookie)) {
            return;
        }
        String domain = cookie.getDomain().toLowerCase();
        Vector cookieList = (Vector)jar.get(domain);
        if (cookieList == null) {
            cookieList = new Vector();
        }
        if (this.addOrReplaceCookie(cookieList, cookie, doNotify)) {
            jar.put(domain, cookieList);
        }
    }

    private boolean addOrReplaceCookie(Vector cookies, HttpCookie cookie, boolean doNotify) {
        int numCookies = cookies.size();
        String path = cookie.getPath();
        String name = cookie.getName();
        HttpCookie replaced = null;
        int replacedIndex = -1;
        for (int i = 0; i < numCookies; ++i) {
            String existingName;
            HttpCookie existingCookie = (HttpCookie)cookies.elementAt(i);
            String existingPath = existingCookie.getPath();
            if (!path.equals(existingPath) || !name.equals(existingName = existingCookie.getName())) continue;
            replaced = existingCookie;
            replacedIndex = i;
            break;
        }
        if (replaced != null) {
            cookies.setElementAt(cookie, replacedIndex);
        } else {
            cookies.addElement(cookie);
        }
        return true;
    }

    private boolean shouldRejectCookie(HttpCookie cookie) {
        return false;
    }

    public synchronized void applyRelevantCookies(URLConnection connection) {
        this.applyRelevantCookies(connection.getURL(), connection);
    }

    private void applyRelevantCookies(URL url, URLConnection connection) {
        int index;
        HttpURLConnection httpConn = (HttpURLConnection)connection;
        String host = url.getHost();
        this.applyCookiesForHost(host, url, httpConn);
        while ((index = host.indexOf(46, 1)) >= 0) {
            host = host.substring(index + 1);
            this.applyCookiesForHost(host, url, httpConn);
        }
    }

    private void applyCookiesForHost(String host, URL url, HttpURLConnection httpConn) {
        Vector cookieList = (Vector)this.cookieJar.get(host);
        if (cookieList == null) {
            return;
        }
        String path = url.getFile();
        int queryInd = path.indexOf(63);
        if (queryInd > 0) {
            path = path.substring(0, queryInd);
        }
        Enumeration cookies = cookieList.elements();
        Vector<HttpCookie> cookiesToSend = new Vector<HttpCookie>(10);
        while (cookies.hasMoreElements()) {
            HttpCookie cookie = (HttpCookie)cookies.nextElement();
            String cookiePath = cookie.getPath();
            if (!path.startsWith(cookiePath) || cookie.hasExpired()) continue;
            cookiesToSend.addElement(cookie);
        }
        if (cookiesToSend.size() > 1) {
            for (int i = 0; i < cookiesToSend.size() - 1; ++i) {
                HttpCookie headC = (HttpCookie)cookiesToSend.elementAt(i);
                String head = headC.getPath();
                if (!head.endsWith("/")) {
                    head = head + "/";
                }
                for (int j = i + 1; j < cookiesToSend.size(); ++j) {
                    HttpCookie scanC = (HttpCookie)cookiesToSend.elementAt(j);
                    String scan = scanC.getPath();
                    if (!scan.endsWith("/")) {
                        scan = scan + "/";
                    }
                    int headCount = 0;
                    int index = -1;
                    while ((index = head.indexOf(47, index + 1)) != -1) {
                        ++headCount;
                    }
                    index = -1;
                    int scanCount = 0;
                    while ((index = scan.indexOf(47, index + 1)) != -1) {
                        ++scanCount;
                    }
                    if (scanCount <= headCount) continue;
                    cookiesToSend.setElementAt(headC, j);
                    cookiesToSend.setElementAt(scanC, i);
                    headC = scanC;
                    head = scan;
                }
            }
        }
        cookies = cookiesToSend.elements();
        String cookieStr = null;
        while (cookies.hasMoreElements()) {
            HttpCookie cookie = (HttpCookie)cookies.nextElement();
            if (cookieStr == null) {
                cookieStr = cookie.getNameValue();
                continue;
            }
            cookieStr = cookieStr + "; " + cookie.getNameValue();
        }
        if (cookieStr != null) {
            httpConn.setRequestProperty("Cookie", cookieStr);
        }
    }
}

