/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding;

import com.nec.webotx.webservice.xml.rpc.encoding.TypeMappingException;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class TypeMappingUtil {
    public static TypeMapping getTypeMapping(TypeMappingRegistry registry, String encodingStyle) throws Exception {
        TypeMapping mapping = registry.getTypeMapping(encodingStyle);
        if (mapping == null) {
            throw new TypeMappingException("typemapping.noMappingForEncoding", encodingStyle);
        }
        return mapping;
    }

    public static Serializer getSerializer(TypeMapping mapping, Class javaType, QName xmlType) throws Exception {
        SerializerFactory sf = mapping.getSerializer(javaType, xmlType);
        if (sf == null) {
            throw new TypeMappingException("typemapping.serializerNotRegistered", new Object[]{javaType, xmlType});
        }
        return sf.getSerializerAs("http://java.sun.com/jax-rpc-ri/1.0/streaming/");
    }

    public static Deserializer getDeserializer(TypeMapping mapping, Class javaType, QName xmlType) throws Exception {
        DeserializerFactory df = mapping.getDeserializer(javaType, xmlType);
        if (df == null) {
            throw new TypeMappingException("typemapping.deserializerNotRegistered", new Object[]{javaType, xmlType});
        }
        return df.getDeserializerAs("http://java.sun.com/jax-rpc-ri/1.0/streaming/");
    }
}

