/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding.simpletype;

import com.nec.webotx.webservice.xml.rpc.encoding.DeserializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.EncoderUtils;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class XSDDateEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDDateEncoder();
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");

    protected XSDDateEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        Calendar cal = (Calendar)obj;
        boolean isBC = cal.get(0) == 0;
        StringBuffer buf = new StringBuffer();
        if (isBC) {
            cal.set(0, 1);
            buf.append("-");
        }
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            buf.append(dateFormatter.format(((Calendar)obj).getTime()));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        boolean isNeg = false;
        if ((str = EncoderUtils.collapseWhitespace(str)).charAt(0) == '+') {
            str = str.substring(1);
        }
        if (str.charAt(0) == '-') {
            str = str.substring(1);
            isNeg = true;
        }
        XSDDateEncoder.validateDateStr(str);
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            cal.setTime(dateFormatter.parse(str));
        }
        if (isNeg) {
            cal.set(0, 0);
        }
        return cal;
    }

    public static void validateDateStr(String dateStr) throws Exception {
        if (dateStr.length() < 10) {
            throw new DeserializationException("xsd.invalid.date", dateStr);
        }
    }
}

