/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding.simpletype;

import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.XSDDateTimeDateEncoder;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import com.nec.webotx.webservice.xml.rpc.util.VersionUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class XSDDateTimeCalendarEncoder
extends XSDDateTimeDateEncoder {
    private static final SimpleTypeEncoder encoder = new XSDDateTimeCalendarEncoder();
    private static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final Calendar gmtCalendar = Calendar.getInstance();

    private XSDDateTimeCalendarEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        Calendar c = (Calendar)obj;
        int offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += this.getDSTSavings(c.getTimeZone());
        }
        int offsetHours = offset / 3600000;
        StringBuffer bufOffset = new StringBuffer(5);
        bufOffset.append(offset < 0 ? (char)'-' : '+');
        int n = offsetHours = offsetHours < 0 ? -offsetHours : offsetHours;
        if (offsetHours < 10) {
            bufOffset.append('0');
        }
        bufOffset.append(offsetHours + ":00");
        String offsetStr = new String(bufOffset);
        StringBuffer resultBuf = new StringBuffer();
        if (c.get(0) == 0) {
            resultBuf.append('-');
        }
        SimpleDateFormat simpleDateFormat = calendarFormatter;
        synchronized (simpleDateFormat) {
            calendarFormatter.setTimeZone(c.getTimeZone());
            resultBuf.append(calendarFormatter.format(c.getTime()));
        }
        resultBuf.append(offsetStr);
        return resultBuf.toString();
    }

    public Object stringToObject(String str, XMLReader reader) throws Exception {
        Calendar cal;
        if (str == null) {
            return null;
        }
        StringBuffer zone = new StringBuffer(10);
        Date date = XSDDateTimeCalendarEncoder.decodeDateUtil(str, zone);
        String zoneStr = zone.toString();
        if (zoneStr.length() == 0) {
            cal = Calendar.getInstance(gmtTimeZone);
            cal.setTime(date);
        } else {
            cal = Calendar.getInstance(gmtTimeZone);
            cal.setTime(date);
            TimeZone tz = TimeZone.getTimeZone("GMT" + zoneStr);
            int rawOffset = tz.getRawOffset();
            TimeZone tz2 = TimeZone.getDefault();
            if (tz2.inDaylightTime(date)) {
                rawOffset -= this.getDSTSavings(tz2);
            }
            tz2.setRawOffset(rawOffset);
            tz2.setID("Custom");
            cal.setTimeZone(tz2);
        }
        return cal;
    }

    private int getDSTSavings(TimeZone tz) {
        if (VersionUtil.isJavaVersionGreaterThan1_3()) {
            return tz.getDSTSavings();
        }
        return ((SimpleTimeZone)tz).getDSTSavings();
    }

    public void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    static {
        gmtCalendar.setTimeZone(gmtTimeZone);
    }
}

