/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.generator;

import com.nec.webotx.webservice.xml.rpc.encoding.InternalEncodingConstants;
import com.nec.webotx.webservice.xml.rpc.processor.config.ImportedDocumentInfo;
import com.nec.webotx.webservice.xml.rpc.processor.generator.GeneratorException;
import com.nec.webotx.webservice.xml.rpc.processor.generator.GeneratorUtil;
import com.nec.webotx.webservice.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.nec.webotx.webservice.xml.rpc.processor.model.AbstractType;
import com.nec.webotx.webservice.xml.rpc.processor.model.Block;
import com.nec.webotx.webservice.xml.rpc.processor.model.Fault;
import com.nec.webotx.webservice.xml.rpc.processor.model.Message;
import com.nec.webotx.webservice.xml.rpc.processor.model.Model;
import com.nec.webotx.webservice.xml.rpc.processor.model.Operation;
import com.nec.webotx.webservice.xml.rpc.processor.model.Parameter;
import com.nec.webotx.webservice.xml.rpc.processor.model.Port;
import com.nec.webotx.webservice.xml.rpc.processor.model.Service;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaException;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralAllType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralArrayType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralElementMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralIDType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralListType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPAnyType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPArrayType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPCustomType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPListType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.modeler.rmi.LiteralSimpleTypeCreator;
import com.nec.webotx.webservice.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreatorBase;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPConstantsFactory;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPWSDLConstants;
import com.nec.webotx.webservice.xml.rpc.util.JAXRPCClassFactory;
import com.nec.webotx.webservice.xml.rpc.util.VersionUtil;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.Definitions;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.Import;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.Types;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.WSDLConstants;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.WSDLDocument;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.Schema;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaElement;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.soap.SOAP12Constants;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.soap.SOAPConstants;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class WSDLTypeGenerator {
    private SOAPWSDLConstants soapWSDLConstants = null;
    private Model model;
    private WSDLDocument document;
    private Definitions definitions;
    private Set generatedTypes;
    private Set generatedElements;
    private Map nsSchemaMap;
    private Set actuallyImportedDocuments;
    private SOAPSimpleTypeCreatorBase soapTypes;
    private LiteralSimpleTypeCreator literalTypes;
    private SOAPVersion soapVer;
    private boolean isEncodedWsdl;
    private Properties options;

    public WSDLTypeGenerator(Model model, WSDLDocument document, Properties options) {
        this(model, document, options, SOAPVersion.SOAP_11);
    }

    public WSDLTypeGenerator(Model model, WSDLDocument document, Properties options, SOAPVersion ver) {
        this.init(ver);
        this.model = model;
        this.document = document;
        this.definitions = document.getDefinitions();
        this.options = options;
        this.generatedTypes = new HashSet();
        this.generatedElements = new HashSet();
        this.nsSchemaMap = new HashMap();
        this.actuallyImportedDocuments = new HashSet();
        this.soapTypes = JAXRPCClassFactory.newInstance().createSOAPSimpleTypeCreator();
        this.literalTypes = new LiteralSimpleTypeCreator();
        this.init(ver);
    }

    private void init(SOAPVersion ver) {
        this.soapWSDLConstants = SOAPConstantsFactory.getSOAPWSDLConstants(ver);
        this.soapVer = ver;
    }

    protected SOAPVersion getSOAPVersion(AbstractType type) {
        if (type.isSOAPType()) {
            String ver = type.getVersion();
            if (ver.equals(SOAPVersion.SOAP_11.toString())) {
                this.soapVer = SOAPVersion.SOAP_11;
            } else if (ver.equals(SOAPVersion.SOAP_12.toString())) {
                this.soapVer = SOAPVersion.SOAP_12;
            }
        }
        return this.soapVer;
    }

    protected String getSOAPEncodingNamespace(AbstractType type) {
        if (this.getSOAPVersion(type).equals(SOAPVersion.SOAP_11.toString())) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        return "http://www.w3.org/2002/06/soap-encoding";
    }

    protected String getNamespacePrefix(AbstractType type) {
        if (SOAPVersion.SOAP_12.equals(type.getVersion())) {
            return "soap12-enc";
        }
        return "soap11-enc";
    }

    protected QName getQNameAttrArrayType(AbstractType type) {
        String ver = null;
        ver = type == null ? this.soapVer.toString() : type.getVersion();
        if (ver.equals(SOAPVersion.SOAP_11.toString())) {
            return SOAPConstants.QNAME_ATTR_ARRAY_TYPE;
        }
        return SOAP12Constants.QNAME_ATTR_ARRAY_TYPE;
    }

    public void run() throws Exception {
        Operation operation;
        Iterator operations;
        Port port;
        Iterator ports;
        Service service;
        this.isEncodedWsdl = false;
        Types types = new Types();
        Iterator services = this.model.getServices();
        while (services.hasNext()) {
            service = (Service)services.next();
            ports = service.getPorts();
            while (ports.hasNext()) {
                port = (Port)ports.next();
                operations = port.getOperations();
                while (operations.hasNext()) {
                    operation = (Operation)operations.next();
                    this.processTypesInMessage(operation.getRequest());
                    this.processTypesInMessage(operation.getResponse());
                    TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    faultSet.addAll(operation.getAllFaultsSet());
                    Iterator faults = faultSet.iterator();
                    while (faults != null && faults.hasNext()) {
                        Fault fault = (Fault)faults.next();
                        this.processFault(fault);
                    }
                }
            }
        }
        Iterator iter = this.model.getExtraTypes();
        while (iter.hasNext()) {
            this.processType((AbstractType)iter.next());
        }
        services = this.model.getServices();
        while (services.hasNext()) {
            service = (Service)services.next();
            ports = service.getPorts();
            while (ports.hasNext()) {
                port = (Port)ports.next();
                operations = port.getOperations();
                while (operations.hasNext()) {
                    operation = (Operation)operations.next();
                    if (operation.getStyle() == SOAPStyle.DOCUMENT) {
                        this.processElementsInMessage(operation.getRequest());
                        this.processElementsInMessage(operation.getResponse());
                    }
                    Iterator faults = operation.getAllFaults();
                    while (faults != null && faults.hasNext()) {
                        Fault fault = (Fault)faults.next();
                        this.processElementInFault(fault);
                    }
                }
            }
        }
        ArrayList<ImportedDocumentInfo> importedDocumentsInReverseOrder = new ArrayList<ImportedDocumentInfo>();
        Iterator<Object> iter2 = this.actuallyImportedDocuments.iterator();
        while (iter2.hasNext()) {
            ImportedDocumentInfo docInfo = (ImportedDocumentInfo)iter2.next();
            Import anImport = new Import();
            anImport.setNamespace(docInfo.getNamespace());
            anImport.setLocation(docInfo.getLocation());
            this.definitions.add(anImport);
            importedDocumentsInReverseOrder.add(0, docInfo);
        }
        iter2 = this.nsSchemaMap.values().iterator();
        while (iter2.hasNext()) {
            Schema schema = (Schema)iter2.next();
            Iterator definedEntities = schema.definedEntities();
            if (!definedEntities.hasNext()) continue;
            SchemaElement schemaContent = schema.getContent();
            Iterator iter22 = importedDocumentsInReverseOrder.iterator();
            while (iter22.hasNext()) {
                ImportedDocumentInfo docInfo = (ImportedDocumentInfo)iter22.next();
                SchemaElement importElement = new SchemaElement(SchemaConstants.QNAME_IMPORT);
                importElement.addAttribute("namespace", docInfo.getNamespace());
                importElement.addAttribute("schemaLocation", docInfo.getLocation());
                schemaContent.insertChildAtTop(importElement);
            }
            Iterator iter3 = this.nsSchemaMap.keySet().iterator();
            while (iter3.hasNext()) {
                Schema anotherSchema;
                Iterator anotherSchemaDefinedEntities;
                String nsURI = (String)iter3.next();
                if (schema.getTargetNamespaceURI().equals(nsURI) || !(anotherSchemaDefinedEntities = (anotherSchema = (Schema)this.nsSchemaMap.get(nsURI)).definedEntities()).hasNext()) continue;
                SchemaElement importElement = new SchemaElement(SchemaConstants.QNAME_IMPORT);
                importElement.addAttribute("namespace", nsURI);
                schemaContent.insertChildAtTop(importElement);
            }
            if (this.isEncodedWsdl) {
                SchemaElement importElement = new SchemaElement(SchemaConstants.QNAME_IMPORT);
                importElement.addAttribute("namespace", "http://schemas.xmlsoap.org/soap/encoding/");
                schemaContent.insertChildAtTop(importElement);
            }
            types.addExtension(schema);
        }
        this.definitions.setTypes(types);
    }

    private void processTypesInMessage(Message message) throws Exception {
        AbstractType type;
        Block block;
        if (message == null) {
            return;
        }
        Iterator iter = message.getBodyBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            this.processType(type);
        }
        iter = message.getHeaderBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            this.processType(type);
        }
        iter = message.getParameters();
        while (iter.hasNext()) {
            Parameter param = (Parameter)iter.next();
            type = param.getType();
            this.processType(type);
        }
    }

    private void processElementsInMessage(Message message) throws Exception {
        if (message == null) {
            return;
        }
        Iterator iter = message.getBodyBlocks();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            QName name = block.getName();
            AbstractType type = block.getType();
            if (!type.isLiteralType()) continue;
            this.processElement(name, (LiteralType)type);
        }
    }

    private void processElementInFault(Fault fault) throws Exception {
        if (fault.getElementName() != null && fault.getBlock().getType().isLiteralType()) {
            this.processElement(fault.getElementName(), (LiteralType)fault.getBlock().getType());
        }
    }

    private void processType(AbstractType type) throws Exception {
        boolean isReqOrRespStruct;
        boolean bl = isReqOrRespStruct = type instanceof RPCRequestOrderedStructureType || type instanceof RPCRequestOrderedStructureType || type instanceof RPCResponseStructureType;
        if (!isReqOrRespStruct && (type.getName() == null || this.generatedTypes.contains(type.getName()))) {
            return;
        }
        if (type.getName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || type.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/") || type.getName().getNamespaceURI().equals("http://www.w3.org/2002/06/soap-encoding")) {
            return;
        }
        ImportedDocumentInfo docInfo = this.model.getImportedDocument(type.getName().getNamespaceURI());
        if (docInfo != null && docInfo.getType() == 1) {
            this.actuallyImportedDocuments.add(docInfo);
            return;
        }
        Schema schema = (Schema)this.nsSchemaMap.get(type.getName().getNamespaceURI());
        if (schema == null) {
            schema = new Schema(this.document);
            schema.setTargetNamespaceURI(type.getName().getNamespaceURI());
            SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
            schemaElement.addAttribute("targetNamespace", schema.getTargetNamespaceURI());
            schemaElement.addPrefix("", "http://www.w3.org/2001/XMLSchema");
            schemaElement.addPrefix("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            schemaElement.addPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            schemaElement.addPrefix(this.getNamespacePrefix(type), this.getSOAPEncodingNamespace(type));
            schemaElement.addPrefix("tns", schema.getTargetNamespaceURI());
            schema.setContent(schemaElement);
            this.nsSchemaMap.put(type.getName().getNamespaceURI(), schema);
        }
        if (!isReqOrRespStruct) {
            this.generatedTypes.add(type.getName());
        }
        if (type.isLiteralType()) {
            this.processType((LiteralType)type, schema);
        } else {
            this.isEncodedWsdl = true;
            this.processType((SOAPType)type, schema);
        }
    }

    private void processType(SOAPType type, final Schema schema) throws Exception {
        type.accept(new SOAPTypeVisitor(){

            public void visit(SOAPArrayType type) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                complexType.addChild(complexContent);
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                complexContent.addChild(restriction);
                restriction.addAttribute("base", WSDLTypeGenerator.this.getNamespacePrefix(type) + ":Array");
                SchemaElement attribute = new SchemaElement(SchemaConstants.QNAME_ATTRIBUTE);
                restriction.addChild(attribute);
                attribute.addAttribute("ref", WSDLTypeGenerator.this.getQNameAttrArrayType(type));
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                SchemaAttribute wsdlArrayTypeAttribute = new SchemaAttribute(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getLocalPart());
                wsdlArrayTypeAttribute.setNamespaceURI(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getNamespaceURI());
                String arrayTypeString = attribute.asString(type.getElementType().getName()) + "[]";
                wsdlArrayTypeAttribute.setValue(arrayTypeString);
                attribute.addAttribute(wsdlArrayTypeAttribute);
                WSDLTypeGenerator.this.processType(type.getElementType());
            }

            public void visit(SOAPCustomType type) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                complexType.addChild(complexContent);
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_ANY);
                complexContent.addChild(restriction);
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
            }

            public void visit(SOAPEnumerationType type) throws Exception {
                SchemaElement simpleType = new SchemaElement(SchemaConstants.QNAME_SIMPLE_TYPE);
                schema.getContent().addChild(simpleType);
                simpleType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                simpleType.addChild(restriction);
                restriction.addAttribute("base", type.getBaseType().getName());
                JavaEnumerationType javaType = (JavaEnumerationType)type.getJavaType();
                Iterator iter = javaType.getEntries();
                while (iter.hasNext()) {
                    JavaEnumerationEntry entry = (JavaEnumerationEntry)iter.next();
                    SchemaElement enumeration = new SchemaElement(SchemaConstants.QNAME_ENUMERATION);
                    enumeration.addAttribute("value", entry.getLiteralValue());
                    restriction.addChild(enumeration);
                }
                schema.defineEntity(simpleType, SchemaKinds.XSD_TYPE, type.getName());
            }

            public void visit(SOAPSimpleType type) throws Exception {
                if (type.getName().getNamespaceURI().equals("http://java.sun.com/jax-rpc-ri/internal")) {
                    if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY)) {
                        this.writeJAXRpcMapEntryType();
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_MAP)) {
                        this.writeMapType(type);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.JAX_RPC_MAP_ENTRY_SOAPTYPE);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASH_MAP) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_TREE_MAP) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASHTABLE) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_PROPERTIES)) {
                        this.writeTypeSubtype(type, InternalEncodingConstants.QNAME_TYPE_MAP);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.MAP_SOAPTYPE);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_COLLECTION)) {
                        this.writeCollectionType(type);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_LIST) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_SET)) {
                        this.writeTypeSubtype(type, InternalEncodingConstants.QNAME_TYPE_COLLECTION);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.COLLECTION_SOAPTYPE);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_ARRAY_LIST) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_VECTOR) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_STACK) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_LINKED_LIST)) {
                        this.writeTypeSubtype(type, InternalEncodingConstants.QNAME_TYPE_LIST);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.LIST_SOAPTYPE);
                    } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASH_SET) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_TREE_SET)) {
                        this.writeTypeSubtype(type, InternalEncodingConstants.QNAME_TYPE_SET);
                        WSDLTypeGenerator.this.processType(((WSDLTypeGenerator)WSDLTypeGenerator.this).soapTypes.SET_SOAPTYPE);
                    } else {
                        SchemaElement simpleType = new SchemaElement(SchemaConstants.QNAME_SIMPLE_TYPE);
                        schema.getContent().addChild(simpleType);
                        simpleType.addAttribute("name", type.getName().getLocalPart());
                        SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                        simpleType.addChild(restriction);
                        QName baseType = SchemaConstants.QNAME_TYPE_BASE64_BINARY;
                        if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_SOURCE)) {
                            baseType = SchemaConstants.QNAME_TYPE_STRING;
                        }
                        restriction.addAttribute("base", baseType);
                        schema.defineEntity(simpleType, SchemaKinds.XSD_TYPE, type.getName());
                    }
                }
            }

            private void writeJAXRpcMapEntryType() throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY.getLocalPart());
                SchemaElement sequenceParent = complexType;
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                sequenceParent.addChild(sequence);
                SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                sequence.addChild(element);
                element.addAttribute("name", InternalEncodingConstants.JAX_RPC_MAP_ENTRY_KEY_NAME.getLocalPart());
                element.addAttribute("type", SchemaConstants.QNAME_TYPE_URTYPE);
                element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                sequence.addChild(element);
                element.addAttribute("name", InternalEncodingConstants.JAX_RPC_MAP_ENTRY_VALUE_NAME.getLocalPart());
                element.addAttribute("type", SchemaConstants.QNAME_TYPE_URTYPE);
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY);
            }

            private void writeMapType(AbstractType type) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", InternalEncodingConstants.QNAME_TYPE_MAP.getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                complexType.addChild(complexContent);
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                complexContent.addChild(restriction);
                restriction.addAttribute("base", WSDLTypeGenerator.this.getNamespacePrefix(type) + ":Array");
                SchemaElement attribute = new SchemaElement(SchemaConstants.QNAME_ATTRIBUTE);
                restriction.addChild(attribute);
                attribute.addAttribute("ref", WSDLTypeGenerator.this.getQNameAttrArrayType(null));
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, InternalEncodingConstants.QNAME_TYPE_MAP);
                SchemaAttribute wsdlArrayTypeAttribute = new SchemaAttribute(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getLocalPart());
                wsdlArrayTypeAttribute.setNamespaceURI(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getNamespaceURI());
                String arrayTypeString = attribute.asString(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY) + "[]";
                wsdlArrayTypeAttribute.setValue(arrayTypeString);
                attribute.addAttribute(wsdlArrayTypeAttribute);
            }

            private void writeTypeSubtype(AbstractType type, QName superTypeName) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                complexType.addChild(complexContent);
                SchemaElement extension = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                complexContent.addChild(extension);
                extension.addAttribute("base", superTypeName);
                SchemaElement sequenceParent = extension;
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                sequenceParent.addChild(sequence);
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
            }

            private void writeCollectionType(AbstractType type) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                complexType.addChild(complexContent);
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                complexContent.addChild(restriction);
                restriction.addAttribute("base", WSDLTypeGenerator.this.getNamespacePrefix(type) + ":Array");
                SchemaElement attribute = new SchemaElement(SchemaConstants.QNAME_ATTRIBUTE);
                restriction.addChild(attribute);
                attribute.addAttribute("ref", WSDLTypeGenerator.this.getQNameAttrArrayType(type));
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                SchemaAttribute wsdlArrayTypeAttribute = new SchemaAttribute(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getLocalPart());
                wsdlArrayTypeAttribute.setNamespaceURI(WSDLConstants.QNAME_ATTR_ARRAY_TYPE.getNamespaceURI());
                String arrayTypeString = attribute.asString(SchemaConstants.QNAME_TYPE_URTYPE) + "[]";
                wsdlArrayTypeAttribute.setValue(arrayTypeString);
                attribute.addAttribute(wsdlArrayTypeAttribute);
            }

            public void visit(SOAPAnyType type) throws Exception {
            }

            public void visit(SOAPListType type) throws Exception {
            }

            public void visit(SOAPOrderedStructureType type) throws Exception {
                this.visit((SOAPStructureType)type);
            }

            public void visit(SOAPUnorderedStructureType type) throws Exception {
                SOAPStructureMember member;
                SOAPStructureType parentType = type.getParentType();
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement sequenceParent = complexType;
                if (parentType != null) {
                    SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                    complexType.addChild(complexContent);
                    SchemaElement extension = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                    complexContent.addChild(extension);
                    extension.addAttribute("base", parentType.getName());
                    sequenceParent = extension;
                }
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_ALL);
                sequenceParent.addChild(sequence);
                Iterator iter = type.getMembers();
                while (iter.hasNext()) {
                    member = (SOAPStructureMember)iter.next();
                    if (member.isInherited() && type.getParentType() != null) continue;
                    SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                    sequence.addChild(element);
                    element.addAttribute("name", member.getName().getLocalPart());
                    element.addAttribute("type", member.getType().getName());
                }
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                if (parentType != null) {
                    WSDLTypeGenerator.this.processType(type.getParentType());
                }
                iter = type.getMembers();
                while (iter.hasNext()) {
                    member = (SOAPStructureMember)iter.next();
                    WSDLTypeGenerator.this.processType(member.getType());
                }
                Iterator subtypes = type.getSubtypes();
                if (subtypes != null) {
                    while (subtypes.hasNext()) {
                        WSDLTypeGenerator.this.processType((AbstractType)subtypes.next());
                    }
                }
            }

            public void visit(RPCRequestOrderedStructureType type) throws Exception {
                Iterator iter = type.getMembers();
                while (iter.hasNext()) {
                    SOAPStructureMember member = (SOAPStructureMember)iter.next();
                    WSDLTypeGenerator.this.processType(member.getType());
                }
            }

            public void visit(RPCRequestUnorderedStructureType type) throws Exception {
                Iterator iter = type.getMembers();
                while (iter.hasNext()) {
                    SOAPStructureMember member = (SOAPStructureMember)iter.next();
                    WSDLTypeGenerator.this.processType(member.getType());
                }
            }

            public void visit(RPCResponseStructureType type) throws Exception {
                Iterator iter = type.getMembers();
                while (iter.hasNext()) {
                    SOAPStructureMember member = (SOAPStructureMember)iter.next();
                    WSDLTypeGenerator.this.processType(member.getType());
                }
            }

            protected void visit(SOAPStructureType type) throws Exception {
                SOAPStructureMember member;
                SOAPStructureType parentType = type.getParentType();
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement sequenceParent = complexType;
                if (parentType != null) {
                    SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                    complexType.addChild(complexContent);
                    SchemaElement extension = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                    complexContent.addChild(extension);
                    extension.addAttribute("base", parentType.getName());
                    sequenceParent = extension;
                }
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                sequenceParent.addChild(sequence);
                Iterator iter = type.getMembers();
                while (iter.hasNext()) {
                    member = (SOAPStructureMember)iter.next();
                    if (member.isInherited() && type.getParentType() != null) continue;
                    SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                    sequence.addChild(element);
                    element.addAttribute("name", member.getName().getLocalPart());
                    element.addAttribute("type", member.getType().getName());
                }
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                if (parentType != null) {
                    WSDLTypeGenerator.this.processType(type.getParentType());
                }
                iter = type.getMembers();
                while (iter.hasNext()) {
                    member = (SOAPStructureMember)iter.next();
                    WSDLTypeGenerator.this.processType(member.getType());
                }
                Iterator subtypes = type.getSubtypes();
                if (subtypes != null) {
                    while (subtypes.hasNext()) {
                        WSDLTypeGenerator.this.processType((AbstractType)subtypes.next());
                    }
                }
            }
        });
    }

    private void processType(LiteralType type, final Schema schema) throws Exception {
        type.accept(new LiteralTypeVisitor(){

            public void visit(LiteralArrayType type) throws Exception {
                LiteralType elemType = type.getElementType();
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement sequenceParent = complexType;
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                sequenceParent.addChild(sequence);
                SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                sequence.addChild(element);
                element.addAttribute("name", elemType.getName().getLocalPart());
                element.addAttribute("type", elemType.getName());
                if (((AbstractType)elemType).isNillable()) {
                    element.addAttribute("nillable", "true");
                }
                element.addAttribute("minOccurs", "0");
                element.addAttribute("maxOccurs", "unbounded");
                schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                WSDLTypeGenerator.this.processType(elemType);
            }

            public void visit(LiteralArrayWrapperType type) throws Exception {
                this.visitStructuredType(SchemaConstants.QNAME_SEQUENCE, type);
            }

            public void visit(LiteralSimpleType type) throws Exception {
            }

            public void visit(LiteralListType type) throws Exception {
            }

            public void visit(LiteralIDType type) throws Exception {
            }

            public void visit(LiteralSequenceType type) throws Exception {
                this.visitStructuredType(SchemaConstants.QNAME_SEQUENCE, type);
            }

            public void visit(LiteralAllType type) throws Exception {
                this.visitStructuredType(SchemaConstants.QNAME_ALL, type);
            }

            public void visit(LiteralEnumerationType type) throws Exception {
                SchemaElement simpleType = new SchemaElement(SchemaConstants.QNAME_SIMPLE_TYPE);
                schema.getContent().addChild(simpleType);
                simpleType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement restriction = new SchemaElement(SchemaConstants.QNAME_RESTRICTION);
                simpleType.addChild(restriction);
                restriction.addAttribute("base", type.getBaseType().getName());
                JavaEnumerationType javaType = (JavaEnumerationType)type.getJavaType();
                Iterator iter = javaType.getEntries();
                while (iter.hasNext()) {
                    JavaEnumerationEntry entry = (JavaEnumerationEntry)iter.next();
                    SchemaElement enumeration = new SchemaElement(SchemaConstants.QNAME_ENUMERATION);
                    enumeration.addAttribute("value", entry.getLiteralValue());
                    restriction.addChild(enumeration);
                }
                schema.defineEntity(simpleType, SchemaKinds.XSD_TYPE, type.getName());
            }

            public void visit(LiteralFragmentType type) throws Exception {
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                complexType.addAttribute("name", type.getName().getLocalPart());
                SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                complexType.addChild(complexContent);
                SchemaElement extension = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                complexContent.addChild(extension);
                extension.addAttribute("base", SchemaConstants.QNAME_TYPE_URTYPE);
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                extension.addChild(sequence);
            }

            protected void visitStructuredType(QName compositor, LiteralStructuredType type) throws Exception {
                Iterator subtypes;
                Object member;
                LiteralStructuredType parentType = type.getParentType();
                if (!type.isRpcWrapper()) {
                    SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                    schema.getContent().addChild(complexType);
                    complexType.addAttribute("name", type.getName().getLocalPart());
                    SchemaElement sequenceParent = complexType;
                    if (parentType != null) {
                        SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                        complexType.addChild(complexContent);
                        SchemaElement extension = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                        complexContent.addChild(extension);
                        extension.addAttribute("base", parentType.getName());
                        sequenceParent = extension;
                    }
                    SchemaElement sequence = new SchemaElement(compositor);
                    sequenceParent.addChild(sequence);
                    Iterator iter = type.getElementMembers();
                    while (iter.hasNext()) {
                        LiteralElementMember member2 = (LiteralElementMember)iter.next();
                        if (member2.isInherited() && type.getParentType() != null) continue;
                        SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
                        sequence.addChild(element);
                        element.addAttribute("name", member2.getName().getLocalPart());
                        element.addAttribute("type", member2.getType().getName());
                        if (member2.isNillable()) {
                            element.addAttribute("nillable", "true");
                        }
                        if (!member2.isRepeated()) continue;
                        element.addAttribute("minOccurs", "0");
                        element.addAttribute("maxOccurs", "unbounded");
                    }
                    schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                }
                Iterator iter = type.getElementMembers();
                while (iter.hasNext()) {
                    member = (LiteralElementMember)iter.next();
                    WSDLTypeGenerator.this.processType(((LiteralElementMember)member).getType());
                }
                iter = type.getAttributeMembers();
                while (iter.hasNext()) {
                    member = (LiteralAttributeMember)iter.next();
                    WSDLTypeGenerator.this.processType(((LiteralAttributeMember)member).getType());
                }
                if (parentType != null) {
                    WSDLTypeGenerator.this.processType(type.getParentType());
                }
                if ((subtypes = type.getSubtypes()) != null) {
                    while (subtypes.hasNext()) {
                        WSDLTypeGenerator.this.processType((AbstractType)subtypes.next());
                    }
                }
            }
        });
    }

    private void processFault(Fault fault) throws Exception {
        AbstractType type = fault.getBlock().getType();
        AbstractType faultType = type instanceof SOAPStructureType || type instanceof LiteralStructuredType ? type : (AbstractType)fault.getJavaException().getOwner();
        if (faultType.getName() == null || this.generatedTypes.contains(faultType.getName())) {
            return;
        }
        if ((type.getName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || type.getName().getNamespaceURI().equals("http://www.w3.org/2002/06/soap-encoding") || type.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) && fault.getAllFaults() == null) {
            return;
        }
        ImportedDocumentInfo docInfo = this.model.getImportedDocument(type.getName().getNamespaceURI());
        if (docInfo != null && docInfo.getType() == 1) {
            this.actuallyImportedDocuments.add(docInfo);
            return;
        }
        Schema schema = (Schema)this.nsSchemaMap.get(faultType.getName().getNamespaceURI());
        if (schema == null) {
            schema = new Schema(this.document);
            schema.setTargetNamespaceURI(type.getName().getNamespaceURI());
            SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
            schemaElement.addAttribute("targetNamespace", schema.getTargetNamespaceURI());
            schemaElement.addPrefix("", "http://www.w3.org/2001/XMLSchema");
            schemaElement.addPrefix("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            schemaElement.addPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            schemaElement.addPrefix(this.getNamespacePrefix(type), this.getSOAPEncodingNamespace(type));
            schemaElement.addPrefix("tns", schema.getTargetNamespaceURI());
            schema.setContent(schemaElement);
            this.nsSchemaMap.put(type.getName().getNamespaceURI(), schema);
        }
        this.generatedTypes.add(type.getName());
        this.processFault(fault, schema);
    }

    private void processFault(Fault fault, Schema schema) throws Exception {
        block28: {
            Iterator subtypes;
            Object member;
            Iterator iter;
            AbstractType type;
            block27: {
                Object member2;
                Iterator iter2;
                Fault parentFault = fault.getParentFault();
                type = fault.getBlock().getType();
                AbstractType parentType = parentFault != null ? parentFault.getBlock().getType() : null;
                SchemaElement complexType = new SchemaElement(SchemaConstants.QNAME_COMPLEX_TYPE);
                schema.getContent().addChild(complexType);
                boolean deserializeToDetail = false;
                if (type instanceof SOAPStructureType || type instanceof LiteralStructuredType) {
                    complexType.addAttribute("name", type.getName().getLocalPart());
                    deserializeToDetail = SOAPObjectSerializerGenerator.deserializeToDetail(type);
                } else {
                    JavaException javaException = fault.getJavaException();
                    String localName = null;
                    if (type instanceof SOAPType) {
                        localName = ((SOAPType)javaException.getOwner()).getName().getLocalPart();
                    } else if (type instanceof LiteralType) {
                        localName = ((LiteralType)javaException.getOwner()).getName().getLocalPart();
                    } else {
                        throw new GeneratorException("generator.unsupported.type.encountered", new Object[]{type.getName().getLocalPart(), type.getName().getNamespaceURI()});
                    }
                    complexType.addAttribute("name", localName);
                }
                SchemaElement sequenceParent = complexType;
                if (parentType != null) {
                    SchemaElement complexContent = new SchemaElement(SchemaConstants.QNAME_COMPLEX_CONTENT);
                    complexType.addChild(complexContent);
                    SchemaElement extension = new SchemaElement(SchemaConstants.QNAME_EXTENSION);
                    complexContent.addChild(extension);
                    if (parentType instanceof SOAPStructureType) {
                        extension.addAttribute("base", parentType.getName());
                    } else {
                        JavaException javaException = parentFault.getJavaException();
                        QName ownerName = ((AbstractType)javaException.getOwner()).getName();
                        extension.addAttribute("base", ownerName);
                    }
                    sequenceParent = extension;
                }
                SchemaElement sequence = new SchemaElement(SchemaConstants.QNAME_SEQUENCE);
                sequenceParent.addChild(sequence);
                if (type instanceof SOAPStructureType) {
                    iter2 = ((SOAPStructureType)type).getMembers();
                    while (iter2.hasNext()) {
                        member2 = (SOAPStructureMember)iter2.next();
                        if (((SOAPStructureMember)member2).isInherited() && parentFault != null) continue;
                        this.addChildElement(sequence, ((SOAPStructureMember)member2).getName(), ((SOAPStructureMember)member2).getType(), VersionUtil.isVersion11(this.options.getProperty("sourceVersion")));
                    }
                    schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                } else if (type instanceof LiteralStructuredType) {
                    iter2 = ((LiteralStructuredType)type).getElementMembers();
                    while (iter2.hasNext()) {
                        member2 = (LiteralElementMember)iter2.next();
                        if (((LiteralElementMember)member2).isInherited() && parentFault != null) continue;
                        this.addChildElement(sequence, ((LiteralElementMember)member2).getName(), ((LiteralElementMember)member2).getType(), ((LiteralElementMember)member2).isNillable());
                    }
                    schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, type.getName());
                } else {
                    Object member3;
                    Iterator iter3;
                    JavaException javaException = fault.getJavaException();
                    AbstractType ownerType = (AbstractType)javaException.getOwner();
                    if (ownerType instanceof SOAPType) {
                        SOAPStructureType soapStruct = (SOAPStructureType)ownerType;
                        iter3 = soapStruct.getMembers();
                        member3 = (SOAPStructureMember)iter3.next();
                        if (!((SOAPStructureMember)member3).isInherited() || fault.getParentFault() == null) {
                            this.addChildElement(sequence, ((SOAPStructureMember)member3).getName(), ((SOAPStructureMember)member3).getType(), this.model.getSource().equals("1.1"));
                        }
                    } else {
                        LiteralSequenceType literalStruct = (LiteralSequenceType)ownerType;
                        iter3 = literalStruct.getElementMembers();
                        member3 = (LiteralElementMember)iter3.next();
                        if (fault.getParentFault() == null) {
                            this.addChildElement(sequence, ((LiteralElementMember)member3).getName(), ((LiteralElementMember)member3).getType(), ((LiteralElementMember)member3).isNillable());
                        }
                    }
                    schema.defineEntity(complexType, SchemaKinds.XSD_TYPE, ownerType.getName());
                }
                if (parentType != null) {
                    this.processFault(parentFault);
                }
                Iterator subFaults = fault.getSortedSubfaults();
                while (subFaults.hasNext()) {
                    Fault subFault = (Fault)subFaults.next();
                    this.processFault(subFault);
                }
                if (!(type instanceof SOAPStructureType)) break block27;
                iter = ((SOAPStructureType)type).getMembers();
                while (iter.hasNext()) {
                    member = (SOAPStructureMember)iter.next();
                    this.processType(((SOAPStructureMember)member).getType());
                }
                subtypes = ((SOAPStructureType)type).getSubtypes();
                if (subtypes == null) break block28;
                while (subtypes.hasNext()) {
                    this.processType((AbstractType)subtypes.next());
                }
                break block28;
            }
            if (type instanceof LiteralStructuredType) {
                iter = ((LiteralStructuredType)type).getElementMembers();
                while (iter.hasNext()) {
                    member = (LiteralElementMember)iter.next();
                    this.processType(((LiteralElementMember)member).getType());
                }
                subtypes = ((LiteralStructuredType)type).getSubtypes();
                if (subtypes != null) {
                    while (subtypes.hasNext()) {
                        this.processType((AbstractType)subtypes.next());
                    }
                }
            }
        }
    }

    private void addChildElement(SchemaElement sequence, QName name, AbstractType type, boolean isNillable) {
        SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
        sequence.addChild(element);
        element.addAttribute("name", name.getLocalPart());
        element.addAttribute("type", type.getName());
        if (isNillable) {
            element.addAttribute("nillable", "true");
        }
    }

    private void processElement(QName name, LiteralType type) throws Exception {
        if (this.generatedElements.contains(name)) {
            return;
        }
        if (name.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || name.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/") || name.getNamespaceURI().equals("http://www.w3.org/2002/06/soap-encoding")) {
            return;
        }
        ImportedDocumentInfo docInfo = this.model.getImportedDocument(name.getNamespaceURI());
        if (docInfo != null && docInfo.getType() == 1) {
            this.actuallyImportedDocuments.add(docInfo);
            return;
        }
        Schema schema = (Schema)this.nsSchemaMap.get(name.getNamespaceURI());
        if (schema == null) {
            schema = new Schema(this.document);
            schema.setTargetNamespaceURI(name.getNamespaceURI());
            SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
            schemaElement.addAttribute("targetNamespace", schema.getTargetNamespaceURI());
            schemaElement.addPrefix("", "http://www.w3.org/2001/XMLSchema");
            schemaElement.addPrefix("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            schemaElement.addPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            schemaElement.addPrefix(this.getNamespacePrefix(type), this.getSOAPEncodingNamespace(type));
            schemaElement.addPrefix("tns", schema.getTargetNamespaceURI());
            schema.setContent(schemaElement);
            this.nsSchemaMap.put(name.getNamespaceURI(), schema);
        }
        this.generatedElements.add(name);
        SchemaElement element = new SchemaElement(SchemaConstants.QNAME_ELEMENT);
        schema.getContent().addChild(element);
        element.addAttribute("name", name.getLocalPart());
        element.addAttribute("type", type.getName());
    }
}

