/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.util;

import com.nec.webotx.webservice.xml.rpc.processor.ProcessorAction;
import com.nec.webotx.webservice.xml.rpc.processor.config.Configuration;
import com.nec.webotx.webservice.xml.rpc.processor.model.AbstractType;
import com.nec.webotx.webservice.xml.rpc.processor.model.Block;
import com.nec.webotx.webservice.xml.rpc.processor.model.ExtendedModelVisitor;
import com.nec.webotx.webservice.xml.rpc.processor.model.Fault;
import com.nec.webotx.webservice.xml.rpc.processor.model.Model;
import com.nec.webotx.webservice.xml.rpc.processor.model.Operation;
import com.nec.webotx.webservice.xml.rpc.processor.model.Parameter;
import com.nec.webotx.webservice.xml.rpc.processor.model.Port;
import com.nec.webotx.webservice.xml.rpc.processor.model.Request;
import com.nec.webotx.webservice.xml.rpc.processor.model.Response;
import com.nec.webotx.webservice.xml.rpc.processor.model.Service;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralAllType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralArrayType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralElementMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralIDType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralListType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralWildcardMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPAnyType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPArrayType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPCustomType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPListType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.util.ComponentWriter;
import com.nec.webotx.webservice.xml.rpc.processor.util.IndentingWriter;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class ModelWriter
extends ExtendedModelVisitor
implements ProcessorAction,
SOAPTypeVisitor,
LiteralTypeVisitor {
    private IndentingWriter _writer;
    private ComponentWriter _componentWriter;
    private String _currentNamespaceURI;
    private Set _visitedComplexTypes;
    private static final boolean writeComponentInformation = false;

    public ModelWriter(IndentingWriter w) {
        this._writer = w;
        this._componentWriter = new ComponentWriter(this._writer);
    }

    public ModelWriter(OutputStream out) {
        this(new IndentingWriter(new OutputStreamWriter(out), 2));
    }

    public ModelWriter(File f) throws FileNotFoundException {
        this(new FileOutputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Model model) {
        try {
            this._visitedComplexTypes = new HashSet();
            this.visit(model);
            this._writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._visitedComplexTypes = null;
            this._currentNamespaceURI = null;
        }
    }

    public void perform(Model model, Configuration config, Properties options) {
        this.write(model);
    }

    protected void preVisit(Model model) throws Exception {
        this._writer.p("MODEL ");
        this.writeQName(model.getName());
        this._writer.pln();
        this._writer.pI();
        this._currentNamespaceURI = model.getTargetNamespaceURI();
        if (this._currentNamespaceURI != null) {
            this._writer.p("TARGET-NAMESPACE ");
            this._writer.pln(this._currentNamespaceURI);
        }
    }

    protected void postVisit(Model model) throws Exception {
        this.processTypes(model);
        this._writer.pO();
    }

    protected void processTypes(Model model) throws Exception {
        Iterator iter = model.getExtraTypes();
        while (iter.hasNext()) {
            AbstractType extraType = (AbstractType)iter.next();
            if (extraType.isLiteralType()) {
                this.describe((LiteralType)extraType);
                continue;
            }
            if (!extraType.isSOAPType()) continue;
            this.describe((SOAPType)extraType);
        }
    }

    protected void preVisit(Service service) throws Exception {
        this._writer.p("SERVICE ");
        this.writeQName(service.getName());
        this._writer.p(" INTERFACE ");
        this._writer.p(service.getJavaInterface().getName());
        this._writer.pln();
        this._writer.pI();
        this._currentNamespaceURI = service.getName().getNamespaceURI();
    }

    protected void postVisit(Service service) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Port port) throws Exception {
        this._writer.p("PORT ");
        this.writeQName(port.getName());
        this._writer.p(" INTERFACE ");
        this._writer.p(port.getJavaInterface().getName());
        this._writer.pln();
        this._writer.pI();
        this._currentNamespaceURI = port.getName().getNamespaceURI();
    }

    protected void postVisit(Port port) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Operation operation) throws Exception {
        this._writer.p("OPERATION ");
        this.writeQName(operation.getName());
        if (operation.isOverloaded()) {
            this._writer.p(" (OVERLOADED)");
        }
        if (operation.getStyle() != null) {
            if (operation.getStyle().equals(SOAPStyle.RPC)) {
                this._writer.p(" (RPC)");
            } else if (operation.getStyle().equals(SOAPStyle.DOCUMENT)) {
                this._writer.p(" (DOCUMENT)");
            }
        }
        this._writer.pln();
        this._writer.pI();
    }

    protected void postVisit(Operation operation) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Request request) throws Exception {
        this._writer.plnI("REQUEST");
    }

    protected void postVisit(Request request) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Response response) throws Exception {
        this._writer.plnI("RESPONSE");
    }

    protected void postVisit(Response response) throws Exception {
        this._writer.pO();
    }

    protected void preVisit(Fault fault) throws Exception {
        this._writer.p("FAULT ");
        this._writer.p(fault.getName());
        this._writer.pln();
        this._writer.pI();
    }

    protected void postVisit(Fault fault) throws Exception {
        this._writer.pO();
    }

    protected void visitBodyBlock(Block block) throws Exception {
        this._writer.p("BODY-BLOCK ");
        this.writeQName(block.getName());
        this._writer.p(" TYPE ");
        this.writeQName(block.getType().getName());
        if (block.getType().isLiteralType()) {
            this._writer.pln(" (LITERAL)");
            this.describe((LiteralType)block.getType());
        } else if (block.getType().isSOAPType()) {
            this._writer.pln(" (ENCODED)");
            this.describe((SOAPType)block.getType());
        }
    }

    protected void visitHeaderBlock(Block block) throws Exception {
        this._writer.p("HEADER-BLOCK ");
        this.writeQName(block.getName());
        this._writer.p(" TYPE ");
        this.writeQName(block.getType().getName());
        if (block.getType().isLiteralType()) {
            this._writer.pln(" (LITERAL)");
            this.describe((LiteralType)block.getType());
        } else if (block.getType().isSOAPType()) {
            this._writer.pln(" (ENCODED)");
            this.describe((SOAPType)block.getType());
        }
    }

    protected void visitFaultBlock(Block block) throws Exception {
        this._writer.p("FAULT-BLOCK ");
        this.writeQName(block.getName());
        this._writer.p(" TYPE ");
        this.writeQName(block.getType().getName());
        if (block.getType().isLiteralType()) {
            this._writer.pln(" (LITERAL)");
            this.describe((LiteralType)block.getType());
        } else if (block.getType().isSOAPType()) {
            this._writer.pln(" (ENCODED)");
            this.describe((SOAPType)block.getType());
        }
    }

    protected void visit(Parameter parameter) throws Exception {
        this._writer.p("PARAMETER ");
        this._writer.p(parameter.getName());
        this._writer.p(" TYPE ");
        this.writeQName(parameter.getType().getName());
        if (parameter.isEmbedded()) {
            this._writer.p(" (EMBEDDED)");
        }
        if (parameter.getType().isLiteralType()) {
            this._writer.pln(" (LITERAL)");
            this.describe((LiteralType)parameter.getType());
        } else if (parameter.getType().isSOAPType()) {
            this._writer.pln(" (ENCODED)");
            this.describe((SOAPType)parameter.getType());
        }
    }

    protected void describe(LiteralType type) throws Exception {
        this._writer.pI();
        type.accept(this);
        this._writer.pO();
    }

    public void visit(LiteralEnumerationType type) throws Exception {
        this._writer.p("LITERAL-ENUMERATION-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
        this.describe(type.getBaseType());
    }

    public void visit(LiteralSimpleType type) throws Exception {
        this._writer.p("LITERAL-SIMPLE-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
    }

    public void visit(LiteralIDType type) throws Exception {
        this._writer.p("LITERAL-SIMPLE-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.p(" resloveIDREF " + new Boolean(type.getResolveIDREF()).toString());
        this._writer.pln();
    }

    public void visit(LiteralSequenceType type) throws Exception {
        this.visitLiteralStructuredType(type, "LITERAL-SEQUENCE-TYPE ", true);
    }

    public void visit(LiteralAllType type) throws Exception {
        this.visitLiteralStructuredType(type, "LITERAL-ALL-TYPE ", true);
    }

    private void visitLiteralStructuredType(LiteralStructuredType type, String header, boolean detailed) throws Exception {
        boolean alreadySeen = this._visitedComplexTypes.contains(type);
        this._writer.p(header);
        this.writeQName(type.getName());
        if (alreadySeen) {
            this._writer.p(" (REF)");
        } else {
            this._visitedComplexTypes.add(type);
        }
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
        if (alreadySeen) {
            return;
        }
        if (detailed) {
            this._writer.pI();
            this.processContentMember(type);
            this.processAttributeMembers(type);
            this.processElementMembers(type);
            this._writer.pO();
        }
    }

    protected void processContentMember(LiteralStructuredType type) throws Exception {
        if (type.getContentMember() != null) {
            this._writer.p("CONTENT");
            this._writer.pln();
            this.describe(type.getContentMember().getType());
        }
    }

    protected void processAttributeMembers(LiteralStructuredType type) throws Exception {
        Iterator iter = type.getAttributeMembers();
        while (iter.hasNext()) {
            LiteralAttributeMember attribute = (LiteralAttributeMember)iter.next();
            this.writeAttributeMember(attribute);
        }
    }

    protected void writeAttributeMember(LiteralAttributeMember attribute) throws Exception {
        this._writer.p("ATTRIBUTE ");
        this._writer.p(attribute.getName().getLocalPart());
        if (attribute.isRequired()) {
            this._writer.p(" (REQUIRED)");
        }
        this._writer.pln();
        this.describe(attribute.getType());
    }

    protected void processElementMembers(LiteralStructuredType type) throws Exception {
        Iterator iter = type.getElementMembers();
        while (iter.hasNext()) {
            LiteralElementMember member = (LiteralElementMember)iter.next();
            if (member.isWildcard()) {
                this.writeWildcardMember((LiteralWildcardMember)member);
                continue;
            }
            this.writeElementMember(member);
        }
    }

    protected void writeElementMember(LiteralElementMember element) throws Exception {
        this._writer.p("ELEMENT ");
        this._writer.p(element.getName().getLocalPart());
        if (element.isNillable()) {
            this._writer.p(" (NILLABLE)");
        }
        if (element.isRequired()) {
            this._writer.p(" (REQUIRED)");
        }
        if (element.isRepeated()) {
            this._writer.p(" (REPEATED)");
        }
        this._writer.pln();
        this.describe(element.getType());
    }

    protected void writeWildcardMember(LiteralWildcardMember wildcard) throws Exception {
        this._writer.p("WILDCARD (ANY)");
        if (wildcard.getExcludedNamespaceName() != null) {
            this._writer.p(" (OTHER) ");
            this._writer.p(wildcard.getExcludedNamespaceName());
        }
        if (wildcard.isNillable()) {
            this._writer.p(" (NILLABLE)");
        }
        if (wildcard.isRequired()) {
            this._writer.p(" (REQUIRED)");
        }
        if (wildcard.isRepeated()) {
            this._writer.p(" (REPEATED)");
        }
        this._writer.pln();
        this.describe(wildcard.getType());
    }

    public void visit(LiteralArrayType type) throws Exception {
        this._writer.p("LITERAL-ARRAY-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
        this.describe(type.getElementType());
    }

    public void visit(LiteralArrayWrapperType type) throws Exception {
        this._writer.p("LITERAL-ARRAY-WRAPPER-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.p("ELEMENT-MEMBER ");
        this.writeQName(type.getElementMember().getName());
        this._writer.p(": TYPE: ");
        this.writeQName(type.getElementMember().getType().getName());
        this._writer.pln();
        this.describe(type.getElementMember().getType());
    }

    public void visit(LiteralListType type) throws Exception {
        this._writer.p("LITERAL-LIST-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
        this.describe(type.getItemType());
    }

    public void visit(SOAPListType type) throws Exception {
        this._writer.p("SOAP-LIST-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
        this.describe(type.getItemType());
    }

    public void visit(LiteralFragmentType type) throws Exception {
        this._writer.p("LITERAL-FRAGMENT-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
    }

    protected void describe(SOAPType type) throws Exception {
        this._writer.pI();
        type.accept(this);
        this._writer.pO();
    }

    public void visit(SOAPArrayType type) throws Exception {
        this._writer.p("SOAP-ARRAY-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" RANK ");
        this._writer.p(Integer.toString(type.getRank()));
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
        this.describe(type.getElementType());
    }

    public void visit(SOAPCustomType type) throws Exception {
        this._writer.p("SOAP-CUSTOM-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
        this._writer.pI();
        this._writer.pO();
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        this._writer.p("SOAP-ENUMERATION-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
        this.describe(type.getBaseType());
    }

    public void visit(SOAPSimpleType type) throws Exception {
        this._writer.p("SOAP-SIMPLE-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
    }

    public void visit(SOAPAnyType type) throws Exception {
        this._writer.p("SOAP-ANY-TYPE ");
        this.writeQName(type.getName());
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
    }

    public void visit(SOAPOrderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type, "SOAP-ORDERED-STRUCTURE-TYPE", true);
    }

    public void visit(SOAPUnorderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type, "SOAP-UNORDERED-STRUCTURE-TYPE", true);
    }

    public void visit(RPCRequestOrderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type, "RPC-REQUEST-ORDERED-STRUCTURE-TYPE", false);
    }

    public void visit(RPCRequestUnorderedStructureType type) throws Exception {
        this.visitSOAPStructureType(type, "RPC-REQUEST-UNORDERED-STRUCTURE-TYPE", false);
    }

    public void visit(RPCResponseStructureType type) throws Exception {
        this.visitSOAPStructureType(type, "RPC-RESPONSE-STRUCTURE-TYPE", false);
    }

    private void visitSOAPStructureType(SOAPStructureType type, String header, boolean detailed) throws Exception {
        boolean alreadySeen = this._visitedComplexTypes.contains(type);
        this._writer.p(header);
        this._writer.p(" ");
        this.writeQName(type.getName());
        if (alreadySeen) {
            this._writer.p(" (REF)");
        } else {
            this._visitedComplexTypes.add(type);
        }
        this._writer.p(" JAVA-TYPE ");
        this._writer.p(type.getJavaType().getName());
        this._writer.pln();
        if (alreadySeen) {
            return;
        }
        if (detailed) {
            this._writer.pI();
            if (type.getParentType() != null) {
                this._writer.pln("PARENT TYPE");
                this._writer.pI();
                this.describe(type.getParentType());
                this._writer.pO();
            }
            this.processMembers(type);
            this._writer.pO();
        }
    }

    protected void processMembers(SOAPStructureType type) throws Exception {
        Iterator iter = type.getMembers();
        while (iter.hasNext()) {
            SOAPStructureMember member = (SOAPStructureMember)iter.next();
            this.writeMember(member);
        }
    }

    protected void writeMember(SOAPStructureMember member) throws Exception {
        this._writer.p("MEMBER ");
        if (member.isInherited()) {
            this._writer.p("(INHERITED) ");
        }
        this._writer.p(member.getName().getLocalPart());
        this._writer.pln();
        this.describe(member.getType());
    }

    protected void writeQName(QName name) throws IOException {
        if (name == null) {
            this._writer.p("null");
        } else {
            String nsURI = name.getNamespaceURI();
            if (!nsURI.equals(this._currentNamespaceURI) && nsURI.length() > 0) {
                if (nsURI.equals("http://schemas.xmlsoap.org/wsdl/")) {
                    this._writer.p("{wsdl}");
                } else if (nsURI.equals("http://www.w3.org/2001/XMLSchema")) {
                    this._writer.p("{xsd}");
                } else {
                    this._writer.p("{");
                    this._writer.p(nsURI);
                    this._writer.p("}");
                }
            }
            this._writer.p(name.getLocalPart());
        }
    }
}

