/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.streaming;

import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReaderException;
import com.nec.webotx.webservice.xml.rpc.util.xml.XmlUtil;
import javax.xml.namespace.QName;

public class XMLReaderUtil {
    private XMLReaderUtil() {
    }

    public static QName getQNameValue(XMLReader reader, QName attributeName) {
        String attribute = reader.getAttributes().getValue(attributeName);
        return attribute == null ? null : XMLReaderUtil.decodeQName(reader, attribute);
    }

    public static QName decodeQName(XMLReader reader, String rawName) {
        String prefix = XmlUtil.getPrefix(rawName);
        String local = XmlUtil.getLocalPart(rawName);
        String uri = prefix == null ? null : reader.getURI(prefix);
        return new QName(uri, local);
    }

    public static void verifyReaderState(XMLReader reader, int expectedState) {
        if (reader.getState() != expectedState) {
            throw new XMLReaderException("xmlreader.unexpectedState", new Object[]{XMLReaderUtil.getStateName(expectedState), XMLReaderUtil.getLongStateName(reader)});
        }
    }

    public static String getStateName(XMLReader reader) {
        return XMLReaderUtil.getStateName(reader.getState());
    }

    public static String getLongStateName(XMLReader reader) {
        int state = reader.getState();
        String name = XMLReaderUtil.getStateName(state);
        if (state == 1 || state == 1) {
            name = name + ": " + reader.getName();
        }
        return name;
    }

    public static String getStateName(int state) {
        switch (state) {
            case 0: {
                return "BOF";
            }
            case 1: {
                return "START";
            }
            case 2: {
                return "END";
            }
            case 3: {
                return "CHARS";
            }
            case 4: {
                return "PI";
            }
            case 5: {
                return "EOF";
            }
        }
        return "UNKNOWN";
    }
}

