/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.client.dii;

import com.nec.webotx.webservice.xml.rpc.client.BasicService;
import com.nec.webotx.webservice.xml.rpc.client.ServiceExceptionImpl;
import com.nec.webotx.webservice.xml.rpc.client.dii.ConfiguredCall;
import com.nec.webotx.webservice.xml.rpc.client.dii.DynamicProxyBuilder;
import com.nec.webotx.webservice.xml.rpc.client.dii.OperationInfo;
import com.nec.webotx.webservice.xml.rpc.client.dii.PortInfo;
import com.nec.webotx.webservice.xml.rpc.client.dii.ServiceInfo;
import com.nec.webotx.webservice.xml.rpc.client.dii.ServiceInfoBuilder;
import com.nec.webotx.webservice.xml.rpc.processor.modeler.ModelerException;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPConstantsFactory;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPEncodingConstants;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;
import com.nec.webotx.webservice.xml.rpc.util.Holders;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMapping;

public class ConfiguredService
extends BasicService {
    protected URL wsdlDocumentLocation;
    protected ServiceInfo configuration;
    protected DynamicProxyBuilder dynamicProxyBuilder;
    private ServiceException serviceException;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public ConfiguredService(QName name, URL wsdlLocation) {
        this(name, wsdlLocation, SOAPVersion.SOAP_11);
    }

    public ConfiguredService(QName name, URL wsdlLocation, SOAPVersion ver) {
        super(name);
        this.init(ver);
        this.wsdlDocumentLocation = wsdlLocation;
        ServiceInfoBuilder configurationBuilder = new ServiceInfoBuilder(wsdlLocation.toExternalForm(), name);
        try {
            this.configuration = configurationBuilder.buildServiceInfo();
        }
        catch (ModelerException ex) {
            this.serviceException = new ServiceException((Throwable)((Object)ex));
        }
        catch (ServiceException ex) {
            this.serviceException = ex;
        }
        if (this.configuration == null) {
            return;
        }
        this.dynamicProxyBuilder = this.createDynamicProxyBuilder();
        Iterator eachPortName = this.configuration.getPortNames();
        while (eachPortName.hasNext()) {
            QName currentPortName = (QName)eachPortName.next();
            this.addPort(currentPortName);
        }
    }

    public ServiceException getServiceException() {
        return this.serviceException;
    }

    protected DynamicProxyBuilder createDynamicProxyBuilder() {
        return new DynamicProxyBuilder(this.internalTypeRegistry, this.getHandlerRegistry(), this.configuration);
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlDocumentLocation;
    }

    public Call[] getCalls(QName portName) throws ServiceException {
        ArrayList<Call> calls = new ArrayList<Call>();
        PortInfo portInfo = this.getPortInfo(portName);
        Iterator eachOperation = portInfo.getOperations();
        while (eachOperation.hasNext()) {
            OperationInfo currentOperation = (OperationInfo)eachOperation.next();
            calls.add(this.createCall(portName, currentOperation.getName()));
        }
        return calls.toArray(new Call[calls.size()]);
    }

    public Call createCall(QName portName, String operationName) throws ServiceException {
        return this.createCall(portName, new QName(operationName));
    }

    public Call createCall(QName portName, QName operationName) throws ServiceException {
        ConfiguredCall call = new ConfiguredCall(this.internalTypeRegistry, this.getHandlerRegistry(), this.configuration);
        call.setPortName(portName);
        call.setOperationName(operationName);
        return call;
    }

    protected PortInfo getPortInfo(QName portName) throws ServiceException {
        if (!this.ports.contains(portName)) {
            throw this.portNotFoundException(portName);
        }
        return this.configuration.getPortInfo(portName);
    }

    protected ServiceExceptionImpl portNotFoundException(QName portName) {
        return new ServiceExceptionImpl("dii.service.does.not.contain.port", new Object[]{this.name, portName});
    }

    public Iterator getPorts() {
        return this.ports.iterator();
    }

    public Remote getPort(Class portInterface) throws ServiceException {
        QName portName = this.getPortNameForInterface(portInterface);
        return this.getPort(portName, portInterface);
    }

    protected QName getPortNameForInterface(Class portInterface) {
        TypeMapping mapping = this.typeRegistry.getTypeMapping(this.soapEncodingConstants.getSOAPEncodingNamespace());
        Iterator eachPortInfo = this.configuration.getPortNames();
        while (eachPortInfo.hasNext()) {
            QName currentPortName = (QName)eachPortInfo.next();
            PortInfo currentPort = this.configuration.getPortInfo(currentPortName);
            Method[] methods = portInterface.getMethods();
            if (currentPort.getOperationCount() != methods.length) continue;
            boolean allMethodsMatched = true;
            for (int i = 0; i < methods.length; ++i) {
                Iterator eachOperation = currentPort.getOperations();
                boolean operationMatchesMethod = false;
                while (eachOperation.hasNext()) {
                    OperationInfo currentOperation = (OperationInfo)eachOperation.next();
                    if (!currentOperation.getName().getLocalPart().equals(methods[i].getName())) continue;
                    Class<?>[] parameters = methods[i].getParameterTypes();
                    if (currentOperation.getParameterCount() != parameters.length) continue;
                    boolean parametersMatched = true;
                    for (int j = 0; j < parameters.length; ++j) {
                        parametersMatched = false;
                        QName[] operationParameters = currentOperation.getParameterXmlTypes();
                        for (int k = 0; k < operationParameters.length; ++k) {
                            Class methodParameter = Holders.stripHolderClass(parameters[j]);
                            if (mapping.getSerializer(methodParameter, operationParameters[k]) == null) continue;
                            parametersMatched = true;
                            break;
                        }
                        if (!parametersMatched) break;
                    }
                    if (!parametersMatched) continue;
                    operationMatchesMethod = true;
                }
                if (operationMatchesMethod) continue;
                allMethodsMatched = false;
                break;
            }
            if (!allMethodsMatched) continue;
            return currentPortName;
        }
        return null;
    }

    public Remote getPort(QName portName, Class portInterface) throws ServiceException {
        return this.dynamicProxyBuilder.buildDynamicProxyFor(this.getPortInfo(portName), portInterface);
    }
}

