/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding;

import com.nec.webotx.webservice.xml.rpc.encoding.ArraySerializerHelper;
import com.nec.webotx.webservice.xml.rpc.encoding.DeserializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAP11ArraySerializerHelper;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAP12ArraySerializerHelper;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPSerializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerBase;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerCallback;
import com.nec.webotx.webservice.xml.rpc.encoding.xsd.XSDConstants;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPConstantsFactory;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPEncodingConstants;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;
import com.nec.webotx.webservice.xml.rpc.streaming.Attributes;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReaderUtil;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriterUtil;
import com.nec.webotx.webservice.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaConstants;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.xml.namespace.QName;

public abstract class ArraySerializerBase
extends SerializerBase {
    protected QName elemName;
    protected QName elemType;
    protected Class elemClass;
    protected int rank = -1;
    protected int[] dims;
    protected int[] null_dims;
    protected ArraySerializerHelper helper;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.helper = ver.toString().equals(SOAPVersion.SOAP_12.toString()) ? new SOAP12ArraySerializerHelper() : new SOAP11ArraySerializerHelper();
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    protected ArraySerializerBase(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName elemName, QName elemType, Class elemClass, int rank, int[] dims) {
        this(type, encodeType, isNullable, encodingStyle, elemName, elemType, elemClass, rank, dims, SOAPVersion.SOAP_11);
    }

    protected ArraySerializerBase(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName elemName, QName elemType, Class elemClass, int rank, int[] dims, SOAPVersion ver) {
        super(type, encodeType, isNullable, encodingStyle);
        this.init(ver);
        if (elemType == null) {
            throw new IllegalArgumentException();
        }
        this.elemName = elemName;
        this.elemType = elemType;
        this.elemClass = elemClass;
        this.rank = rank;
        this.dims = dims;
        this.null_dims = dims != null ? dims : (rank >= 0 ? new int[rank] : new int[0]);
    }

    public void serialize(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        boolean pushedEncodingStyle = false;
        try {
            if (obj == null) {
                if (!this.isNullable) {
                    throw new SerializationException("soap.unexpectedNull");
                }
                this.serializeNull(name, writer, context);
            } else {
                writer.startElement(name != null ? name : this.type);
                if (callback != null) {
                    callback.onStartTag(obj, name, writer, context);
                }
                pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
                if (this.encodeType) {
                    String attrVal = XMLWriterUtil.encodeQName(writer, this.soapEncodingConstants.getQNameEncodingArray());
                    writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
                }
                int[] dims = this.dims != null ? this.dims : this.getArrayDimensions(obj);
                String encodedDims = this.helper.encodeArrayDimensions(dims);
                this.helper.serializeArray(this.elemType, encodedDims, writer);
                this.serializeArrayInstance(obj, dims, writer, context);
                writer.endElement();
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException(e);
        }
        catch (Exception e) {
            throw new SerializationException(new LocalizableExceptionAdapter(e));
        }
        finally {
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
    }

    protected void serializeNull(QName name, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        boolean pushedEncodingStyle = false;
        writer.startElement(name != null ? name : this.type);
        pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
        if (this.encodeType) {
            String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
        }
        String encodedDims = this.helper.encodeArrayDimensions(this.null_dims);
        this.helper.serializeArray(this.elemType, encodedDims, writer);
        writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        writer.endElement();
        if (pushedEncodingStyle) {
            context.popEncodingStyle();
        }
    }

    protected abstract void serializeArrayInstance(Object var1, int[] var2, XMLWriter var3, SOAPSerializationContext var4) throws Exception;

    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        boolean pushedEncodingStyle = false;
        try {
            boolean isNull;
            pushedEncodingStyle = context.processEncodingStyle(reader);
            context.verifyEncodingStyle(this.encodingStyle);
            if (name != null) {
                this.verifyName(reader, name);
            }
            if (!(isNull = ArraySerializerBase.getNullStatus(reader))) {
                QName actualType = ArraySerializerBase.getType(reader);
                if (actualType != null && !actualType.equals(this.type) && !actualType.equals(this.soapEncodingConstants.getQNameEncodingArray())) {
                    throw new DeserializationException("soap.unexpectedElementType", new Object[]{this.type.toString(), actualType.toString()});
                }
                int[] dims = this.verifyArrayType(reader);
                Object rslt = this.deserializeArrayInstance(reader, context, dims);
                XMLReaderUtil.verifyReaderState(reader, 2);
                Object object = rslt;
                return object;
            }
            if (!this.isNullable) {
                throw new DeserializationException("soap.unexpectedNull");
            }
            this.skipEmptyContent(reader);
            Object var6_10 = null;
            return var6_10;
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
        finally {
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
    }

    protected abstract Object deserializeArrayInstance(XMLReader var1, SOAPDeserializationContext var2, int[] var3) throws Exception;

    public static boolean isEmptyDimensions(int[] dims) {
        return dims.length == 0;
    }

    public static int[] getArrayElementPosition(XMLReader reader, int[] dims) throws Exception {
        return ArraySerializerBase.getArrayElementPosition(reader, dims, SOAPVersion.SOAP_11);
    }

    public static int[] getArrayElementPosition(XMLReader reader, int[] dims, SOAPVersion ver) throws Exception {
        int[] elemPos = null;
        String attrVal = null;
        Attributes attrs = reader.getAttributes();
        if (ver == SOAPVersion.SOAP_11) {
            attrVal = attrs.getValue("http://schemas.xmlsoap.org/soap/encoding/", "position");
        } else if (ver == SOAPVersion.SOAP_12) {
            attrVal = attrs.getValue("http://www.w3.org/2002/06/soap-encoding", "position");
        }
        if (attrVal != null) {
            elemPos = ArraySerializerBase.decodeArrayDimensions(attrVal);
            if (ArraySerializerBase.isEmptyDimensions(dims) && elemPos.length != 1 || !ArraySerializerBase.isEmptyDimensions(dims) && elemPos.length != dims.length) {
                throw new DeserializationException("soap.illegalArrayElementPosition", attrVal);
            }
        }
        return elemPos;
    }

    public static int[] getArrayOffset(XMLReader reader, int[] dims) throws Exception {
        return ArraySerializerBase.getArrayOffset(reader, dims, SOAPVersion.SOAP_11);
    }

    public static int[] getArrayOffset(XMLReader reader, int[] dims, SOAPVersion ver) throws Exception {
        int[] offset = null;
        String attrVal = null;
        Attributes attrs = reader.getAttributes();
        if (ver == SOAPVersion.SOAP_11) {
            attrVal = attrs.getValue("http://schemas.xmlsoap.org/soap/encoding/", "offset");
        } else if (ver == SOAPVersion.SOAP_12) {
            attrVal = attrs.getValue("http://www.w3.org/2002/06/soap-encoding", "offset");
        }
        if (attrVal != null) {
            offset = ArraySerializerBase.decodeArrayDimensions(attrVal);
            if (ArraySerializerBase.isEmptyDimensions(dims) && offset.length != 1 || !ArraySerializerBase.isEmptyDimensions(dims) && offset.length != dims.length) {
                throw new DeserializationException("soap.illegalArrayOffset", attrVal);
            }
        }
        return offset;
    }

    protected int[] verifyArrayType(XMLReader reader) throws Exception {
        String arrayType = null;
        Attributes attrs = reader.getAttributes();
        arrayType = this.helper.getArrayType(attrs);
        if (arrayType == null) {
            throw new DeserializationException("soap.malformedArrayType", "<arrayType attribute missing>");
        }
        this.verifyArrayElementType(arrayType, reader);
        return this.verifyArrayDimensions(arrayType, reader);
    }

    protected void verifyArrayElementType(String arrayType, XMLReader reader) throws Exception {
        QName actualElemType = ArraySerializerBase.getArrayElementType(arrayType, reader);
        if (!actualElemType.equals(this.elemType) && !actualElemType.equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
            throw new DeserializationException("soap.unexpectedArrayElementType", new Object[]{this.elemType.toString(), actualElemType.toString()});
        }
    }

    public static QName getArrayElementType(String arrayType, XMLReader reader) throws Exception {
        QName elemType = null;
        boolean malformed = true;
        String elemTypeStr = arrayType;
        int idx = arrayType.indexOf(91);
        if (idx >= 0) {
            elemTypeStr = arrayType.substring(0, idx).trim();
        }
        if (elemTypeStr.length() > 0) {
            elemType = XMLReaderUtil.decodeQName(reader, elemTypeStr);
            malformed = false;
        }
        if (malformed) {
            throw new DeserializationException("soap.malformedArrayType", arrayType);
        }
        return elemType;
    }

    protected int[] verifyArrayDimensions(String arrayType, XMLReader reader) throws Exception {
        int[] actualDims = ArraySerializerBase.getArrayDimensions(arrayType, reader);
        if (this.rank >= 0 && (ArraySerializerBase.isEmptyDimensions(actualDims) && this.rank != 1 || !ArraySerializerBase.isEmptyDimensions(actualDims) && actualDims.length != this.rank)) {
            throw new DeserializationException("soap.unexpectedArrayRank", new Object[]{Integer.toString(this.rank), Integer.toString(actualDims.length), arrayType});
        }
        if (this.dims != null && actualDims.length > 0 && !Arrays.equals(this.dims, actualDims)) {
            throw new DeserializationException("soap.unexpectedArrayDimensions", new Object[]{this.helper.encodeArrayDimensions(this.dims), this.helper.encodeArrayDimensions(actualDims), arrayType});
        }
        return actualDims;
    }

    public static int[] getArrayDimensions(String arrayType, XMLReader reader) throws Exception {
        Attributes attrs;
        boolean isSOAP12 = false;
        String dimStr = null;
        int startIdx = arrayType.lastIndexOf(91);
        int endIdx = arrayType.lastIndexOf(93);
        if (startIdx < 0 || endIdx < 0) {
            isSOAP12 = true;
        } else {
            if (startIdx > endIdx) {
                throw new DeserializationException("soap.malformedArrayType", arrayType);
            }
            dimStr = arrayType.substring(startIdx, endIdx + 1);
        }
        if (isSOAP12 && (dimStr = (attrs = reader.getAttributes()).getValue("http://www.w3.org/2002/06/soap-encoding", "arraySize")) == null) {
            throw new DeserializationException("soap.malformedArraySize", "<arraySize attribute mssing>");
        }
        return ArraySerializerBase.decodeArrayDimensions(dimStr);
    }

    protected int getArrayRank(Object obj) {
        int rank = 0;
        for (Class<?> type = obj.getClass(); type != this.elemClass; type = type.getComponentType()) {
            ++rank;
        }
        return rank;
    }

    protected int[] getArrayDimensions(Object obj) {
        int rank = this.rank >= 0 ? this.rank : this.getArrayRank(obj);
        return ArraySerializerBase.getArrayDimensions(obj, rank);
    }

    public static int[] getArrayDimensions(Object obj, int rank) {
        int[] dims = new int[rank];
        Object arr = obj;
        for (int i = 0; i < rank; ++i) {
            dims[i] = Array.getLength(arr);
            if (dims[i] == 0) break;
            arr = Array.get(arr, 0);
        }
        return dims;
    }

    public static int[] decodeArrayDimensions(String dimStr) throws Exception {
        String str = dimStr.trim();
        if (str.charAt(0) == '[' || str.charAt(str.length() - 1) == ']') {
            str = str.substring(1, str.length() - 1).trim();
        }
        int strLen = str.length();
        int dimCount = 0;
        if (strLen > 0) {
            ++dimCount;
            int commaIdx = -1;
            while ((commaIdx = str.indexOf(44, commaIdx + 1)) >= 0) {
                ++dimCount;
            }
        }
        int[] dims = new int[dimCount];
        int idx = 0;
        for (int i = 0; i < dimCount; ++i) {
            char c;
            while (idx < strLen && Character.isWhitespace(str.charAt(idx))) {
                ++idx;
            }
            int startIdx = idx;
            int dim = 0;
            while (idx < strLen && Character.isDigit(c = str.charAt(idx))) {
                dim = dim * 10 + (c - 48);
                ++idx;
            }
            if (idx > startIdx) {
                dims[i] = dim;
            } else {
                throw new DeserializationException("soap.malformedArrayDimensions", dimStr);
            }
            while (idx < strLen && Character.isWhitespace(str.charAt(idx))) {
                ++idx;
            }
            if (i < dimCount - 1) {
                if (idx >= strLen || str.charAt(idx) != ',') {
                    throw new DeserializationException("soap.malformedArrayDimensions", dimStr);
                }
                ++idx;
                continue;
            }
            if (idx == strLen) continue;
            throw new DeserializationException("soap.malformedArrayDimensions", dimStr);
        }
        return dims;
    }

    public static String encodeArrayDimensions(int[] dims) throws Exception {
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < dims.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(dims[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static boolean isPositionWithinBounds(int[] position, int[] dims) {
        for (int i = 0; i < position.length; ++i) {
            if (position[i] < dims[i]) continue;
            return false;
        }
        return true;
    }

    public static void incrementPosition(int[] position, int[] dims) throws Exception {
        for (int i = position.length - 1; i >= 0; --i) {
            int n = i;
            position[n] = position[n] + 1;
            if (position[n] < dims[i]) break;
            if (i == 0) {
                throw new DeserializationException("soap.outOfBoundsArrayElementPosition", ArraySerializerBase.encodeArrayDimensions(position));
            }
            position[i] = 0;
        }
    }

    public static int[] getDimensionOffsets(int[] dims) {
        int[] dimOffsets = null;
        if (ArraySerializerBase.isEmptyDimensions(dims)) {
            dimOffsets = new int[]{1};
        } else {
            dimOffsets = new int[dims.length];
            dimOffsets[dimOffsets.length - 1] = 1;
            for (int i = dimOffsets.length - 2; i >= 0; --i) {
                dimOffsets[i] = dims[i + 1] * dimOffsets[i + 1];
            }
        }
        return dimOffsets;
    }

    public static int indexFromPosition(int[] position, int[] dimOffsets) {
        int index = 0;
        for (int i = 0; i < position.length; ++i) {
            index += position[i] * dimOffsets[i];
        }
        return index;
    }

    public static int[] positionFromIndex(int index, int[] dimOffsets) {
        int[] position = new int[dimOffsets.length];
        int tmp = index;
        for (int i = 0; i < position.length; ++i) {
            position[i] = tmp / dimOffsets[i];
            tmp %= dimOffsets[i];
        }
        return position;
    }

    public void whatAmI() {
        this.helper.whatAmI();
    }
}

