/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding;

import com.nec.webotx.webservice.xml.rpc.encoding.DeserializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.Initializable;
import com.nec.webotx.webservice.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.nec.webotx.webservice.xml.rpc.encoding.JAXRPCDeserializer;
import com.nec.webotx.webservice.xml.rpc.encoding.JAXRPCSerializer;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPSerializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerBase;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerCallback;
import com.nec.webotx.webservice.xml.rpc.encoding.xsd.XSDConstants;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPConstantsFactory;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPEncodingConstants;
import com.nec.webotx.webservice.xml.rpc.soap.SOAPVersion;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriterUtil;
import com.nec.webotx.webservice.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaConstants;
import javax.xml.namespace.QName;

public class DynamicSerializer
extends SerializerBase
implements SchemaConstants,
Initializable {
    InternalTypeMappingRegistry registry = null;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public DynamicSerializer(QName xmlType, boolean encodeType, boolean isNullable, String encodingStyle) {
        this(xmlType, encodeType, isNullable, encodingStyle, SOAPVersion.SOAP_11);
    }

    public DynamicSerializer(QName xmlType, boolean encodeType, boolean isNullable, String encodingStyle, SOAPVersion ver) {
        super(xmlType, encodeType, isNullable, encodingStyle);
        this.init(ver);
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.registry = registry;
    }

    public void serialize(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        if (obj == null) {
            this.serializeNull(name, writer);
            return;
        }
        JAXRPCSerializer serializer = this.getSerializerForObject(obj);
        if (serializer != null) {
            serializer.serialize(obj, name, callback, writer, context);
        }
    }

    protected JAXRPCSerializer getSerializerForObject(Object obj) {
        JAXRPCSerializer serializer = null;
        try {
            serializer = (JAXRPCSerializer)this.registry.getSerializer(this.soapEncodingConstants.getURIEncoding(), obj.getClass());
            if (serializer instanceof DynamicSerializer) {
                throw new SerializationException("typemapping.serializer.is.dynamic", new Object[]{obj.getClass()});
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
        }
        return serializer;
    }

    protected void serializeNull(QName name, XMLWriter writer) {
        try {
            writer.startElement(name != null ? name : SchemaConstants.QNAME_ANY);
            String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
            writer.endElement();
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException("nestedSerializationError", e);
        }
    }

    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        try {
            JAXRPCDeserializer deserializer = this.getDeserializerForElement(reader, context);
            if (deserializer == null) {
                return null;
            }
            return deserializer.deserialize(name, reader, context);
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationException("nestedDeserializationError", new LocalizableExceptionAdapter(e));
        }
    }

    protected JAXRPCDeserializer getDeserializerForElement(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        if (DynamicSerializer.getNullStatus(reader)) {
            this.skipEmptyContent(reader);
            return null;
        }
        QName objectXMLType = DynamicSerializer.getType(reader);
        return (JAXRPCDeserializer)this.registry.getDeserializer(this.soapEncodingConstants.getURIEncoding(), objectXMLType);
    }
}

