/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding;

import com.nec.webotx.webservice.xml.rpc.encoding.SerializerConstants;
import com.nec.webotx.webservice.xml.rpc.encoding.TypeMappingException;
import com.nec.webotx.webservice.xml.rpc.encoding.TypeMappingImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class TypeMappingRegistryImpl
implements TypeMappingRegistry,
SerializerConstants {
    protected Map mappings;
    protected TypeMapping defaultMapping;

    public TypeMappingRegistryImpl() {
        this.init();
    }

    protected void init() {
        this.mappings = new HashMap();
        this.defaultMapping = null;
    }

    public TypeMapping register(String namespaceURI, TypeMapping mapping) {
        if (mapping == null || namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (!TypeMappingRegistryImpl.mappingSupportsEncoding(mapping, namespaceURI)) {
            throw new TypeMappingException("typemapping.mappingDoesNotSupportEncoding", namespaceURI);
        }
        TypeMapping oldMapping = (TypeMapping)this.mappings.get(namespaceURI);
        this.mappings.put(namespaceURI, mapping);
        return oldMapping;
    }

    public void registerDefault(TypeMapping mapping) {
        this.defaultMapping = mapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultMapping;
    }

    public String[] getRegisteredEncodingStyleURIs() {
        Set namespaceSet = this.mappings.keySet();
        return namespaceSet.toArray(new String[namespaceSet.size()]);
    }

    public TypeMapping getTypeMapping(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        TypeMapping mapping = (TypeMapping)this.mappings.get(namespaceURI);
        if (mapping == null) {
            mapping = this.defaultMapping;
        }
        return mapping;
    }

    public TypeMapping createTypeMapping() {
        return new TypeMappingImpl();
    }

    public TypeMapping unregisterTypeMapping(String namespaceURI) {
        return (TypeMapping)this.mappings.remove(namespaceURI);
    }

    public boolean removeTypeMapping(TypeMapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException("mapping cannot be null");
        }
        Set typeEntries = this.mappings.entrySet();
        Iterator eachEntry = typeEntries.iterator();
        boolean typeMappingFound = false;
        while (eachEntry.hasNext()) {
            Map.Entry currentEntry = eachEntry.next();
            if (!mapping.equals(currentEntry.getValue())) continue;
            eachEntry.remove();
            typeMappingFound = true;
        }
        return typeMappingFound;
    }

    public void clear() {
        this.mappings.clear();
    }

    protected static boolean mappingSupportsEncoding(TypeMapping mapping, String namespaceURI) {
        String[] encodings = ((TypeMappingImpl)mapping).getSupportedEncodings();
        for (int i = 0; i < encodings.length; ++i) {
            if (!encodings[i].equals(namespaceURI)) continue;
            return true;
        }
        return false;
    }
}

