/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding.simpletype;

import com.nec.webotx.webservice.xml.rpc.encoding.DeserializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.EncoderUtils;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.nec.webotx.webservice.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import com.nec.webotx.webservice.xml.rpc.util.xml.XmlUtil;
import javax.xml.namespace.QName;

public class XSDQNameEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDQNameEncoder();

    private XSDQNameEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        QName qn = (QName)obj;
        String str = "";
        String nsURI = qn.getNamespaceURI();
        if (nsURI != null && nsURI.length() > 0) {
            String prefix = writer.getPrefix(nsURI);
            if (prefix == null) {
                prefix = writer.getPrefixFactory().getPrefix(nsURI);
            }
            str = str + prefix + ":";
        }
        str = str + qn.getLocalPart();
        return str;
    }

    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        String uri = "";
        String prefix = XmlUtil.getPrefix(str = EncoderUtils.collapseWhitespace(str));
        if (prefix != null && (uri = reader.getURI(prefix)) == null) {
            throw new DeserializationException("xsd.unknownPrefix", prefix);
        }
        String localPart = XmlUtil.getLocalPart(str);
        return new QName(uri, localPart);
    }

    public void writeValue(Object obj, XMLWriter writer) throws Exception {
        writer.writeCharsUnquoted(this.objectToString(obj, writer));
    }

    public void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
        String uri;
        QName value = (QName)obj;
        if (value != null && !(uri = value.getNamespaceURI()).equals("") && writer.getPrefix(uri) == null) {
            writer.writeNamespaceDeclaration(uri);
        }
    }
}

