/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.model.soap;

import com.nec.webotx.webservice.xml.rpc.processor.model.ModelException;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPAttributeMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class SOAPAttributeOwningType
extends SOAPType {
    private List _attributeMembers = new ArrayList();
    private Map _attributeMembersByName = new HashMap();

    protected SOAPAttributeOwningType() {
    }

    protected SOAPAttributeOwningType(QName name) {
        this(name, (JavaStructureType)null);
    }

    protected SOAPAttributeOwningType(QName name, JavaStructureType javaType) {
        super(name, javaType);
    }

    public void add(SOAPAttributeMember m) {
        if (this._attributeMembersByName.containsKey(m.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._attributeMembers.add(m);
        this._attributeMembersByName.put(m.getName(), m);
    }

    public SOAPAttributeMember getAttributeMemberByName(String name) {
        if (this._attributeMembersByName.size() != this._attributeMembers.size()) {
            this.initializeAttributeMembersByName();
        }
        return (SOAPAttributeMember)this._attributeMembersByName.get(name);
    }

    public Iterator getAttributeMembers() {
        return this._attributeMembers.iterator();
    }

    public int getAttributeMembersCount() {
        return this._attributeMembers.size();
    }

    public List getAttributeMembersList() {
        return this._attributeMembers;
    }

    public void setAttributeMembersList(List l) {
        this._attributeMembers = l;
    }

    private void initializeAttributeMembersByName() {
        this._attributeMembersByName = new HashMap();
        if (this._attributeMembers != null) {
            Iterator iter = this._attributeMembers.iterator();
            while (iter.hasNext()) {
                SOAPAttributeMember m = (SOAPAttributeMember)iter.next();
                if (m.getName() != null && this._attributeMembersByName.containsKey(m.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this._attributeMembersByName.put(m.getName(), m);
            }
        }
    }
}

