/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.sp;

import com.nec.webotx.webservice.xml.rpc.sp.AttributeDecl;
import com.nec.webotx.webservice.xml.rpc.sp.AttributesEx;
import com.nec.webotx.webservice.xml.rpc.sp.AttributesExImpl;
import com.nec.webotx.webservice.xml.rpc.sp.ContentModel;
import com.nec.webotx.webservice.xml.rpc.sp.ElementDecl;
import com.nec.webotx.webservice.xml.rpc.sp.EndOfInputException;
import com.nec.webotx.webservice.xml.rpc.sp.EntityDecl;
import com.nec.webotx.webservice.xml.rpc.sp.ExternalEntity;
import com.nec.webotx.webservice.xml.rpc.sp.InputEntity;
import com.nec.webotx.webservice.xml.rpc.sp.InternalEntity;
import com.nec.webotx.webservice.xml.rpc.sp.MessageCatalog;
import com.nec.webotx.webservice.xml.rpc.sp.NamespaceSupport;
import com.nec.webotx.webservice.xml.rpc.sp.ParseException;
import com.nec.webotx.webservice.xml.rpc.sp.Resolver;
import com.nec.webotx.webservice.xml.rpc.sp.SimpleHashtable;
import com.nec.webotx.webservice.xml.rpc.sp.XmlChars;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class Parser2 {
    private String curName = null;
    private String curValue = null;
    private String curURI = null;
    private InputEntity in;
    private AttributesExImpl attTmp;
    private String[] parts = new String[3];
    private StringBuffer strTmp;
    private char[] nameTmp;
    private NameCache nameCache;
    private char[] charTmp = new char[2];
    private boolean namespace = false;
    private NamespaceSupport ns = null;
    private boolean isInAttribute = false;
    private boolean rejectDTDs = false;
    private boolean inExternalPE;
    private boolean doLexicalPE;
    private boolean donePrologue;
    private boolean doneEpilogue;
    private boolean doneContent;
    private AttributesExImpl attr = null;
    private int attrIndex = 0;
    private boolean startEmptyStack = true;
    private boolean isStandalone;
    private String rootElementName;
    private boolean ignoreDeclarations;
    private SimpleHashtable elements = new SimpleHashtable(47);
    private SimpleHashtable params = new SimpleHashtable(7);
    Map notations = new HashMap(7);
    SimpleHashtable entities = new SimpleHashtable(17);
    static final String strANY = "ANY";
    static final String strEMPTY = "EMPTY";
    private Locale locale;
    private EntityResolver resolver;
    Locator locator;
    private boolean fastStandalone = false;
    private static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private static final String XmlLang = "xml:lang";
    static final Catalog messages = new Catalog();
    private InputSource input = null;
    private boolean coalescing = false;
    private StringBuffer charsBuffer = null;
    private int cacheRet = -1;
    private String cacheName = null;
    private String cacheValue = null;
    private String simpleCharsBuffer = null;
    private boolean lastRetWasEnd = false;
    private FastStack stack = new FastStack(100);
    private PIQueue piQueue = new PIQueue(10);
    private static final int ELEMENT_IN_CONTENT = 1;
    private static final int ELEMENT_ROOT = 2;
    private static final int CONTENT_IN_ELEMENT = 4;
    private static final int CONTENT_IN_INTREF = 8;
    private static final int CONTENT_IN_EXTREF = 16;
    private static final int ELEMENT = 256;
    private static final int CONTENT = 1024;
    private static final int START = 1;
    private static final int END = 2;
    private static final int CHARS = 3;
    private static final int PI = 4;
    private static final int EMPTY = 10;
    private static final int ATTR = 11;
    private boolean haveAttributes = false;
    private int startLine;
    private boolean hasContent = true;
    static /* synthetic */ Class class$com$nec$webotx$webservice$xml$rpc$sp$Parser;

    public void setLocale(Locale l) throws ParseException {
        if (l != null && !messages.isLocaleSupported(l.toString())) {
            this.fatal(messages.getMessage(this.locale, "P-078", new Object[]{l}));
        }
        this.locale = l;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getCurName() {
        return this.curName;
    }

    public String getCurURI() {
        return this.curURI;
    }

    public String getCurValue() {
        return this.curValue;
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.ns;
    }

    public AttributesEx getAttributes() {
        return this.attr;
    }

    public int getLineNumber() {
        return this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator.getColumnNumber();
    }

    public String getPublicId() {
        return this.locator.getPublicId();
    }

    public String getSystemId() {
        return this.locator.getSystemId();
    }

    public Locale chooseLocale(String[] languages) throws ParseException {
        Locale l = messages.chooseLocale(languages);
        if (l != null) {
            this.setLocale(l);
        }
        return l;
    }

    public void setEntityResolver(EntityResolver r) {
        this.resolver = r;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setFastStandalone(boolean value) {
        this.fastStandalone = value;
    }

    public boolean isFastStandalone() {
        return this.fastStandalone;
    }

    private void init() {
        this.in = null;
        this.attTmp = new AttributesExImpl();
        this.strTmp = new StringBuffer();
        this.nameTmp = new char[20];
        this.nameCache = new NameCache();
        if (this.namespace) {
            if (this.ns == null) {
                this.ns = new NamespaceSupport();
            } else {
                this.ns.reset();
            }
        }
        this.isStandalone = false;
        this.rootElementName = null;
        this.isInAttribute = false;
        this.inExternalPE = false;
        this.doLexicalPE = false;
        this.donePrologue = false;
        this.doneEpilogue = false;
        this.doneContent = false;
        this.attr = null;
        this.attrIndex = 0;
        this.startEmptyStack = true;
        this.entities.clear();
        this.notations.clear();
        this.params.clear();
        this.elements.clear();
        this.ignoreDeclarations = false;
        this.stack.clear();
        this.piQueue.clear();
        this.builtin("amp", "&#38;");
        this.builtin("lt", "&#60;");
        this.builtin("gt", ">");
        this.builtin("quot", "\"");
        this.builtin("apos", "'");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.resolver == null) {
            this.resolver = new Resolver();
        }
    }

    private void builtin(String entityName, String entityValue) {
        InternalEntity entity = new InternalEntity(entityName, entityValue.toCharArray());
        this.entities.put(entityName, entity);
    }

    void afterRoot() throws ParseException {
    }

    void afterDocument() {
    }

    private void whitespace(String roleId) throws IOException, ParseException {
        if (!this.maybeWhitespace()) {
            this.fatal("P-004", new Object[]{messages.getMessage(this.locale, roleId)});
        }
    }

    private boolean maybeWhitespace() throws IOException, ParseException {
        if (!this.inExternalPE || !this.doLexicalPE) {
            return this.in.maybeWhitespace();
        }
        char c = this.getc();
        boolean saw = false;
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            saw = true;
            if (this.in.isEOF() && !this.in.isInternal()) {
                return saw;
            }
            c = this.getc();
        }
        this.ungetc();
        return saw;
    }

    private String maybeGetName() throws IOException, ParseException {
        NameCacheEntry entry = this.maybeGetNameCacheEntry();
        return entry == null ? null : entry.name;
    }

    private NameCacheEntry maybeGetNameCacheEntry() throws IOException, ParseException {
        char c = this.getc();
        if (!XmlChars.isLetter(c) && c != ':' && c != '_') {
            this.ungetc();
            return null;
        }
        return this.nameCharString(c);
    }

    private String getNmtoken() throws ParseException, IOException {
        char c = this.getc();
        if (!XmlChars.isNameChar(c)) {
            this.fatal("P-006", new Object[]{new Character(c)});
        }
        return this.nameCharString((char)c).name;
    }

    private NameCacheEntry nameCharString(char c) throws IOException, ParseException {
        int i = 1;
        this.nameTmp[0] = c;
        while ((c = this.in.getNameChar()) != '\u0000') {
            if (i >= this.nameTmp.length) {
                char[] tmp = new char[this.nameTmp.length + 10];
                System.arraycopy(this.nameTmp, 0, tmp, 0, this.nameTmp.length);
                this.nameTmp = tmp;
            }
            this.nameTmp[i++] = c;
        }
        return this.nameCache.lookupEntry(this.nameTmp, i);
    }

    private void parseLiteral(boolean isEntityValue) throws IOException, ParseException {
        boolean savedLexicalPE = this.doLexicalPE;
        this.doLexicalPE = isEntityValue;
        char quote = this.getc();
        InputEntity source = this.in;
        if (quote != '\'' && quote != '\"') {
            this.fatal("P-007");
        }
        this.isInAttribute = !isEntityValue;
        this.strTmp = new StringBuffer();
        while (true) {
            String entityName;
            if (this.in != source && this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            char c = this.getc();
            if (c == quote && this.in == source) break;
            if (c == '&') {
                entityName = this.maybeGetName();
                if (entityName != null) {
                    this.nextChar(';', "F-020", entityName);
                    if (isEntityValue) {
                        this.strTmp.append('&');
                        this.strTmp.append(entityName);
                        this.strTmp.append(';');
                        continue;
                    }
                    this.expandEntityInLiteral(entityName, this.entities, isEntityValue);
                    continue;
                }
                c = this.getc();
                if (c == '#') {
                    int tmp = this.parseCharNumber();
                    if (tmp > 65535) {
                        tmp = this.surrogatesToCharTmp(tmp);
                        this.strTmp.append(this.charTmp[0]);
                        if (tmp != 2) continue;
                        this.strTmp.append(this.charTmp[1]);
                        continue;
                    }
                    this.strTmp.append((char)tmp);
                    continue;
                }
                this.fatal("P-009");
                continue;
            }
            if (c == '%' && isEntityValue) {
                entityName = this.maybeGetName();
                if (entityName != null) {
                    this.nextChar(';', "F-021", entityName);
                    if (this.inExternalPE) {
                        this.expandEntityInLiteral(entityName, this.params, isEntityValue);
                        continue;
                    }
                    this.fatal("P-010", new Object[]{entityName});
                    continue;
                }
                this.fatal("P-011");
            }
            if (!isEntityValue) {
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                    this.strTmp.append(' ');
                    continue;
                }
                if (c == '<') {
                    this.fatal("P-012");
                }
            }
            this.strTmp.append(c);
        }
        this.isInAttribute = false;
        this.doLexicalPE = savedLexicalPE;
    }

    private void expandEntityInLiteral(String name, SimpleHashtable table, boolean isEntityValue) throws ParseException, IOException {
        Object entity = table.get(name);
        if (entity instanceof InternalEntity) {
            InternalEntity value = (InternalEntity)entity;
            this.pushReader(value.buf, name, !value.isPE);
        } else if (entity instanceof ExternalEntity) {
            if (!isEntityValue) {
                this.fatal("P-013", new Object[]{name});
            }
            this.pushReader((ExternalEntity)entity);
        } else if (entity == null) {
            this.fatal(table == this.params ? "V-022" : "P-014", new Object[]{name});
        }
    }

    private String getQuotedString(String type, String extra) throws IOException, ParseException {
        char c;
        char quote = this.in.getc();
        if (quote != '\'' && quote != '\"') {
            this.fatal("P-015", new Object[]{messages.getMessage(this.locale, type, new Object[]{extra})});
        }
        this.strTmp = new StringBuffer();
        while ((c = this.in.getc()) != quote) {
            this.strTmp.append(c);
        }
        return this.strTmp.toString();
    }

    private String parsePublicId() throws IOException, ParseException {
        String retval = this.getQuotedString("F-033", null);
        for (int i = 0; i < retval.length(); ++i) {
            char c = retval.charAt(i);
            if (" \r\n-'()+,./:=?;!*#@$_%0123456789".indexOf(c) != -1 || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            this.fatal("P-016", new Object[]{new Character(c)});
        }
        this.strTmp = new StringBuffer();
        this.strTmp.append(retval);
        return this.normalize(false);
    }

    private boolean maybeComment(boolean skipStart) throws IOException, ParseException {
        if (!this.in.peek(skipStart ? "!--" : "<!--", null)) {
            return false;
        }
        boolean savedLexicalPE = this.doLexicalPE;
        this.doLexicalPE = false;
        boolean saveCommentText = false;
        if (saveCommentText) {
            this.strTmp = new StringBuffer();
        }
        block2: while (true) {
            try {
                while (true) {
                    char c;
                    if ((c = this.getc()) == '-') {
                        c = this.getc();
                        if (c != '-') {
                            if (saveCommentText) {
                                this.strTmp.append('-');
                            }
                            this.ungetc();
                            continue;
                        }
                        this.nextChar('>', "F-022", null);
                        break block2;
                    }
                    if (!saveCommentText) continue;
                    this.strTmp.append(c);
                }
            }
            catch (EndOfInputException e) {
                if (this.inExternalPE || !this.donePrologue && this.in.isInternal()) {
                    this.in = this.in.pop();
                    continue;
                }
                this.fatal("P-017");
                continue;
            }
            break;
        }
        this.doLexicalPE = savedLexicalPE;
        return true;
    }

    private void maybeXmlDecl() throws IOException, ParseException {
        if (!this.peek("<?xml")) {
            return;
        }
        this.readVersion(true, "1.0");
        this.readEncoding(false);
        this.readStandalone();
        this.maybeWhitespace();
        if (!this.peek("?>")) {
            char c = this.getc();
            this.fatal("P-023", new Object[]{Integer.toHexString(c), new Character(c)});
        }
    }

    private String maybeReadAttribute(String name, boolean must) throws IOException, ParseException {
        if (!this.maybeWhitespace()) {
            if (!must) {
                return null;
            }
            this.fatal("P-024", new Object[]{name});
        }
        if (!this.peek(name)) {
            if (must) {
                this.fatal("P-024", new Object[]{name});
            } else {
                this.ungetc();
                return null;
            }
        }
        this.maybeWhitespace();
        this.nextChar('=', "F-023", null);
        this.maybeWhitespace();
        return this.getQuotedString("F-035", name);
    }

    private void readVersion(boolean must, String versionNum) throws IOException, ParseException {
        String value = this.maybeReadAttribute("version", must);
        if (must && value == null) {
            this.fatal("P-025", new Object[]{versionNum});
        }
        if (value != null) {
            int length = value.length();
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                if (c >= '0' && c <= '9' || c == '_' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':' || c == '-') continue;
                this.fatal("P-026", new Object[]{value});
            }
        }
        if (value != null && !value.equals(versionNum)) {
            this.error("P-027", new Object[]{versionNum, value});
        }
    }

    private void maybeMisc(boolean eofOK) throws IOException, ParseException {
        while (!(eofOK && this.in.isEOF() || !this.maybeComment(false) && !this.maybePI(false) && !this.maybeWhitespace())) {
        }
    }

    private String getMarkupDeclname(String roleId, boolean qname) throws IOException, ParseException {
        this.whitespace(roleId);
        String name = this.maybeGetName();
        if (name == null) {
            this.fatal("P-005", new Object[]{messages.getMessage(this.locale, roleId)});
        }
        return name;
    }

    private boolean maybeDoctypeDecl() throws IOException, ParseException {
        if (!this.peek("<!DOCTYPE")) {
            return false;
        }
        if (this.rejectDTDs) {
            this.fatal("P-085");
        }
        ExternalEntity externalSubset = null;
        this.rootElementName = this.getMarkupDeclname("F-014", true);
        if (this.maybeWhitespace() && (externalSubset = this.maybeExternalID()) != null) {
            this.maybeWhitespace();
        }
        if (this.in.peekc('[')) {
            this.in.startRemembering();
            while (true) {
                if (this.in.isEOF() && !this.in.isDocument()) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.maybeMarkupDecl() || this.maybePEReference() || this.maybeWhitespace()) continue;
                if (!this.peek("<![")) break;
                this.fatal("P-028");
            }
            this.nextChar(']', "F-024", null);
            this.maybeWhitespace();
        }
        this.nextChar('>', "F-025", null);
        if (externalSubset != null) {
            // empty if block
        }
        this.params.clear();
        ArrayList<String> v = new ArrayList<String>();
        Iterator e = this.notations.keySet().iterator();
        while (e.hasNext()) {
            String name = (String)e.next();
            Object value = this.notations.get(name);
            if (value == Boolean.TRUE) {
                v.add(name);
                continue;
            }
            if (!(value instanceof String)) continue;
            v.add(name);
        }
        while (!v.isEmpty()) {
            Object name = v.get(0);
            v.remove(name);
            this.notations.remove(name);
        }
        return true;
    }

    private boolean maybeMarkupDecl() throws IOException, ParseException {
        return this.maybeElementDecl() || this.maybeAttlistDecl() || this.maybeEntityDecl() || this.maybeNotationDecl() || this.maybePI(false) || this.maybeComment(false);
    }

    private void readStandalone() throws IOException, ParseException {
        String value = this.maybeReadAttribute("standalone", false);
        if (value == null || "no".equals(value)) {
            return;
        }
        if ("yes".equals(value)) {
            this.isStandalone = true;
            return;
        }
        this.fatal("P-029", new Object[]{value});
    }

    /*
     * WARNING - void declaration
     */
    private boolean isXmlLang(String value) {
        void var2_3;
        int nextSuffix;
        if (value.length() < 2) {
            return false;
        }
        char c = value.charAt(1);
        if (c == '-') {
            c = value.charAt(0);
            if (c != 'i' && c != 'I' && c != 'x' && c != 'X') {
                return false;
            }
            nextSuffix = 1;
        } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            c = value.charAt(0);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                return false;
            }
            nextSuffix = 2;
        } else {
            return false;
        }
        while (var2_3 < value.length() && (c = value.charAt((int)var2_3)) == '-') {
            while (++var2_3 < value.length() && ((c = value.charAt((int)var2_3)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            }
        }
        return value.length() == var2_3 && c != '-';
    }

    private boolean defaultAttributes(AttributesExImpl attributes, ElementDecl element) throws ParseException {
        boolean didDefault = false;
        Iterator e = element.attributes.keys();
        while (e.hasNext()) {
            String key = (String)e.next();
            String value = attributes.getValue(key);
            if (value != null) continue;
            AttributeDecl info = (AttributeDecl)element.attributes.get(key);
            if (info.defaultValue == null) continue;
            attributes.addAttribute("", key, key, info.type, info.defaultValue, info.defaultValue, false);
            didDefault = true;
        }
        return didDefault;
    }

    private boolean maybeElementDecl() throws IOException, ParseException {
        InputEntity start = this.peekDeclaration("!ELEMENT");
        if (start == null) {
            return false;
        }
        String name = this.getMarkupDeclname("F-015", true);
        ElementDecl element = (ElementDecl)this.elements.get(name);
        boolean declEffective = false;
        if (element != null) {
            if (element.contentType != null) {
                element = new ElementDecl(name);
            }
        } else {
            element = new ElementDecl(name);
            if (!this.ignoreDeclarations) {
                this.elements.put(element.name, element);
                declEffective = true;
            }
        }
        element.isFromInternalSubset = !this.inExternalPE;
        this.whitespace("F-000");
        if (this.peek(strEMPTY)) {
            element.contentType = strEMPTY;
            element.ignoreWhitespace = true;
        } else if (this.peek(strANY)) {
            element.contentType = strANY;
            element.ignoreWhitespace = false;
        } else {
            element.contentType = this.getMixedOrChildren(element);
        }
        this.maybeWhitespace();
        char c = this.getc();
        if (c != '>') {
            this.fatal("P-036", new Object[]{name, new Character(c)});
        }
        return true;
    }

    private String getMixedOrChildren(ElementDecl element) throws IOException, ParseException {
        this.strTmp = new StringBuffer();
        this.nextChar('(', "F-028", element.name);
        InputEntity start = this.in;
        this.maybeWhitespace();
        this.strTmp.append('(');
        if (this.peek("#PCDATA")) {
            this.strTmp.append("#PCDATA");
            this.getMixed(element.name, start);
            element.ignoreWhitespace = false;
        } else {
            element.model = this.getcps(element.name, start);
            element.ignoreWhitespace = true;
        }
        return this.strTmp.toString();
    }

    private ContentModel getcps(String element, InputEntity start) throws IOException, ParseException {
        boolean decided = false;
        char type = '\u0000';
        ContentModel temp = null;
        ContentModel current = null;
        ContentModel retval = null;
        do {
            String tag;
            if ((tag = this.maybeGetName()) != null) {
                this.strTmp.append(tag);
                temp = this.getFrequency(null);
            } else if (this.peek("(")) {
                InputEntity next = this.in;
                this.strTmp.append('(');
                this.maybeWhitespace();
                temp = this.getFrequency(this.getcps(element, next));
            } else {
                this.fatal(type == '\u0000' ? "P-039" : (type == ',' ? "P-037" : "P-038"), new Object[]{new Character(this.getc())});
            }
            this.maybeWhitespace();
            if (decided) {
                char c = this.getc();
                if (current != null) {
                    current = current.next = null;
                }
                if (c == type) {
                    this.strTmp.append(type);
                    this.maybeWhitespace();
                    continue;
                }
                if (c == ')') {
                    this.ungetc();
                    continue;
                }
                this.fatal(type == '\u0000' ? "P-041" : "P-040", new Object[]{new Character(c), new Character(type)});
            } else {
                type = this.getc();
                if (type != '|' && type != ',') {
                    retval = current = temp;
                    this.ungetc();
                    continue;
                }
                decided = true;
                current = null;
                retval = null;
                this.strTmp.append(type);
            }
            this.maybeWhitespace();
        } while (!this.peek(")"));
        this.strTmp.append(')');
        return this.getFrequency(retval);
    }

    private ContentModel getFrequency(ContentModel original) throws IOException, ParseException {
        char c = this.getc();
        if (c == '?' || c == '+' || c == '*') {
            this.strTmp.append(c);
            if (original == null) {
                return null;
            }
            if (original.type == '\u0000') {
                original.type = c;
                return original;
            }
            return null;
        }
        this.ungetc();
        return original;
    }

    private void getMixed(String element, InputEntity start) throws IOException, ParseException {
        this.maybeWhitespace();
        if (this.peek(")*") || this.peek(")")) {
            this.strTmp.append(')');
            return;
        }
        while (this.peek("|")) {
            this.strTmp.append('|');
            this.maybeWhitespace();
            String name = this.maybeGetName();
            if (name == null) {
                this.fatal("P-042", new Object[]{element, Integer.toHexString(this.getc())});
            }
            this.strTmp.append(name);
            this.maybeWhitespace();
        }
        if (!this.peek(")*")) {
            this.fatal("P-043", new Object[]{element, new Character(this.getc())});
        }
        this.strTmp.append(')');
    }

    private boolean maybeAttlistDecl() throws IOException, ParseException {
        InputEntity start = this.peekDeclaration("!ATTLIST");
        if (start == null) {
            return false;
        }
        String name = this.getMarkupDeclname("F-016", true);
        ElementDecl element = (ElementDecl)this.elements.get(name);
        if (element == null) {
            element = new ElementDecl(name);
            if (!this.ignoreDeclarations) {
                this.elements.put(name, element);
            }
        }
        this.maybeWhitespace();
        while (!this.peek(">")) {
            int i;
            ArrayList<String> v;
            name = this.maybeGetName();
            if (name == null) {
                this.fatal("P-044", new Object[]{new Character(this.getc())});
            }
            this.whitespace("F-001");
            AttributeDecl a = new AttributeDecl(name);
            boolean bl = a.isFromInternalSubset = !this.inExternalPE;
            if (this.peek("CDATA")) {
                a.type = "CDATA";
            } else if (this.peek("IDREFS")) {
                a.type = "IDREFS";
            } else if (this.peek("IDREF")) {
                a.type = "IDREF";
            } else if (this.peek("ID")) {
                a.type = "ID";
                if (element.id == null) {
                    element.id = name;
                }
            } else if (this.peek("ENTITY")) {
                a.type = "ENTITY";
            } else if (this.peek("ENTITIES")) {
                a.type = "ENTITIES";
            } else if (this.peek("NMTOKENS")) {
                a.type = "NMTOKENS";
            } else if (this.peek("NMTOKEN")) {
                a.type = "NMTOKEN";
            } else if (this.peek("NOTATION")) {
                a.type = "NOTATION";
                this.whitespace("F-002");
                this.nextChar('(', "F-029", null);
                this.maybeWhitespace();
                v = new ArrayList();
                do {
                    if ((name = this.maybeGetName()) == null) {
                        this.fatal("P-068");
                    }
                    v.add(name);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                a.values = new String[v.size()];
                for (i = 0; i < v.size(); ++i) {
                    a.values[i] = (String)v.get(i);
                }
            } else if (this.peek("(")) {
                a.type = "ENUMERATION";
                this.maybeWhitespace();
                v = new ArrayList<String>();
                do {
                    name = this.getNmtoken();
                    v.add(name);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                a.values = new String[v.size()];
                for (i = 0; i < v.size(); ++i) {
                    a.values[i] = (String)v.get(i);
                }
            } else {
                this.fatal("P-045", new Object[]{name, new Character(this.getc())});
            }
            this.whitespace("F-003");
            if (this.peek("#REQUIRED")) {
                a.isRequired = true;
            } else if (this.peek("#FIXED")) {
                a.isFixed = true;
                this.whitespace("F-004");
                this.parseLiteral(false);
                a.defaultValue = a.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
            } else if (!this.peek("#IMPLIED")) {
                this.parseLiteral(false);
                a.defaultValue = a.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
            }
            if (XmlLang.equals(a.name) && a.defaultValue != null && !this.isXmlLang(a.defaultValue)) {
                this.error("P-033", new Object[]{a.defaultValue});
            }
            if (!this.ignoreDeclarations && element.attributes.get(a.name) == null) {
                element.attributes.put(a.name, a);
            }
            this.maybeWhitespace();
        }
        return true;
    }

    private String normalize(boolean invalidIfNeeded) throws ParseException {
        String s = this.strTmp.toString();
        String s2 = s.trim();
        boolean didStrip = false;
        if (s != s2) {
            s = s2;
            s2 = null;
            didStrip = true;
        }
        this.strTmp = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!XmlChars.isSpace(c)) {
                this.strTmp.append(c);
                continue;
            }
            this.strTmp.append(' ');
            while (++i < s.length() && XmlChars.isSpace(s.charAt(i))) {
                didStrip = true;
            }
            --i;
        }
        if (didStrip) {
            return this.strTmp.toString();
        }
        return s;
    }

    private boolean maybeConditionalSect() throws IOException, ParseException {
        if (!this.peek("<![")) {
            return false;
        }
        InputEntity start = this.in;
        this.maybeWhitespace();
        String keyword = this.maybeGetName();
        if (keyword == null) {
            this.fatal("P-046");
        }
        this.maybeWhitespace();
        this.nextChar('[', "F-030", null);
        if ("INCLUDE".equals(keyword)) {
            while (true) {
                if (this.in.isEOF() && this.in != start) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.in.isEOF()) {
                    this.in = this.in.pop();
                }
                if (!this.peek("]]>")) {
                    this.doLexicalPE = false;
                    if (this.maybeWhitespace() || this.maybePEReference()) continue;
                    this.doLexicalPE = true;
                    if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
                    this.fatal("P-047");
                    continue;
                }
                break;
            }
        } else if ("IGNORE".equals(keyword)) {
            int nestlevel = 1;
            this.doLexicalPE = false;
            while (nestlevel > 0) {
                char c = this.getc();
                if (c == '<') {
                    if (!this.peek("![")) continue;
                    ++nestlevel;
                    continue;
                }
                if (c != ']' || !this.peek("]>")) continue;
                --nestlevel;
            }
        } else {
            this.fatal("P-048", new Object[]{keyword});
        }
        return true;
    }

    private int parseCharNumber() throws ParseException, IOException {
        int retval = 0;
        if (this.getc() != 'x') {
            this.ungetc();
            while (true) {
                char c;
                if ((c = this.getc()) >= '0' && c <= '9') {
                    retval *= 10;
                    retval += c - 48;
                    continue;
                }
                if (c == ';') {
                    return retval;
                }
                this.fatal("P-049");
            }
        }
        while (true) {
            char c;
            if ((c = this.getc()) >= '0' && c <= '9') {
                retval <<= 4;
                retval += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                retval <<= 4;
                retval += 10 + (c - 97);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                retval <<= 4;
                retval += 10 + (c - 65);
                continue;
            }
            if (c == ';') {
                return retval;
            }
            this.fatal("P-050");
        }
    }

    private int surrogatesToCharTmp(int ucs4) throws ParseException {
        if (ucs4 <= 65535) {
            if (XmlChars.isChar(ucs4)) {
                this.charTmp[0] = (char)ucs4;
                return 1;
            }
        } else if (ucs4 <= 0x10FFFF) {
            this.charTmp[0] = (char)(0xD800 | (ucs4 -= 65536) >> 10 & 0x3FF);
            this.charTmp[1] = (char)(0xDC00 | ucs4 & 0x3FF);
            return 2;
        }
        this.fatal("P-051", new Object[]{Integer.toHexString(ucs4)});
        return -1;
    }

    private boolean maybePEReference() throws IOException, ParseException {
        if (!this.in.peekc('%')) {
            return false;
        }
        String name = this.maybeGetName();
        if (name == null) {
            this.fatal("P-011");
        }
        this.nextChar(';', "F-021", name);
        Object entity = this.params.get(name);
        if (entity instanceof InternalEntity) {
            InternalEntity value = (InternalEntity)entity;
            this.pushReader(value.buf, name, false);
        } else if (entity instanceof ExternalEntity) {
            this.externalParameterEntity((ExternalEntity)entity);
        } else if (entity == null) {
            this.ignoreDeclarations = true;
            this.warning("V-022", new Object[]{name});
        }
        return true;
    }

    private boolean maybeEntityDecl() throws IOException, ParseException {
        boolean doStore;
        SimpleHashtable defns;
        InputEntity start = this.peekDeclaration("!ENTITY");
        if (start == null) {
            return false;
        }
        this.doLexicalPE = false;
        this.whitespace("F-005");
        if (this.in.peekc('%')) {
            this.whitespace("F-006");
            defns = this.params;
        } else {
            defns = this.entities;
        }
        this.ungetc();
        this.doLexicalPE = true;
        String entityName = this.getMarkupDeclname("F-017", false);
        this.whitespace("F-007");
        ExternalEntity externalId = this.maybeExternalID();
        boolean bl = doStore = defns.get(entityName) == null;
        if (!doStore && defns == this.entities) {
            this.warning("P-054", new Object[]{entityName});
        }
        doStore &= !this.ignoreDeclarations;
        if (externalId == null) {
            this.doLexicalPE = false;
            this.parseLiteral(true);
            this.doLexicalPE = true;
            if (doStore) {
                char[] value = new char[this.strTmp.length()];
                if (value.length != 0) {
                    this.strTmp.getChars(0, value.length, value, 0);
                }
                InternalEntity entity = new InternalEntity(entityName, value);
                entity.isPE = defns == this.params;
                entity.isFromInternalSubset = !this.inExternalPE;
                defns.put(entityName, entity);
            }
        } else {
            if (defns == this.entities && this.maybeWhitespace() && this.peek("NDATA")) {
                externalId.notation = this.getMarkupDeclname("F-018", false);
            }
            externalId.name = entityName;
            externalId.isPE = defns == this.params;
            boolean bl2 = externalId.isFromInternalSubset = !this.inExternalPE;
            if (doStore) {
                defns.put(entityName, externalId);
            }
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-031", entityName);
        return true;
    }

    private ExternalEntity maybeExternalID() throws IOException, ParseException {
        String temp = null;
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            temp = this.parsePublicId();
        } else if (!this.peek("SYSTEM")) {
            return null;
        }
        ExternalEntity retval = new ExternalEntity(this.in);
        retval.publicId = temp;
        this.whitespace("F-008");
        retval.systemId = this.parseSystemId();
        return retval;
    }

    private String parseSystemId() throws IOException, ParseException {
        String uri = this.getQuotedString("F-034", null);
        int temp = uri.indexOf(58);
        if (temp == -1 || uri.indexOf(47) < temp) {
            String baseURI = this.in.getSystemId();
            if (baseURI == null) {
                baseURI = "NODOCTYPE:///tmp/";
            }
            if (uri.length() == 0) {
                uri = ".";
            }
            baseURI = baseURI.substring(0, baseURI.lastIndexOf(47) + 1);
            if (uri.charAt(0) != '/') {
                uri = baseURI + uri;
            } else {
                throw new InternalError();
            }
        }
        if (uri.indexOf(35) != -1) {
            this.error("P-056", new Object[]{uri});
        }
        return uri;
    }

    private void maybeTextDecl() throws IOException, ParseException {
        if (this.peek("<?xml")) {
            this.readVersion(false, "1.0");
            this.readEncoding(true);
            this.maybeWhitespace();
            if (!this.peek("?>")) {
                this.fatal("P-057");
            }
        }
    }

    private void externalParameterEntity(ExternalEntity next) throws IOException, ParseException {
        if (this.isStandalone && this.fastStandalone) {
            return;
        }
        this.inExternalPE = true;
        this.pushReader(next);
        InputEntity pe = this.in;
        this.maybeTextDecl();
        while (!pe.isEOF()) {
            if (this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            this.doLexicalPE = false;
            if (this.maybeWhitespace() || this.maybePEReference()) continue;
            this.doLexicalPE = true;
            if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
        }
        if (!pe.isEOF()) {
            this.fatal("P-059", new Object[]{this.in.getName()});
        }
        this.in = this.in.pop();
        this.inExternalPE = !this.in.isDocument();
        this.doLexicalPE = false;
    }

    private void readEncoding(boolean must) throws IOException, ParseException {
        String name = this.maybeReadAttribute("encoding", must);
        if (name == null) {
            return;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || i != 0 && (c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.')) continue;
            this.fatal("P-060", new Object[]{new Character(c)});
        }
        String currentEncoding = this.in.getEncoding();
        if (currentEncoding != null && !name.equalsIgnoreCase(currentEncoding)) {
            this.warning("P-061", new Object[]{name, currentEncoding});
        }
    }

    private boolean maybeNotationDecl() throws IOException, ParseException {
        Object value;
        InputEntity start = this.peekDeclaration("!NOTATION");
        if (start == null) {
            return false;
        }
        String name = this.getMarkupDeclname("F-019", false);
        ExternalEntity entity = new ExternalEntity(this.in);
        this.whitespace("F-011");
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            entity.publicId = this.parsePublicId();
            if (this.maybeWhitespace() && !this.peek(">")) {
                entity.systemId = this.parseSystemId();
            }
        } else if (this.peek("SYSTEM")) {
            this.whitespace("F-008");
            entity.systemId = this.parseSystemId();
        } else {
            this.fatal("P-062");
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-032", name);
        if (entity.systemId != null && entity.systemId.indexOf(35) != -1) {
            this.error("P-056", new Object[]{entity.systemId});
        }
        if ((value = this.notations.get(name)) != null && value instanceof ExternalEntity) {
            this.warning("P-063", new Object[]{name});
        } else if (!this.ignoreDeclarations) {
            this.notations.put(name, entity);
        }
        return true;
    }

    private char getc() throws IOException, ParseException {
        if (!this.inExternalPE || !this.doLexicalPE) {
            char c = this.in.getc();
            if (c == '%' && this.doLexicalPE) {
                this.fatal("P-080");
            }
            return c;
        }
        while (this.in.isEOF()) {
            if (this.in.isInternal() || this.doLexicalPE && !this.in.isDocument()) {
                this.in = this.in.pop();
                continue;
            }
            this.fatal("P-064", new Object[]{this.in.getName()});
        }
        char c = this.in.getc();
        if (c == '%' && this.doLexicalPE) {
            String name = this.maybeGetName();
            if (name == null) {
                this.fatal("P-011");
            }
            this.nextChar(';', "F-021", name);
            Object entity = this.params.get(name);
            this.pushReader(" ".toCharArray(), null, false);
            if (entity instanceof InternalEntity) {
                this.pushReader(((InternalEntity)entity).buf, name, false);
            } else if (entity instanceof ExternalEntity) {
                this.pushReader((ExternalEntity)entity);
            } else if (entity == null) {
                this.fatal("V-022");
            } else {
                throw new InternalError();
            }
            this.pushReader(" ".toCharArray(), null, false);
            return this.in.getc();
        }
        return c;
    }

    private void ungetc() {
        this.in.ungetc();
    }

    private boolean peek(String s) throws IOException, ParseException {
        return this.in.peek(s, null);
    }

    private InputEntity peekDeclaration(String s) throws IOException, ParseException {
        if (!this.in.peekc('<')) {
            return null;
        }
        InputEntity start = this.in;
        if (this.in.peek(s, null)) {
            return start;
        }
        this.in.ungetc();
        return null;
    }

    private void nextChar(char c, String location, String near) throws IOException, ParseException {
        while (this.in.isEOF() && !this.in.isDocument()) {
            this.in = this.in.pop();
        }
        if (!this.in.peekc(c)) {
            this.fatal("P-008", new Object[]{new Character(c), messages.getMessage(this.locale, location), near == null ? "" : '\"' + near + '\"'});
        }
    }

    private void pushReader(char[] buf, String name, boolean isGeneral) throws ParseException {
        InputEntity r = InputEntity.getInputEntity(this.locale);
        r.init(buf, name, this.in, !isGeneral);
        this.in = r;
    }

    private boolean pushReader(ExternalEntity next) throws ParseException, IOException {
        try {
            InputEntity r = InputEntity.getInputEntity(this.locale);
            InputSource s = next.getInputSource(this.resolver);
            r.init(s, next.name, this.in, next.isPE);
            this.in = r;
        }
        catch (SAXException e) {
            throw this.translate(e);
        }
        return true;
    }

    private void warning(String messageId, Object[] parameters) throws ParseException {
        this.fatal(messages.getMessage(this.locale, messageId, parameters));
    }

    void error(String messageId, Object[] parameters) throws ParseException {
        this.fatal(messages.getMessage(this.locale, messageId, parameters));
    }

    private void fatal(String message) throws ParseException {
        this.fatal(message, null, null);
    }

    private void fatal(String message, Object[] parameters) throws ParseException {
        this.fatal(message, parameters, null);
    }

    private void fatal(String messageId, Object[] parameters, Exception e) throws ParseException {
        String m2;
        String m = messages.getMessage(this.locale, messageId, parameters);
        String string2 = m2 = e == null ? null : e.toString();
        if (m2 != null) {
            m = m + ": " + m2;
        }
        ParseException x = new ParseException(m, this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        throw x;
    }

    private ParseException translate(SAXException x) {
        String m = x.getMessage();
        if (x.getException() != null) {
            String n = x.getException().toString();
            m = m != null ? m + ": " + n : n;
        }
        return new ParseException(m);
    }

    public Parser2(InputStream in, boolean coalescing, boolean namespaceAware) {
        this(new InputSource(in), coalescing, namespaceAware, false);
    }

    public Parser2(InputStream in, boolean coalescing, boolean namespaceAware, boolean rejectDTDs) {
        this(new InputSource(in), coalescing, namespaceAware, rejectDTDs);
    }

    public Parser2(InputStream in) {
        this(new InputSource(in), false, false, false);
    }

    public Parser2(File file, boolean coalescing, boolean namespaceAware) throws IOException {
        this(file, coalescing, namespaceAware, false);
    }

    public Parser2(File file, boolean coalescing, boolean namespaceAware, boolean rejectDTDs) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        InputSource is = new InputSource(in);
        is.setSystemId(file.toURL().toString());
        this.locator = new DocLocator();
        this.input = is;
        this.coalescing = coalescing;
        this.namespace = namespaceAware;
        this.rejectDTDs = rejectDTDs;
    }

    public Parser2(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        InputSource is = new InputSource(in);
        is.setSystemId(file.toURL().toString());
        this.locator = new DocLocator();
        this.input = is;
    }

    private Parser2(InputSource input, boolean coalescing, boolean namespaceAware, boolean rejectDTDs) {
        this.locator = new DocLocator();
        this.input = input;
        this.coalescing = coalescing;
        this.namespace = namespaceAware;
        this.rejectDTDs = rejectDTDs;
    }

    private void prologue() throws IOException, ParseException {
        this.init();
        if (this.input == null) {
            this.fatal("P-000");
        }
        this.in = InputEntity.getInputEntity(this.locale);
        this.in.init(this.input, null, null, false);
        this.maybeXmlDecl();
        this.maybeMisc(false);
        this.maybeDoctypeDecl();
        this.maybeMisc(false);
    }

    public int parse() throws ParseException, IOException {
        int ret = 0;
        try {
            if (!this.donePrologue) {
                this.prologue();
                this.donePrologue = true;
            }
            if ((ret = this.retrievePIs()) != -1) {
                return ret;
            }
            if (!this.doneContent) {
                if (!this.coalescing) {
                    ret = this.parseContent();
                    if (ret != 10) {
                        return ret;
                    }
                    this.doneContent = true;
                } else {
                    if (this.lastRetWasEnd) {
                        this.ns.slideContextUp();
                        this.lastRetWasEnd = false;
                    }
                    if (this.cacheRet != -1) {
                        ret = this.cacheRet;
                        this.curName = this.cacheName;
                        this.curValue = this.cacheValue;
                        this.cacheRet = -1;
                        this.cacheName = null;
                        this.cacheValue = null;
                        if (this.namespace) {
                            if (ret == 1) {
                                this.ns.slideContextDown();
                            } else if (ret == 2) {
                                this.lastRetWasEnd = true;
                            }
                        }
                        return ret;
                    }
                    while ((ret = this.parseContent()) != 10) {
                        if (ret == 3) {
                            if (this.simpleCharsBuffer == null) {
                                this.simpleCharsBuffer = this.curValue;
                                continue;
                            }
                            if (this.charsBuffer == null) {
                                this.charsBuffer = new StringBuffer();
                                this.charsBuffer.append(this.simpleCharsBuffer);
                            }
                            this.charsBuffer.append(this.curValue);
                            continue;
                        }
                        if (ret == 3) continue;
                        if (this.simpleCharsBuffer != null) {
                            this.cacheRet = ret;
                            this.cacheName = this.curName;
                            this.cacheValue = this.curValue;
                            if (this.charsBuffer == null) {
                                this.curName = null;
                                this.curValue = this.simpleCharsBuffer;
                            } else {
                                this.curName = null;
                                this.curValue = this.charsBuffer.toString();
                                this.charsBuffer = null;
                            }
                            this.simpleCharsBuffer = null;
                            if (this.namespace) {
                                if (this.cacheRet == 1) {
                                    this.ns.slideContextUp();
                                } else if (this.cacheRet == 2) {
                                    this.ns.slideContextDown();
                                }
                            }
                            return 3;
                        }
                        if (ret == 2) {
                            this.lastRetWasEnd = true;
                            this.ns.slideContextDown();
                        }
                        return ret;
                    }
                    this.doneContent = true;
                }
            }
            if (!this.doneEpilogue) {
                this.epilogue();
                this.doneEpilogue = true;
            }
            return this.retrievePIs();
        }
        catch (EndOfInputException e) {
            if (!this.in.isDocument()) {
                String name = this.in.getName();
                try {
                    do {
                        this.in = this.in.pop();
                    } while (this.in.isInternal());
                    this.fatal("P-002", new Object[]{name}, e);
                }
                catch (IOException x) {
                    this.fatal("P-002", new Object[]{name}, e);
                }
            } else {
                this.fatal("P-003", null, e);
            }
        }
        catch (RuntimeException e) {
            throw new ParseException(e.getMessage() != null ? e.getMessage() : e.getClass().getName(), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        }
        return ret;
    }

    private int retrievePIs() {
        if (!this.piQueue.empty()) {
            this.curName = this.piQueue.getNextTarget();
            this.curValue = this.piQueue.getNextContent();
            return 4;
        }
        return -1;
    }

    private void epilogue() throws IOException, ParseException {
        block12: {
            try {
                block11: {
                    try {
                        this.afterRoot();
                        this.maybeMisc(true);
                        if (this.in.isEOF()) break block11;
                        this.fatal("P-001", new Object[]{Integer.toHexString(this.getc())});
                    }
                    catch (EndOfInputException e) {
                        if (!this.in.isDocument()) {
                            String name = this.in.getName();
                            do {
                                this.in = this.in.pop();
                            } while (this.in.isInternal());
                            this.fatal("P-002", new Object[]{name}, e);
                        } else {
                            this.fatal("P-003", null, e);
                        }
                        Object var4_2 = null;
                        this.strTmp = null;
                        this.attTmp = null;
                        this.nameTmp = null;
                        this.nameCache = null;
                        if (this.in != null) {
                            this.in.close();
                            this.in = null;
                        }
                        this.params.clear();
                        this.entities.clear();
                        this.notations.clear();
                        this.elements.clear();
                        this.afterDocument();
                        break block12;
                    }
                    catch (RuntimeException e) {
                        throw new ParseException(e.getMessage() != null ? e.getMessage() : e.getClass().getName(), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
                    }
                }
                Object var4_1 = null;
                this.strTmp = null;
                this.attTmp = null;
                this.nameTmp = null;
                this.nameCache = null;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                this.params.clear();
                this.entities.clear();
                this.notations.clear();
                this.elements.clear();
                this.afterDocument();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.strTmp = null;
                this.attTmp = null;
                this.nameTmp = null;
                this.nameCache = null;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                this.params.clear();
                this.entities.clear();
                this.notations.clear();
                this.elements.clear();
                this.afterDocument();
                throw throwable;
            }
        }
    }

    private ElementDecl getElement() throws IOException, ParseException {
        NameCacheEntry name = this.maybeGetNameCacheEntry();
        if (name == null) {
            return null;
        }
        ElementDecl element = (ElementDecl)this.elements.get(name.name);
        if (element == null || element.contentType == null) {
            element = new ElementDecl(name.name);
            element.contentType = strANY;
            this.elements.put(name.name, element);
        }
        this.startLine = this.in.getLineNumber();
        boolean sawWhite = this.in.maybeWhitespace();
        while (!this.in.peekc('>')) {
            AttributeDecl info;
            String attName;
            if (this.in.peekc('/')) {
                this.hasContent = false;
                break;
            }
            if (!sawWhite) {
                this.fatal("P-030");
            }
            if ((attName = this.maybeGetName()) == null) {
                this.fatal("P-031", new Object[]{new Character(this.getc())});
            }
            if (this.attTmp.getValue(attName) != null) {
                this.fatal("P-032", new Object[]{attName});
            }
            this.in.maybeWhitespace();
            this.nextChar('=', "F-026", attName);
            this.in.maybeWhitespace();
            this.parseLiteral(false);
            sawWhite = this.in.maybeWhitespace();
            AttributeDecl attributeDecl = info = element == null ? null : (AttributeDecl)element.attributes.get(attName);
            String value = info == null ? this.strTmp.toString() : (!"CDATA".equals(info.type) ? this.normalize(!info.isFromInternalSubset) : this.strTmp.toString());
            if (XmlLang.equals(attName) && !this.isXmlLang(value)) {
                this.error("P-033", new Object[]{value});
            }
            this.attTmp.addAttribute("", attName, attName, info == null ? "CDATA" : info.type, value, info == null ? null : info.defaultValue, true);
            this.haveAttributes = true;
        }
        if (element != null) {
            this.attTmp.setIdAttributeName(element.id);
        }
        if (element != null && element.attributes.size() != 0) {
            this.haveAttributes = this.defaultAttributes(this.attTmp, element) || this.haveAttributes;
        }
        this.attr = this.attTmp;
        return element;
    }

    private boolean maybeReferenceInContent() throws IOException, ParseException {
        return this.in.peekc('&');
    }

    private boolean maybeEntityReference() throws IOException, ParseException {
        return !this.in.peekc('#');
    }

    private Object getEntityReference() throws IOException, ParseException {
        String name = this.maybeGetName();
        if (name == null) {
            this.fatal("P-009");
        }
        this.nextChar(';', "F-020", name);
        Object entity = this.entities.get(name);
        this.err(" after in = " + this.in);
        if (entity == null) {
            this.fatal("P-014", new Object[]{name});
        }
        return entity;
    }

    private void elementEpilogue(ElementDecl element) throws IOException, ParseException {
        if (!this.in.peek(element.name, null)) {
            this.fatal("P-034", new Object[]{element.name, new Integer(this.startLine)});
        }
        this.in.maybeWhitespace();
        this.nextChar('>', "F-027", element.name);
    }

    private void intRefEpilogue(StackElement elt) throws IOException, ParseException {
        InternalEntity entity = (InternalEntity)elt.entity;
        InputEntity last = elt.in;
        if (this.in != last && !this.in.isEOF()) {
            while (this.in.isInternal()) {
                this.in = this.in.pop();
            }
            this.fatal("P-052", new Object[]{entity.name});
        }
        this.in = this.in.pop();
    }

    private void extRefEpilogue(StackElement elt) throws IOException, ParseException {
        ExternalEntity entity = (ExternalEntity)elt.entity;
        if (!this.in.isEOF()) {
            this.fatal("P-058", new Object[]{entity.name});
        }
        this.in = this.in.pop();
    }

    private boolean maybePI(boolean skipStart) throws IOException, ParseException {
        boolean savedLexicalPE = this.doLexicalPE;
        if (!this.in.peek(skipStart ? "?" : "<?", null)) {
            return false;
        }
        this.doLexicalPE = false;
        String target = this.maybeGetName();
        String piContent = null;
        if (target == null) {
            this.fatal("P-018");
        }
        if ("xml".equals(target)) {
            this.fatal("P-019");
        }
        if ("xml".equalsIgnoreCase(target)) {
            this.fatal("P-020", new Object[]{target});
        }
        if (this.maybeWhitespace()) {
            this.strTmp = new StringBuffer();
            try {
                char c;
                while ((c = this.in.getc()) != '?' || !this.in.peekc('>')) {
                    this.strTmp.append(c);
                }
            }
            catch (EndOfInputException e) {
                this.fatal("P-021");
            }
            piContent = this.strTmp.toString();
        } else {
            if (!this.in.peek("?>", null)) {
                this.fatal("P-022");
            }
            piContent = "";
        }
        this.doLexicalPE = savedLexicalPE;
        this.piQueue.in(target, piContent);
        return true;
    }

    private void processStartElement(ElementDecl elt) throws IOException, ParseException {
        String attRawName;
        int i;
        this.ns.pushContext();
        boolean seenDecl = false;
        int length = this.attr.getLength();
        for (i = 0; i < length; ++i) {
            attRawName = this.attr.getQName(i);
            String value = this.attr.getValue(i);
            boolean isNamespaceDecl = false;
            String prefix = "";
            if (attRawName.startsWith("xmlns")) {
                isNamespaceDecl = true;
                if (attRawName.length() != 5) {
                    if (attRawName.charAt(5) == ':') {
                        prefix = attRawName.substring(6);
                    } else {
                        isNamespaceDecl = false;
                    }
                }
            }
            if (isNamespaceDecl) {
                if (!this.ns.declarePrefix(prefix, value)) {
                    this.fatal("Illegal Namespace prefix: " + prefix);
                }
                seenDecl = true;
                this.attr.setURI(i, XMLNS_NAMESPACE_URI);
                continue;
            }
            String[] attName = this.ns.processName(attRawName, this.parts, true);
            if (attName == null) continue;
            this.attr.setURI(i, attName[0]);
            this.attr.setLocalName(i, attName[1]);
        }
        if (seenDecl) {
            length = this.attr.getLength();
            for (i = 0; i < length; ++i) {
                String[] attName;
                attRawName = this.attr.getQName(i);
                if (attRawName.startsWith("xmlns") && (attRawName.length() == 5 || attRawName.charAt(5) == ':') || (attName = this.ns.processName(attRawName, this.parts, true)) == null) continue;
                this.attr.setURI(i, attName[0]);
                this.attr.setLocalName(i, attName[1]);
            }
        }
        this.getSetCurName(elt.name, false);
        this.curValue = null;
    }

    private void processEndElement(ElementDecl elt) throws IOException, ParseException {
        this.getSetCurName(elt.name, false);
        this.ns.popContext();
    }

    private void getSetCurName(String rawName, boolean isAttribute) throws ParseException {
        String[] names = this.ns.processName(rawName, this.parts, isAttribute);
        if (names == null) {
            this.fatal("P-084", new Object[]{rawName});
        }
        this.curURI = names[0];
        this.curName = names[1];
        this.curValue = null;
    }

    private int parseContent() throws IOException, ParseException {
        ElementDecl elt = null;
        block4: while (true) {
            if (this.stack.empty()) {
                if (!this.startEmptyStack) {
                    return 10;
                }
                if (this.startEmptyStack && (!this.in.peekc('<') || (elt = this.getElement()) == null)) {
                    this.fatal("P-067");
                    continue;
                }
                this.startEmptyStack = false;
                this.stack.push(this.newStackElement(2, 256, elt, null, null));
                if (!this.haveAttributes && this.hasContent) {
                    this.stack.push(this.newStackElement(4, 1024, elt, null, null));
                }
                if (!this.namespace) {
                    this.curName = elt.name;
                    this.curValue = null;
                } else {
                    this.processStartElement(elt);
                }
                return 1;
            }
            StackElement se = this.stack.pop();
            elt = se.elt;
            switch (se.curState) {
                case 256: {
                    if (this.attr == null) {
                        this.fatal("P-082");
                    }
                    if (this.haveAttributes) {
                        this.attr = null;
                        this.attrIndex = 0;
                        this.attTmp.clear();
                        this.haveAttributes = false;
                    }
                    if (this.hasContent) {
                        this.stack.push(se);
                        this.stack.push(this.newStackElement(4, 1024, elt, null, null));
                        break;
                    }
                    this.hasContent = true;
                    this.nextChar('>', "F-027", elt.name);
                    this.freeStackElement(se);
                    this.curName = elt.name;
                    if (!this.namespace) {
                        this.curValue = null;
                    } else {
                        this.processEndElement(elt);
                    }
                    return 2;
                }
                case 1024: {
                    ElementDecl e2 = null;
                    StackElement se2 = null;
                    String chars = null;
                    if (this.in.peekc('<')) {
                        e2 = this.getElement();
                        if (e2 != null) {
                            this.stack.push(se);
                            this.stack.push(this.newStackElement(1, 256, e2, null, null));
                            if (!this.haveAttributes && this.hasContent) {
                                this.stack.push(this.newStackElement(4, 1024, e2, null, null));
                            }
                            if (!this.namespace) {
                                this.curName = e2.name;
                                this.curValue = null;
                            } else {
                                this.processStartElement(e2);
                            }
                            return 1;
                        }
                        if (!this.in.peekc('/')) {
                            if (this.maybeComment(true)) {
                                this.stack.push(se);
                                break;
                            }
                            if (this.maybePI(true)) {
                                this.stack.push(se);
                                this.curName = this.piQueue.getNextTarget();
                                this.curValue = this.piQueue.getNextContent();
                                return 4;
                            }
                            chars = this.in.getUnparsedContent(elt != null && elt.ignoreWhitespace, null);
                            if (chars != null) {
                                this.stack.push(se);
                                if (chars.length() == 0) continue block4;
                                this.curName = null;
                                this.curValue = chars;
                                return 3;
                            }
                            char c = this.getc();
                            this.fatal("P-079", new Object[]{Integer.toHexString(c), new Character(c)});
                        }
                    } else {
                        if (elt != null && elt.ignoreWhitespace && this.in.ignorableWhitespace()) {
                            this.stack.push(se);
                            break;
                        }
                        chars = this.in.getParsedContent(this.coalescing);
                        if (chars != null) {
                            this.stack.push(se);
                            if (chars.length() == 0) continue block4;
                            this.curName = null;
                            this.curValue = chars;
                            return 3;
                        }
                        if (this.in.isEOF()) {
                            if (se.origState == 4) {
                                this.fatal("P-035");
                            }
                        } else if (this.maybeReferenceInContent()) {
                            if (this.maybeEntityReference()) {
                                EntityDecl e;
                                this.stack.push(se);
                                Object entity = this.getEntityReference();
                                InputEntity last = this.in;
                                if (entity instanceof InternalEntity) {
                                    e = (InternalEntity)entity;
                                    this.stack.push(this.newStackElement(8, 1024, elt, e, last));
                                    this.pushReader(e.buf, e.name, true);
                                    break;
                                }
                                if (entity instanceof ExternalEntity) {
                                    e = (ExternalEntity)entity;
                                    if (((ExternalEntity)e).notation != null) {
                                        this.fatal("P-053", new Object[]{((ExternalEntity)e).name});
                                    }
                                    if (!this.pushReader((ExternalEntity)e)) continue block4;
                                    this.maybeTextDecl();
                                    this.stack.push(this.newStackElement(16, 1024, elt, e, null));
                                    break;
                                }
                                throw new InternalError();
                            }
                            this.stack.push(se);
                            int ret = this.surrogatesToCharTmp(this.parseCharNumber());
                            this.curName = null;
                            this.curValue = new String(this.charTmp, 0, ret);
                            return 3;
                        }
                    }
                    if (se.origState == 4) {
                        se2 = this.stack.pop();
                        if (se2.curState != 256) {
                            this.fatal("P-083");
                        }
                        this.elementEpilogue(elt);
                        this.curName = elt.name;
                        if (!this.namespace) {
                            this.curValue = null;
                        } else {
                            this.processEndElement(elt);
                        }
                        this.freeStackElement(se);
                        this.freeStackElement(se2);
                        return 2;
                    }
                    if (se.origState == 8) {
                        this.intRefEpilogue(se);
                        this.freeStackElement(se);
                        break;
                    }
                    if (se.origState != 16) continue block4;
                    this.extRefEpilogue(se);
                    this.freeStackElement(se);
                    break;
                }
                default: {
                    this.fatal("P-083");
                }
            }
        }
    }

    private StackElement newStackElement(int origState, int curState, ElementDecl elt, EntityDecl entity, InputEntity in) {
        return new StackElement(origState, curState, elt, entity, in);
    }

    private void freeStackElement(StackElement e) {
    }

    private void err(String msg) {
    }

    private void debug() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class PIQueue {
        private String[] pi;
        private int size = 0;
        private int index = 0;

        public PIQueue(int initialCapacity) {
            this.pi = new String[2 * initialCapacity];
        }

        public boolean empty() {
            return this.size == this.index;
        }

        public void clear() {
            this.size = 0;
        }

        public void in(String target, String content) {
            this.ensureCapacity();
            this.pi[this.size++] = target;
            this.pi[this.size++] = content;
        }

        public String getNextTarget() {
            String result = null;
            if (this.index < this.size) {
                result = this.pi[this.index];
                this.pi[this.index++] = null;
            }
            return result;
        }

        public String getNextContent() {
            String result = null;
            if (this.index < this.size) {
                result = this.pi[this.index];
                this.pi[this.index++] = null;
            }
            return result;
        }

        private void ensureCapacity() {
            if (this.pi.length == this.size) {
                String[] oldPi = this.pi;
                this.pi = new String[2 * this.pi.length + 2];
                System.arraycopy(oldPi, 0, this.pi, 0, this.size);
            }
        }
    }

    private final class StackElement {
        int origState;
        int curState;
        ElementDecl elt;
        EntityDecl entity;
        InputEntity in;
        StackElement next;

        public StackElement(int origState, int curState, ElementDecl elt, EntityDecl entity, InputEntity in) {
            this.origState = origState;
            this.curState = curState;
            this.elt = elt;
            this.entity = entity;
            this.in = in;
        }
    }

    private final class FastStack {
        private StackElement first;

        public FastStack(int initialCapacity) {
        }

        public boolean empty() {
            return this.first == null;
        }

        public void push(StackElement e) {
            if (this.first == null) {
                this.first = e;
            } else {
                e.next = this.first;
                this.first = e;
            }
        }

        public StackElement pop() {
            StackElement result = this.first;
            this.first = this.first.next;
            result.next = null;
            return result;
        }

        public void clear() {
            this.first = null;
        }
    }

    static final class Catalog
    extends MessageCatalog {
        Catalog() {
            super(class$com$nec$webotx$webservice$xml$rpc$sp$Parser == null ? (class$com$nec$webotx$webservice$xml$rpc$sp$Parser = Parser2.class$("com.nec.webotx.webservice.xml.rpc.sp.Parser")) : class$com$nec$webotx$webservice$xml$rpc$sp$Parser);
        }
    }

    static final class NameCacheEntry {
        String name;
        char[] chars;
        NameCacheEntry next;

        NameCacheEntry() {
        }

        boolean matches(char[] value, int len) {
            if (this.chars.length != len) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (value[i] == this.chars[i]) continue;
                return false;
            }
            return true;
        }
    }

    static final class NameCache {
        NameCacheEntry[] hashtable = new NameCacheEntry[541];

        NameCache() {
        }

        String lookup(char[] value, int len) {
            return this.lookupEntry((char[])value, (int)len).name;
        }

        NameCacheEntry lookupEntry(char[] value, int len) {
            int index = 0;
            for (int i = 0; i < len; ++i) {
                index = index * 31 + value[i];
            }
            index &= Integer.MAX_VALUE;
            NameCacheEntry entry = this.hashtable[index %= this.hashtable.length];
            while (entry != null) {
                if (entry.matches(value, len)) {
                    return entry;
                }
                entry = entry.next;
            }
            entry = new NameCacheEntry();
            entry.chars = new char[len];
            System.arraycopy(value, 0, entry.chars, 0, len);
            entry.name = new String(entry.chars);
            entry.name = entry.name.intern();
            entry.next = this.hashtable[index];
            this.hashtable[index] = entry;
            return entry;
        }
    }

    class DocLocator
    implements Locator {
        DocLocator() {
        }

        public String getPublicId() {
            return Parser2.this.in == null ? null : Parser2.this.in.getPublicId();
        }

        public String getSystemId() {
            return Parser2.this.in == null ? null : Parser2.this.in.getSystemId();
        }

        public int getLineNumber() {
            return Parser2.this.in == null ? -1 : Parser2.this.in.getLineNumber();
        }

        public int getColumnNumber() {
            return Parser2.this.in == null ? -1 : Parser2.this.in.getColumnNumber();
        }
    }
}

