/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding.literal;

import com.nec.webotx.webservice.xml.rpc.encoding.DeserializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.DynamicInternalTypeMappingRegistry;
import com.nec.webotx.webservice.xml.rpc.encoding.literal.GenericLiteralObjectSerializer;
import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class ValueTypeLiteralSerializer
extends GenericLiteralObjectSerializer {
    protected String memberNamespace = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public ValueTypeLiteralSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        super(type != null ? type : new QName(""), encodeType, isNullable, encodingStyle);
    }

    public ValueTypeLiteralSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, Collection params) {
        super(type != null ? type : new QName(""), encodeType, isNullable, encodingStyle);
        this.memberOrder = params;
    }

    public ValueTypeLiteralSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, Class targetClass) {
        this(type, encodeType, isNullable, encodingStyle);
        super.setTargetClass(targetClass);
    }

    public ValueTypeLiteralSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, Class targetClass, String memberNamespace) {
        this(type, encodeType, isNullable, encodingStyle, targetClass);
        this.memberNamespace = memberNamespace;
    }

    public ValueTypeLiteralSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, Class targetClass, Collection paramOrder) {
        this(type, encodeType, isNullable, encodingStyle, paramOrder);
        super.setTargetClass(targetClass);
    }

    protected void doSetTargetClass(Class targetClass) {
        try {
            this.introspectTargetClass(targetClass);
            this.reflectTargetClass(targetClass);
        }
        catch (Exception e) {
            throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
        }
    }

    protected void introspectTargetClass(Class targetClass) throws Exception {
        BeanInfo beanInfoForTarget = Introspector.getBeanInfo(targetClass);
        PropertyDescriptor[] targetProperties = beanInfoForTarget.getPropertyDescriptors();
        targetProperties = this.membersByParameterOrder(targetProperties);
        for (int i = 0; i < targetProperties.length; ++i) {
            final Method getterMethod = targetProperties[i].getReadMethod();
            final Method setterMethod = targetProperties[i].getWriteMethod();
            if (getterMethod == null || setterMethod == null) continue;
            GenericLiteralObjectSerializer.MemberInfo member = new GenericLiteralObjectSerializer.MemberInfo();
            member.name = new QName(this.memberNamespace, targetProperties[i].getName());
            Class<?> baseJavaType = targetProperties[i].getPropertyType();
            member.javaType = ValueTypeLiteralSerializer.getBoxedClassFor(baseJavaType);
            member.xmlType = (QName)this.javaToXmlType.get(baseJavaType);
            if (DynamicInternalTypeMappingRegistry.isValueType(member.javaType) && member.xmlType == null) {
                member.xmlType = member.name;
            }
            member.getter = new GenericLiteralObjectSerializer.GetterMethod(){

                public Object get(Object instance) throws Exception {
                    return getterMethod.invoke(instance, new Object[0]);
                }
            };
            member.setter = new GenericLiteralObjectSerializer.SetterMethod(){

                public void set(Object instance, Object value) throws Exception {
                    setterMethod.invoke(instance, value);
                }
            };
            super.addMember(member);
        }
    }

    protected void reflectTargetClass(Class targetClass) throws Exception {
        Field[] targetFields = targetClass.getFields();
        for (int i = 0; i < targetFields.length; ++i) {
            final Field currentField = targetFields[i];
            int fieldModifiers = currentField.getModifiers();
            if (!Modifier.isPublic(fieldModifiers) || Modifier.isTransient(fieldModifiers) || Modifier.isFinal(fieldModifiers)) continue;
            GenericLiteralObjectSerializer.MemberInfo member = new GenericLiteralObjectSerializer.MemberInfo();
            member.name = new QName(this.memberNamespace, currentField.getName());
            Class<?> baseJavaType = targetFields[i].getType();
            member.javaType = ValueTypeLiteralSerializer.getBoxedClassFor(baseJavaType);
            member.xmlType = (QName)this.javaToXmlType.get(baseJavaType);
            member.getter = new GenericLiteralObjectSerializer.GetterMethod(){

                public Object get(Object instance) throws Exception {
                    Field field = currentField;
                    return field.get(instance);
                }
            };
            member.setter = new GenericLiteralObjectSerializer.SetterMethod(){

                public void set(Object instance, Object value) throws Exception {
                    Field field = currentField;
                    field.set(instance, value);
                }
            };
            super.addMember(member);
        }
    }

    private PropertyDescriptor[] membersByParameterOrder(PropertyDescriptor[] targetProperties) {
        if (targetProperties == null) {
            return null;
        }
        if (this.memberOrder == null || this.memberOrder.size() == 0) {
            return targetProperties;
        }
        ArrayList<PropertyDescriptor> members = new ArrayList<PropertyDescriptor>();
        Iterator namesIter = this.memberOrder.iterator();
        while (namesIter.hasNext()) {
            String name = (String)namesIter.next();
            for (int j = 0; j < targetProperties.length; ++j) {
                String propertyName = targetProperties[j].getName();
                if (!propertyName.equalsIgnoreCase(name)) continue;
                members.add(targetProperties[j]);
            }
        }
        if (members.size() == 0) {
            return targetProperties;
        }
        return members.toArray(new PropertyDescriptor[members.size()]);
    }

    private static Class getBoxedClassFor(Class possiblePrimitiveType) {
        if (!possiblePrimitiveType.isPrimitive()) {
            return possiblePrimitiveType;
        }
        if (possiblePrimitiveType == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValueTypeLiteralSerializer.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (possiblePrimitiveType == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = ValueTypeLiteralSerializer.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (possiblePrimitiveType == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = ValueTypeLiteralSerializer.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (possiblePrimitiveType == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = ValueTypeLiteralSerializer.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (possiblePrimitiveType == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = ValueTypeLiteralSerializer.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (possiblePrimitiveType == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = ValueTypeLiteralSerializer.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (possiblePrimitiveType == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = ValueTypeLiteralSerializer.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (possiblePrimitiveType == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = ValueTypeLiteralSerializer.class$("java.lang.Double")) : class$java$lang$Double;
        }
        return possiblePrimitiveType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

