/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorSettingException;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private Number highThreshold = new Integer(0);
    private Number lowThreshold = new Integer(0);
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private transient Number[] derivedGauge = new Number[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient Number[] previousScanGauge = new Number[16];
    private transient int[] status = new int[16];
    private transient int[] type = new int[16];
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "GaugeMonitor";
    }

    public GaugeMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the gauge monitor");
        }
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("start", "the gauge monitor is already activated");
                }
                return;
            }
            this.isActive = true;
            for (int i = 0; i < this.elementCount; ++i) {
                this.status[i] = 2;
                this.previousScanGauge[i] = null;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.trace("stop", "stop the gauge monitor");
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (!this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("stop", "the counter monitor is already started");
                }
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGranularityPeriod(long l) throws IllegalArgumentException {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            super.setGranularityPeriod(l);
            if (this.isActive()) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getDerivedGauge(ObjectName objectName) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            int n = this.indexOf(objectName);
            if (n != -1) {
                return this.derivedGauge[n];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            int n = this.indexOf(objectName);
            if (n != -1) {
                return this.derivedGaugeTimestamp[n];
            }
            return 0L;
        }
    }

    public Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public Number getHighThreshold() {
        return this.highThreshold;
    }

    public Number getLowThreshold() {
        return this.lowThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThresholds(Number number, Number number2) throws IllegalArgumentException {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("The threshold values cannot be null.");
        }
        if (number.getClass() != number2.getClass()) {
            throw new IllegalArgumentException("The high and the low thresholds must be of the same type.");
        }
        if (this.isFirstStrictlyGreaterThanLast(number2, number, number.getClass().getName())) {
            throw new IllegalArgumentException("The threshold high value must be greater than or equal to threshold low value.");
        }
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.highThreshold = number;
            this.lowThreshold = number2;
            for (int i = 0; i < this.elementCount; ++i) {
                this.resetAlreadyNotified(i, 16);
                this.status[i] = 2;
            }
        }
    }

    public boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyHigh(boolean bl) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.notifyHigh = bl;
        }
    }

    public boolean getNotifyLow() {
        return this.notifyLow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyLow(boolean bl) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.notifyLow = bl;
        }
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDifferenceMode(boolean bl) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.differenceMode = bl;
            for (int i = 0; i < this.elementCount; ++i) {
                this.status[i] = 2;
                this.previousScanGauge[i] = null;
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.gauge.high", "jmx.monitor.gauge.low"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDerivedGauge(Object object, int n) {
        boolean bl;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.derivedGaugeTimestamp[n] = System.currentTimeMillis();
            if (this.differenceMode) {
                if (this.previousScanGauge[n] != null) {
                    this.setDerivedGaugeWithDifference((Number)object, n);
                    bl = true;
                } else {
                    bl = false;
                }
                this.previousScanGauge[n] = (Number)object;
            } else {
                this.derivedGauge[n] = (Number)object;
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int n) {
        boolean bl = false;
        String string = null;
        long l = 0L;
        String string2 = null;
        Number number = null;
        Number number2 = null;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.status[n] == 2) {
                if (this.isFirstGreaterThanLast(this.derivedGauge[n], this.highThreshold, this.type[n])) {
                    if (this.notifyHigh) {
                        bl = true;
                        string = "jmx.monitor.gauge.high";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        number = this.derivedGauge[n];
                        number2 = this.highThreshold;
                    }
                    this.status[n] = 1;
                } else if (this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[n], this.type[n])) {
                    if (this.notifyLow) {
                        bl = true;
                        string = "jmx.monitor.gauge.low";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        number = this.derivedGauge[n];
                        number2 = this.lowThreshold;
                    }
                    this.status[n] = 0;
                }
            } else if (this.status[n] == 0) {
                if (this.isFirstGreaterThanLast(this.derivedGauge[n], this.highThreshold, this.type[n])) {
                    if (this.notifyHigh) {
                        bl = true;
                        string = "jmx.monitor.gauge.high";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        number = this.derivedGauge[n];
                        number2 = this.highThreshold;
                    }
                    this.status[n] = 1;
                }
            } else if (this.status[n] == 1 && this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[n], this.type[n])) {
                if (this.notifyLow) {
                    bl = true;
                    string = "jmx.monitor.gauge.low";
                    l = this.derivedGaugeTimestamp[n];
                    string2 = "";
                    number = this.derivedGauge[n];
                    number2 = this.lowThreshold;
                }
                this.status[n] = 0;
            }
        }
        if (bl) {
            this.sendNotification(string, l, string2, number, number2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isThresholdTypeValid(int n) {
        boolean bl = false;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            switch (this.type[n]) {
                case 0: {
                    if (!(this.highThreshold instanceof Integer) || !(this.lowThreshold instanceof Integer)) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if (!(this.highThreshold instanceof Byte) || !(this.lowThreshold instanceof Byte)) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!(this.highThreshold instanceof Short) || !(this.lowThreshold instanceof Short)) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (!(this.highThreshold instanceof Long) || !(this.lowThreshold instanceof Long)) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (!(this.highThreshold instanceof Float) || !(this.lowThreshold instanceof Float)) break;
                    bl = true;
                    break;
                }
                case 5: {
                    if (!(this.highThreshold instanceof Double) || !(this.lowThreshold instanceof Double)) break;
                    bl = true;
                    break;
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("isThresholdTypeValid", "the threshold type is invalid");
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDerivedGaugeWithDifference(Number number, int n) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            switch (this.type[n]) {
                case 0: {
                    this.derivedGauge[n] = new Integer((Integer)number - (Integer)this.previousScanGauge[n]);
                    break;
                }
                case 1: {
                    this.derivedGauge[n] = new Byte((byte)((Byte)number - (Byte)this.previousScanGauge[n]));
                    break;
                }
                case 2: {
                    this.derivedGauge[n] = new Short((short)((Short)number - (Short)this.previousScanGauge[n]));
                    break;
                }
                case 3: {
                    this.derivedGauge[n] = new Long((Long)number - (Long)this.previousScanGauge[n]);
                    break;
                }
                case 4: {
                    this.derivedGauge[n] = new Float(((Float)number).floatValue() - ((Float)this.previousScanGauge[n]).floatValue());
                    break;
                }
                case 5: {
                    this.derivedGauge[n] = new Double((Double)number - (Double)this.previousScanGauge[n]);
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
                }
            }
        }
    }

    private boolean isFirstGreaterThanLast(Number number, Number number2, int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (number.longValue() < number2.longValue()) break;
                bl = true;
                break;
            }
            case 4: 
            case 5: {
                if (!(number.doubleValue() >= number2.doubleValue())) break;
                bl = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isFirstGreaterThanLast", "the threshold type is invalid");
            }
        }
        return bl;
    }

    private boolean isFirstStrictlyGreaterThanLast(Number number, Number number2, String string) {
        boolean bl = false;
        if (string.equals("java.lang.Integer") || string.equals("java.lang.Byte") || string.equals("java.lang.Short") || string.equals("java.lang.Long")) {
            if (number.longValue() > number2.longValue()) {
                bl = true;
            }
        } else if (string.equals("java.lang.Float") || string.equals("java.lang.Double")) {
            if (number.doubleValue() > number2.doubleValue()) {
                bl = true;
            }
        } else if (this.isDebugOn()) {
            this.debug("isFirstStrictlyGreaterThanLast", "the threshold type is invalid");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int n) {
        boolean bl = false;
        String string = null;
        long l = 0L;
        String string2 = null;
        Number number = null;
        Object var8_7 = null;
        Object object = null;
        String string3 = null;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            block35: {
                try {
                    if (!this.isActive()) break block35;
                    if (this.getObservedObject(n) == null || this.getObservedAttribute() == null) {
                        return;
                    }
                    try {
                        object = this.server.getAttribute(this.getObservedObject(n), this.getObservedAttribute());
                        if (object == null) {
                            return;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        if ((this.alreadyNotifieds[n] & 8) != 0) {
                            return;
                        }
                        string3 = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(n, 8);
                        throw new MonitorSettingException("The gauge monitor must be registered in the MBean server.");
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        if ((this.alreadyNotifieds[n] & 1) != 0) {
                            return;
                        }
                        string3 = "jmx.monitor.error.mbean";
                        this.setAlreadyNotified(n, 1);
                        throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                    }
                    catch (AttributeNotFoundException attributeNotFoundException) {
                        if ((this.alreadyNotifieds[n] & 2) != 0) {
                            return;
                        }
                        string3 = "jmx.monitor.error.attribute";
                        this.setAlreadyNotified(n, 2);
                        throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                    }
                    catch (MBeanException mBeanException) {
                        if ((this.alreadyNotifieds[n] & 8) != 0) {
                            return;
                        }
                        string3 = "jmx.monitor.error.runtime";
                        this.setAlreadyNotified(n, 8);
                        throw new MonitorSettingException(mBeanException.getMessage());
                    }
                    catch (ReflectionException reflectionException) {
                        if ((this.alreadyNotifieds[n] & 2) != 0) {
                            return;
                        }
                        string3 = "jmx.monitor.error.attribute";
                        this.setAlreadyNotified(n, 2);
                        throw new MonitorSettingException(reflectionException.getMessage());
                    }
                    if (object instanceof Integer) {
                        this.type[n] = 0;
                    } else if (object instanceof Byte) {
                        this.type[n] = 1;
                    } else if (object instanceof Short) {
                        this.type[n] = 2;
                    } else if (object instanceof Long) {
                        this.type[n] = 3;
                    } else if (object instanceof Float) {
                        this.type[n] = 4;
                    } else if (object instanceof Double) {
                        this.type[n] = 5;
                    } else {
                        if ((this.alreadyNotifieds[n] & 4) != 0) {
                            return;
                        }
                        string3 = "jmx.monitor.error.type";
                        this.setAlreadyNotified(n, 4);
                        throw new MonitorSettingException("The observed attribute type must be an integer type or a floating-point type.");
                    }
                    if (!this.isThresholdTypeValid(n)) {
                        if ((this.alreadyNotifieds[n] & 0x10) != 0) {
                            return;
                        }
                        string3 = "jmx.monitor.error.threshold";
                        this.setAlreadyNotified(n, 16);
                        throw new MonitorSettingException("The threshold high and threshold low must be of the same type as the gauge.");
                    }
                    this.resetAllAlreadyNotified(n);
                    boolean bl2 = this.updateDerivedGauge(object, n);
                    if (bl2) {
                        this.updateNotifications(n);
                    }
                }
                catch (MonitorSettingException monitorSettingException) {
                    bl = true;
                    string = string3;
                    l = this.derivedGaugeTimestamp[n];
                    string2 = monitorSettingException.getMessage();
                    number = this.derivedGauge[n];
                    var8_7 = null;
                    this.status[n] = 2;
                    this.previousScanGauge[n] = null;
                }
            }
        }
        if (bl) {
            this.sendNotification(string, l, string2, number, var8_7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertSpecificElementAt(int n) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            Integer n2 = new Integer(0);
            this.insertNumberElementAt(this.derivedGauge, n2, n);
            this.insertNumberElementAt(this.previousScanGauge, null, n);
            this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), n);
            this.insertintElementAt(this.status, 2, n);
            this.insertintElementAt(this.type, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpecificElementAt(int n) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.removeNumberElementAt(this.derivedGauge, n);
            this.removeNumberElementAt(this.previousScanGauge, n);
            this.removelongElementAt(this.derivedGaugeTimestamp, n);
            this.removeintElementAt(this.status, n);
            this.removeintElementAt(this.type, n);
        }
    }

    private static class GaugeAlarmClock
    extends TimerTask {
        GaugeMonitor listener = null;

        public GaugeAlarmClock(GaugeMonitor gaugeMonitor) {
            this.listener = gaugeMonitor;
        }

        public void run() {
            if (this.listener.isActive()) {
                for (int i = 0; i < this.listener.elementCount; ++i) {
                    this.listener.notifyAlarmClock(i);
                }
            }
        }
    }
}

