/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMultipart
extends Multipart {
    protected DataSource ds = null;
    protected boolean parsed = true;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String subtype) {
        String boundary = UniqueValue.getUniqueBoundaryValue();
        ContentType cType = new ContentType("multipart", subtype, null);
        cType.setParameter("boundary", boundary);
        this.contentType = cType.toString();
    }

    public MimeMultipart(DataSource ds) throws MessagingException {
        if (ds instanceof MessageAware) {
            MessageContext mc = ((MessageAware)((Object)ds)).getMessageContext();
            this.setParent(mc.getPart());
        }
        if (ds instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)ds);
            return;
        }
        this.parsed = false;
        this.ds = ds;
        this.contentType = ds.getContentType();
    }

    public synchronized void setSubType(String subtype) throws MessagingException {
        ContentType cType = new ContentType(this.contentType);
        cType.setSubType(subtype);
        this.contentType = cType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int index) throws MessagingException {
        this.parse();
        return super.getBodyPart(index);
    }

    public synchronized BodyPart getBodyPart(String CID) throws MessagingException {
        this.parse();
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            MimeBodyPart part = (MimeBodyPart)this.getBodyPart(i);
            String s = part.getContentID();
            if (s == null || !s.equals(CID)) continue;
            return part;
        }
        return null;
    }

    protected void updateHeaders() throws MessagingException {
        for (int i = 0; i < this.parts.size(); ++i) {
            ((MimeBodyPart)this.parts.elementAt(i)).updateHeaders();
        }
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        this.parse();
        String boundary = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream los = new LineOutputStream(os);
        for (int i = 0; i < this.parts.size(); ++i) {
            los.writeln(boundary);
            ((MimeBodyPart)this.parts.elementAt(i)).writeTo(os);
            los.writeln();
        }
        los.writeln(boundary + "--");
    }

    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        InputStream in = null;
        SharedInputStream sin = null;
        long start = 0L;
        long end = 0L;
        try {
            in = this.ds.getInputStream();
            if (!(in instanceof ByteArrayInputStream || in instanceof BufferedInputStream || in instanceof SharedInputStream)) {
                in = new BufferedInputStream(in);
            }
        }
        catch (Exception ex) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (in instanceof SharedInputStream) {
            sin = (SharedInputStream)((Object)in);
        }
        ContentType cType = new ContentType(this.contentType);
        String boundary = "--" + cType.getParameter("boundary");
        byte[] bndbytes = ASCIIUtility.getBytes((String)boundary);
        int bl = bndbytes.length;
        try {
            String line;
            LineInputStream lin = new LineInputStream(in);
            while ((line = lin.readLine()) != null) {
                char c;
                int i;
                for (i = line.length() - 1; i >= 0 && ((c = line.charAt(i)) == ' ' || c == '\t'); --i) {
                }
                if (!(line = line.substring(0, i + 1)).equals(boundary)) continue;
                break;
            }
            if (line == null) {
                throw new MessagingException("Missing start boundary");
            }
            boolean done = false;
            while (!done) {
                InternetHeaders headers = null;
                if (sin != null) {
                    start = sin.getPosition();
                    while ((line = lin.readLine()) != null && line.length() > 0) {
                    }
                    if (line == null) {
                        break;
                    }
                } else {
                    headers = this.createInternetHeaders(in);
                }
                if (!in.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                ByteArrayOutputStream buf = null;
                if (sin == null) {
                    buf = new ByteArrayOutputStream();
                }
                boolean bol = true;
                int eol1 = -1;
                int eol2 = -1;
                while (true) {
                    int b;
                    if (bol) {
                        int i;
                        in.mark(bl + 4 + 1000);
                        for (i = 0; i < bl && in.read() == bndbytes[i]; ++i) {
                        }
                        if (i == bl) {
                            int b2 = in.read();
                            if (b2 == 45 && in.read() == 45) {
                                done = true;
                                break;
                            }
                            while (b2 == 32 || b2 == 9) {
                                b2 = in.read();
                            }
                            if (b2 == 10) break;
                            if (b2 == 13) {
                                in.mark(1);
                                if (in.read() == 10) break;
                                in.reset();
                                break;
                            }
                        }
                        in.reset();
                        if (buf != null && eol1 != -1) {
                            buf.write(eol1);
                            if (eol2 != -1) {
                                buf.write(eol2);
                            }
                            eol2 = -1;
                            eol1 = -1;
                        }
                    }
                    if ((b = in.read()) < 0) {
                        done = true;
                        break;
                    }
                    if (b == 13 || b == 10) {
                        bol = true;
                        if (sin != null) {
                            end = sin.getPosition() - 1L;
                        }
                        eol1 = b;
                        if (b != 13) continue;
                        in.mark(1);
                        b = in.read();
                        if (b == 10) {
                            eol2 = b;
                            continue;
                        }
                        in.reset();
                        continue;
                    }
                    bol = false;
                    if (buf == null) continue;
                    buf.write(b);
                }
                MimeBodyPart part = sin != null ? this.createMimeBodyPart(sin.newStream(start, end)) : this.createMimeBodyPart(headers, buf.toByteArray());
                this.addBodyPart(part);
            }
        }
        catch (IOException ioex) {
            throw new MessagingException("IO Error", ioex);
        }
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream is) throws MessagingException {
        return new InternetHeaders(is);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        return new MimeBodyPart(headers, content);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream is) throws MessagingException {
        return new MimeBodyPart(is);
    }
}

