/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd.datetime;

import com.sun.msv.datatype.xsd.datetime.ASCII_CharStream;
import com.sun.msv.datatype.xsd.datetime.DateTimeFactory;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ISO8601ParserConstants;
import com.sun.msv.datatype.xsd.datetime.ISO8601ParserTokenManager;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.ParseException;
import com.sun.msv.datatype.xsd.datetime.TimeDurationFactory;
import com.sun.msv.datatype.xsd.datetime.TimeZone;
import com.sun.msv.datatype.xsd.datetime.Token;
import com.sun.msv.datatype.xsd.datetime.Util;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ISO8601Parser
implements ISO8601ParserConstants {
    Number yy;
    Number mm;
    Number dd;
    Number HH;
    Number MM;
    Number mSecond;
    TimeZone zone;
    private static final String[] trail = new String[]{"000", "00", "0", ""};
    public ISO8601ParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;

    public static void main(String[] args) throws Exception {
        String s = new BufferedReader(new InputStreamReader(System.in)).readLine();
        new ISO8601Parser(new StringReader(s)).dateTypeL();
    }

    private void reset() {
        this.mSecond = null;
        this.MM = null;
        this.HH = null;
        this.dd = null;
        this.mm = null;
        this.yy = null;
        this.zone = null;
    }

    public final void secondL() throws ParseException {
        this.NN(0, 59);
        if (this.jj_2_1(3)) {
            this.jj_consume_token(3);
            this.jj_consume_token(2);
        }
    }

    public final void secondV() throws ParseException {
        Token t2 = null;
        int ss = this.NN(0, 59);
        if (this.jj_2_2(3)) {
            this.jj_consume_token(3);
            t2 = this.jj_consume_token(2);
        }
        if (t2 == null) {
            this.mSecond = new Integer(ss * 1000);
            return;
        }
        if (t2.image.length() < 4) {
            int v = Integer.parseInt(t2.image + trail[t2.image.length()]);
            this.mSecond = new Integer(ss * 1000 + v);
            return;
        }
        this.mSecond = new BigDecimal(ss + "." + t2.image).movePointRight(3);
    }

    public final void durationTypeL() throws ParseException {
        if (this.jj_2_3(3)) {
            this.jj_consume_token(4);
        }
        this.jj_consume_token(5);
        if (this.jj_2_5(3)) {
            this.datePartL();
            if (this.jj_2_4(3)) {
                this.jj_consume_token(6);
                this.timePartL();
            }
        } else if (this.jj_2_6(3)) {
            this.jj_consume_token(6);
            this.timePartL();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
    }

    public final ITimeDurationValueType durationTypeV() throws ParseException {
        boolean neg = false;
        if (this.jj_2_7(3)) {
            this.jj_consume_token(4);
            neg = true;
        }
        this.jj_consume_token(5);
        if (this.jj_2_9(3)) {
            this.datePartV(neg);
            if (this.jj_2_8(3)) {
                this.jj_consume_token(6);
                this.timePartV(neg);
            }
        } else if (this.jj_2_10(3)) {
            this.jj_consume_token(6);
            this.timePartV(neg);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
        return TimeDurationFactory.create(this.yy, this.mm, this.dd, this.HH, this.MM, this.mSecond);
    }

    public final void datePartL() throws ParseException {
        if (this.jj_2_14(3)) {
            this.jj_consume_token(2);
            this.jj_consume_token(7);
            if (this.jj_2_11(3)) {
                this.jj_consume_token(2);
                this.jj_consume_token(8);
            }
            if (this.jj_2_12(3)) {
                this.jj_consume_token(2);
                this.jj_consume_token(9);
            }
        } else if (this.jj_2_15(3)) {
            this.jj_consume_token(2);
            this.jj_consume_token(8);
            if (this.jj_2_13(3)) {
                this.jj_consume_token(2);
                this.jj_consume_token(9);
            }
        } else if (this.jj_2_16(3)) {
            this.jj_consume_token(2);
            this.jj_consume_token(9);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void datePartV(boolean neg) throws ParseException {
        if (this.jj_2_20(3)) {
            this.yy = this.intDigits(neg);
            this.jj_consume_token(7);
            if (this.jj_2_17(3)) {
                this.mm = this.intDigits(neg);
                this.jj_consume_token(8);
            }
            if (this.jj_2_18(3)) {
                this.dd = this.intDigits(neg);
                this.jj_consume_token(9);
            }
        } else if (this.jj_2_21(3)) {
            this.mm = this.intDigits(neg);
            this.jj_consume_token(8);
            if (this.jj_2_19(3)) {
                this.dd = this.intDigits(neg);
                this.jj_consume_token(9);
            }
        } else if (this.jj_2_22(3)) {
            this.dd = this.intDigits(neg);
            this.jj_consume_token(9);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void timePartL() throws ParseException {
        if (this.jj_2_29(3)) {
            this.jj_consume_token(2);
            this.jj_consume_token(10);
            if (this.jj_2_23(3)) {
                this.jj_consume_token(2);
                this.jj_consume_token(8);
            }
            if (this.jj_2_25(3)) {
                this.jj_consume_token(2);
                if (this.jj_2_24(3)) {
                    this.jj_consume_token(3);
                    this.jj_consume_token(2);
                }
                this.jj_consume_token(11);
            }
        } else if (this.jj_2_30(3)) {
            this.jj_consume_token(2);
            this.jj_consume_token(8);
            if (this.jj_2_27(3)) {
                this.jj_consume_token(2);
                if (this.jj_2_26(3)) {
                    this.jj_consume_token(3);
                    this.jj_consume_token(2);
                }
                this.jj_consume_token(11);
            }
        } else if (this.jj_2_31(3)) {
            this.jj_consume_token(2);
            if (this.jj_2_28(3)) {
                this.jj_consume_token(3);
                this.jj_consume_token(2);
            }
            this.jj_consume_token(11);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void timePartV(boolean neg) throws ParseException {
        if (this.jj_2_35(3)) {
            this.HH = this.intDigits(neg);
            this.jj_consume_token(10);
            if (this.jj_2_32(3)) {
                this.MM = this.intDigits(neg);
                this.jj_consume_token(8);
            }
            if (this.jj_2_33(3)) {
                this.decimalDigits(neg);
                this.jj_consume_token(11);
            }
        } else if (this.jj_2_36(3)) {
            this.MM = this.intDigits(neg);
            this.jj_consume_token(8);
            if (this.jj_2_34(3)) {
                this.decimalDigits(neg);
                this.jj_consume_token(11);
            }
        } else if (this.jj_2_37(3)) {
            this.decimalDigits(neg);
            this.jj_consume_token(11);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final Number intDigits(boolean neg) throws ParseException {
        Token v = this.jj_consume_token(2);
        try {
            int i = Integer.parseInt(v.image);
            if (neg) {
                i = -i;
            }
            return new Integer(i);
        }
        catch (NumberFormatException e) {
            try {
                BigInteger bi = new BigInteger(v.image);
                if (neg) {
                    bi = bi.negate();
                }
                return bi;
            }
            catch (NumberFormatException ee) {
                throw new ParseException();
            }
        }
    }

    public final void decimalDigits(boolean neg) throws ParseException {
        Token t2 = null;
        Token t1 = this.jj_consume_token(2);
        if (this.jj_2_38(3)) {
            this.jj_consume_token(3);
            t2 = this.jj_consume_token(2);
        }
        String header = neg ? "-" : "";
        try {
            if (t2 == null) {
                this.mSecond = new Integer(header + t1.image + "000");
                return;
            }
            if (t2.image.length() < 4) {
                this.mSecond = new Integer(header + t1.image + t2.image + trail[t2.image.length()]);
                return;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.mSecond = new BigDecimal(t1.image + "." + t2.image).movePointRight(3);
    }

    public final int NN(int min, int max) throws ParseException {
        Token v = this.jj_consume_token(2);
        if (v.image.length() != 2) {
            throw new ParseException();
        }
        int r = Integer.parseInt(v.image);
        if (r > max) {
            throw new ParseException();
        }
        if (r < min) {
            throw new ParseException();
        }
        return r;
    }

    public final void timeZoneModifierL() throws ParseException {
        int m = 0;
        if (this.jj_2_41(3)) {
            this.jj_consume_token(12);
        } else if (this.jj_2_42(3)) {
            if (this.jj_2_39(3)) {
                this.jj_consume_token(13);
            } else if (this.jj_2_40(3)) {
                this.jj_consume_token(4);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            int h = this.NN(0, 14);
            this.jj_consume_token(14);
            m = this.NN(0, 59);
            if (h == 14 && m != 0) {
                throw new ParseException();
            }
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void timeZoneModifierV() throws ParseException {
        int m = 0;
        if (this.jj_2_45(3)) {
            this.jj_consume_token(12);
            this.zone = TimeZone.ZERO;
        } else if (this.jj_2_46(3)) {
            int sign;
            if (this.jj_2_43(3)) {
                this.jj_consume_token(13);
                sign = 1;
            } else if (this.jj_2_44(3)) {
                this.jj_consume_token(4);
                sign = -1;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            int h = this.NN(0, 14);
            this.jj_consume_token(14);
            m = this.NN(0, 59);
            if (h == 14 && m != 0) {
                throw new ParseException();
            }
            this.zone = TimeZone.create(sign * (h * 60 + m));
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void timeL() throws ParseException {
        this.NN(0, 24);
        this.jj_consume_token(14);
        this.NN(0, 59);
        this.jj_consume_token(14);
        this.secondL();
    }

    public final void timeV() throws ParseException {
        int h = this.NN(0, 23);
        this.jj_consume_token(14);
        int m = this.NN(0, 59);
        this.jj_consume_token(14);
        this.secondV();
        this.HH = new Integer(h);
        this.MM = new Integer(m);
    }

    public final int yearL() throws ParseException {
        if (this.jj_2_49(3)) {
            if (this.jj_2_47(3)) {
                this.jj_consume_token(13);
            } else if (this.jj_2_48(3)) {
                this.jj_consume_token(4);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token v = this.jj_consume_token(2);
        int length = v.image.length();
        if (length < 4 || v.image.equals("0000")) {
            throw new ParseException();
        }
        if (length > 4 && v.image.charAt(0) == '0') {
            throw new ParseException();
        }
        return Integer.parseInt(v.image.substring(length - 4));
    }

    public final void yearV() throws ParseException {
        boolean neg = false;
        if (this.jj_2_52(3)) {
            if (this.jj_2_50(3)) {
                this.jj_consume_token(13);
            } else if (this.jj_2_51(3)) {
                this.jj_consume_token(4);
                neg = true;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token v = this.jj_consume_token(2);
        int length = v.image.length();
        if (length < 4) {
            throw new ParseException();
        }
        if (length > 4 && v.image.charAt(0) == '0') {
            throw new ParseException();
        }
        try {
            int i = Integer.parseInt(v.image);
            if (i == 0) {
                throw new ParseException();
            }
            if (neg) {
                i = -i + 1;
            }
            this.yy = new Integer(i);
        }
        catch (NumberFormatException e) {
            try {
                BigInteger bi = new BigInteger(v.image);
                if (neg) {
                    bi = bi.negate().add(BigInteger.ONE);
                }
                this.yy = bi;
            }
            catch (NumberFormatException ee) {
                throw new ParseException();
            }
        }
    }

    public final void month() throws ParseException {
        int m = this.NN(1, 12);
        this.mm = new Integer(m - 1);
    }

    public final void day() throws ParseException {
        int d = this.NN(1, 31);
        this.dd = new Integer(d - 1);
    }

    public final void dateL() throws ParseException {
        int tail4 = this.yearL();
        this.jj_consume_token(4);
        this.month();
        this.jj_consume_token(4);
        this.day();
        if (this.dd.intValue() >= Util.maximumDayInMonthFor(tail4, this.mm.intValue())) {
            throw new ParseException();
        }
    }

    public final void dateV() throws ParseException {
        this.yearV();
        this.jj_consume_token(4);
        this.month();
        this.jj_consume_token(4);
        this.day();
        if (this.yy instanceof BigInteger && this.dd.intValue() >= Util.maximumDayInMonthFor((BigInteger)this.yy, this.mm.intValue()) || this.yy instanceof Integer && this.dd.intValue() >= Util.maximumDayInMonthFor(this.yy.intValue(), this.mm.intValue())) {
            throw new ParseException();
        }
    }

    public final void dateTimeTypeL() throws ParseException {
        this.dateL();
        this.jj_consume_token(6);
        this.timeL();
        if (this.jj_2_53(3)) {
            this.timeZoneModifierL();
        }
        this.jj_consume_token(0);
    }

    public final IDateTimeValueType dateTimeTypeV() throws ParseException {
        this.dateV();
        this.jj_consume_token(6);
        this.timeV();
        if (this.jj_2_54(3)) {
            this.timeZoneModifierV();
        }
        this.jj_consume_token(0);
        return DateTimeFactory.createFromDateTime(this.yy, (Integer)this.mm, (Integer)this.dd, (Integer)this.HH, (Integer)this.MM, this.mSecond, this.zone);
    }

    public final void timeTypeL() throws ParseException {
        this.timeL();
        if (this.jj_2_55(3)) {
            this.timeZoneModifierL();
        }
        this.jj_consume_token(0);
    }

    public final IDateTimeValueType timeTypeV() throws ParseException {
        this.timeV();
        if (this.jj_2_56(3)) {
            this.timeZoneModifierV();
        }
        this.jj_consume_token(0);
        return DateTimeFactory.createFromTime((Integer)this.HH, (Integer)this.MM, this.mSecond, this.zone);
    }

    public final void dateTypeL() throws ParseException {
        this.dateL();
        if (this.jj_2_57(3)) {
            this.timeZoneModifierL();
        }
        this.jj_consume_token(0);
    }

    public final IDateTimeValueType dateTypeV() throws ParseException {
        this.dateV();
        if (this.jj_2_58(3)) {
            this.timeZoneModifierV();
        }
        this.jj_consume_token(0);
        return DateTimeFactory.createFromDate(this.yy, (Integer)this.mm, (Integer)this.dd, this.zone);
    }

    public final void yearMonthTypeL() throws ParseException {
        this.yearL();
        this.jj_consume_token(4);
        this.month();
        if (this.jj_2_59(3)) {
            this.timeZoneModifierL();
        }
        this.jj_consume_token(0);
    }

    public final IDateTimeValueType yearMonthTypeV() throws ParseException {
        this.yearV();
        this.jj_consume_token(4);
        this.month();
        if (this.jj_2_60(3)) {
            this.timeZoneModifierV();
        }
        this.jj_consume_token(0);
        return DateTimeFactory.createFromDate(this.yy, (Integer)this.mm, null, this.zone);
    }

    public final void yearTypeL() throws ParseException {
        this.yearL();
        if (this.jj_2_61(3)) {
            this.timeZoneModifierL();
        }
        this.jj_consume_token(0);
    }

    public final IDateTimeValueType yearTypeV() throws ParseException {
        this.yearV();
        if (this.jj_2_62(3)) {
            this.timeZoneModifierV();
        }
        this.jj_consume_token(0);
        return DateTimeFactory.createFromDate(this.yy, null, null, this.zone);
    }

    public final void monthDayTypeL() throws ParseException {
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        this.month();
        this.jj_consume_token(4);
        this.day();
        if (this.jj_2_63(3)) {
            this.timeZoneModifierL();
        }
        this.jj_consume_token(0);
        if (this.dd.intValue() >= Util.maximumDayInMonthFor(4, this.mm.intValue())) {
            throw new ParseException();
        }
    }

    public final IDateTimeValueType monthDayTypeV() throws ParseException {
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        this.month();
        this.jj_consume_token(4);
        this.day();
        if (this.jj_2_64(3)) {
            this.timeZoneModifierV();
        }
        this.jj_consume_token(0);
        if (this.dd.intValue() >= Util.maximumDayInMonthFor(4, this.mm.intValue())) {
            throw new ParseException();
        }
        return DateTimeFactory.createFromDate(null, (Integer)this.mm, (Integer)this.dd, this.zone);
    }

    public final void dayTypeL() throws ParseException {
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        this.day();
        if (this.jj_2_65(3)) {
            this.timeZoneModifierL();
        }
        this.jj_consume_token(0);
    }

    public final IDateTimeValueType dayTypeV() throws ParseException {
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        this.day();
        if (this.jj_2_66(3)) {
            this.timeZoneModifierV();
        }
        this.jj_consume_token(0);
        return DateTimeFactory.createFromDate(null, null, (Integer)this.dd, this.zone);
    }

    public final void monthTypeL() throws ParseException {
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        this.month();
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        if (this.jj_2_67(3)) {
            this.timeZoneModifierL();
        }
        this.jj_consume_token(0);
    }

    public final IDateTimeValueType monthTypeV() throws ParseException {
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        this.month();
        this.jj_consume_token(4);
        this.jj_consume_token(4);
        if (this.jj_2_68(3)) {
            this.timeZoneModifierV();
        }
        this.jj_consume_token(0);
        return DateTimeFactory.createFromDate(null, (Integer)this.mm, null, this.zone);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_1();
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_2();
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_3();
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_4();
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_5();
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_6();
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_7();
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_8();
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_9();
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_10();
    }

    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_11();
    }

    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_12();
    }

    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_13();
    }

    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_14();
    }

    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_15();
    }

    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_16();
    }

    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_17();
    }

    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_18();
    }

    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_19();
    }

    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_20();
    }

    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_21();
    }

    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_22();
    }

    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_23();
    }

    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_24();
    }

    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_25();
    }

    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_26();
    }

    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_27();
    }

    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_28();
    }

    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_29();
    }

    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_30();
    }

    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_31();
    }

    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_32();
    }

    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_33();
    }

    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_34();
    }

    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_35();
    }

    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_36();
    }

    private final boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_37();
    }

    private final boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_38();
    }

    private final boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_39();
    }

    private final boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_40();
    }

    private final boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_41();
    }

    private final boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_42();
    }

    private final boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_43();
    }

    private final boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_44();
    }

    private final boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_45();
    }

    private final boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_46();
    }

    private final boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_47();
    }

    private final boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_48();
    }

    private final boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_49();
    }

    private final boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_50();
    }

    private final boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_51();
    }

    private final boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_52();
    }

    private final boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_53();
    }

    private final boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_54();
    }

    private final boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_55();
    }

    private final boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_56();
    }

    private final boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_57();
    }

    private final boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_58();
    }

    private final boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_59();
    }

    private final boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_60();
    }

    private final boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_61();
    }

    private final boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_62();
    }

    private final boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_63();
    }

    private final boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_64();
    }

    private final boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_65();
    }

    private final boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_66();
    }

    private final boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_67();
    }

    private final boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_68();
    }

    private final boolean jj_3R_6() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_38()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_24() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_18() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_34() {
        if (this.jj_3R_6()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_32() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_25() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_26() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_5() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_27() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_26()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_19() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_28() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_23() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_17() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_37() {
        if (this.jj_3R_6()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_12() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_36() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_35() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_32()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_33()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_35()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_36()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_37()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_31() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_30() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_29() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_23()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_30()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_31()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_13() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_11() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_22() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_21() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_3()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_21()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_22()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_20() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_18()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_16() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_15() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_14() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_15()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_16()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_3()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_1()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_3R_4()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_68() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_1()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_67() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_3R_2()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_51() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_50() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_51()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_66() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_48() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_65() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_47() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_48()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_64() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_44() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_63() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_43() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_44()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_7()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_45()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_46()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_45() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_62() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_40() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_60() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_39() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_61() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_40()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_7()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_59() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_42()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_41() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_7() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_58() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_57() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_54() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_56() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_53() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_38() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_33() {
        if (this.jj_3R_6()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_55() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public ISO8601Parser(InputStream stream) {
        this.jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        this.token_source = new ISO8601ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public ISO8601Parser(Reader stream) {
        this.jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        this.token_source = new ISO8601ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public ISO8601Parser(ISO8601ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(ISO8601ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? ISO8601ParserConstants.tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

