/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceBindingImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

public class SpecificationLinkImpl
extends RegistryObjectImpl
implements SpecificationLink,
Serializable {
    private Concept registryObject;
    private InternationalString usageDescription;
    private ArrayList usageParameters = new ArrayList();
    private ServiceBinding serviceBinding;

    public SpecificationLinkImpl() {
        this.usageDescription = new InternationalStringImpl();
    }

    public RegistryObject getSpecificationObject() {
        return this.registryObject;
    }

    public void setSpecificationObject(RegistryObject registryObject) throws JAXRException {
        if (!(registryObject instanceof Concept)) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:For_UDDI_provider,_object_must_be_a_Concept"));
        }
        this.registryObject = (Concept)registryObject;
        this.setIsModified(true);
    }

    public InternationalString getUsageDescription() {
        return this.usageDescription;
    }

    public void setUsageDescription(InternationalString internationalString) {
        this.usageDescription = internationalString;
        this.setIsModified(true);
    }

    public Collection getUsageParameters() {
        return (Collection)this.usageParameters.clone();
    }

    public void setUsageParameters(Collection collection) throws JAXRException {
        if (collection == null) {
            this.usageParameters.clear();
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof String) continue;
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:usage_parameters_must_be_strings"));
            }
            this.usageParameters = new ArrayList(collection);
        }
        this.setIsModified(true);
    }

    public ServiceBinding getServiceBinding() {
        return this.serviceBinding;
    }

    public void setServiceBinding(ServiceBinding serviceBinding) {
        this.serviceBinding = serviceBinding;
    }

    public void addExternalLink(ExternalLink externalLink) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (externalLink != null) {
            ExternalLinkImpl externalLinkImpl = (ExternalLinkImpl)externalLink;
            externalLinkImpl.addLinkedObject(this);
            this.externalLinks.add(externalLinkImpl);
            this.setIsModified(true);
        }
    }

    public void addExternalLinks(Collection collection) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (collection != null) {
            if (collection.size() > 1) {
                throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:Cannot_add_more_than_one_ExternalLink"));
            }
            Iterator iterator = collection.iterator();
            try {
                while (iterator.hasNext()) {
                    this.addExternalLink((ExternalLink)iterator.next());
                }
            }
            catch (ClassCastException classCastException) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:Objects_in_collection_must_be_ExternalLinks"), (Throwable)classCastException);
            }
        }
    }

    public void setExternalLinks(Collection collection) throws JAXRException {
        if (collection == null) {
            this.externalLinks.clear();
            return;
        }
        if (collection.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:Cannot_set_more_than_one_link."));
        }
        this.externalLinks.clear();
        this.addExternalLinks(collection);
    }

    public Key getKey() throws JAXRException {
        if (this.serviceBinding == null || this.serviceBinding.getKey() == null) {
            return null;
        }
        Service service = this.serviceBinding.getService();
        if (service == null || service.getKey() == null) {
            return null;
        }
        if (this.registryObject == null || this.registryObject.getKey() == null) {
            return null;
        }
        int n = ((ServiceBindingImpl)this.serviceBinding).getSequenceId(this);
        String string = service.getKey().getId() + ":" + this.serviceBinding.getAccessURI() + ":" + this.serviceBinding.getKey().getId() + ":" + n + ":" + this.registryObject.getKey().getId();
        return new KeyImpl(string);
    }
}

