/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.marshaller;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class SingleByteEncoder
extends CharsetEncoder {
    private final short[] index1;
    private final String index2;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected SingleByteEncoder(Charset cs, short[] index1, String index2, int mask1, int mask2, int shift) {
        super(cs, 1.0f, 1.0f);
        this.index1 = index1;
        this.index2 = index2;
        this.mask1 = mask1;
        this.mask2 = mask2;
        this.shift = shift;
    }

    public boolean canEncode(char c) {
        char testEncode = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
        return testEncode != '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
        int sl;
        char[] sa = src.array();
        int sp = src.arrayOffset() + src.position();
        sp = sp <= (sl = src.arrayOffset() + src.limit()) ? sp : sl;
        byte[] da = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int dl = dst.arrayOffset() + dst.limit();
        dp = dp <= dl ? dp : dl;
        try {
            while (sp < sl) {
                char c = sa[sp];
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, sa, sp, sl) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (dl - dp < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char e = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
                if (e == '\u0000' && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                ++sp;
                da[dp++] = (byte)e;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
        CoderResult coderResult;
        int mark;
        block9: {
            CoderResult coderResult2;
            block13: {
                CoderResult coderResult3;
                block12: {
                    CoderResult coderResult4;
                    block11: {
                        CoderResult coderResult5;
                        mark = src.position();
                        try {
                            while (true) {
                                if (!src.hasRemaining()) {
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block9;
                                }
                                char c = src.get();
                                if (Surrogate.is(c)) {
                                    if (this.sgp.parse(c, src) < 0) {
                                        CoderResult coderResult6 = this.sgp.error();
                                        Object var10_9 = null;
                                        src.position(mark);
                                        return coderResult6;
                                    }
                                    coderResult5 = this.sgp.unmappableResult();
                                    break;
                                }
                                if (c >= '\ufffe') {
                                    coderResult4 = CoderResult.unmappableForLength(1);
                                    break block11;
                                }
                                if (!dst.hasRemaining()) {
                                    coderResult3 = CoderResult.OVERFLOW;
                                    break block12;
                                }
                                char e = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
                                if (e == '\u0000' && c != '\u0000') {
                                    coderResult2 = CoderResult.unmappableForLength(1);
                                    break block13;
                                }
                                ++mark;
                                dst.put((byte)e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_15 = null;
                            src.position(mark);
                            throw throwable;
                        }
                        Object var10_10 = null;
                        src.position(mark);
                        return coderResult5;
                    }
                    Object var10_11 = null;
                    src.position(mark);
                    return coderResult4;
                }
                Object var10_12 = null;
                src.position(mark);
                return coderResult3;
            }
            Object var10_13 = null;
            src.position(mark);
            return coderResult2;
        }
        Object var10_14 = null;
        src.position(mark);
        return coderResult;
    }

    protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.encodeArrayLoop(src, dst);
        }
        return this.encodeBufferLoop(src, dst);
    }

    public byte encode(char inputChar) {
        return (byte)this.index2.charAt(this.index1[(inputChar & this.mask1) >> this.shift] + (inputChar & this.mask2));
    }
}

